/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.renderer.crs;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.geotools.referencing.operation.projection.MapProjection;
import org.geotools.referencing.operation.projection.Orthographic;
import org.geotools.renderer.crs.ProjectionHandler;
import org.geotools.renderer.crs.ProjectionHandlerFactory;
import org.geotools.renderer.crs.ProjectionHandlerFinder;
import org.geotools.renderer.crs.WrappingProjectionHandler;
import org.locationtech.jts.densify.Densifier;
import org.locationtech.jts.geom.Coordinate;
import org.locationtech.jts.geom.CoordinateSequence;
import org.locationtech.jts.geom.Envelope;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.GeometryFactory;
import org.locationtech.jts.geom.LinearRing;
import org.locationtech.jts.geom.MultiPolygon;
import org.locationtech.jts.geom.Polygon;
import org.locationtech.jts.geom.impl.CoordinateArraySequence;
import org.opengis.parameter.ParameterValueGroup;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;

public class OrthographicProjectionHandlerFactory
implements ProjectionHandlerFactory {
    private static final double EPS = 0.001;
    private static final double SAFETY_BUFFER = -0.2;
    private static final int DENSIFY_DISTANCE = 1;

    @Override
    public ProjectionHandler getHandler(ReferencedEnvelope renderingEnvelope, CoordinateReferenceSystem sourceCRS, boolean wrap, int wrapLimit) throws FactoryException {
        Geometry validArea;
        if (renderingEnvelope == null) {
            return null;
        }
        CoordinateReferenceSystem targetCRS = renderingEnvelope.getCoordinateReferenceSystem();
        MapProjection mapProjection = CRS.getMapProjection(targetCRS);
        if (!(mapProjection instanceof Orthographic)) {
            return null;
        }
        ParameterValueGroup params = mapProjection.getParameterValues();
        double lo = params.parameter(MapProjection.AbstractProvider.LATITUDE_OF_ORIGIN.getName().getCode()).doubleValue();
        double cm = params.parameter(MapProjection.AbstractProvider.CENTRAL_MERIDIAN.getName().getCode()).doubleValue();
        if (Math.abs(lo) < 1.0E-6) {
            validArea = this.getEquatorialValidArea(cm, lo);
        } else if (90.0 - Math.abs(lo) < 1.0E-6) {
            validArea = this.getPolarValidArea(lo);
        } else {
            try {
                validArea = this.getObliqueValidArea(cm, lo, targetCRS);
            }
            catch (TransformException e) {
                throw new RuntimeException("Failed to compute valid area for oblique orthographic", e);
            }
        }
        return new OrthographicProjectionHandler(sourceCRS, validArea, renderingEnvelope);
    }

    private Geometry getPolarValidArea(double latitudeOrigin) {
        Polygon area = latitudeOrigin > 0.0 ? JTS.toGeometry(new Envelope(-180.0, 180.0, 0.0, 90.0)) : JTS.toGeometry(new Envelope(-180.0, 180.0, -90.0, 0.0));
        return Densifier.densify((Geometry)area, (double)1.0).buffer(-0.2);
    }

    private Geometry getEquatorialValidArea(double centralMeridian, double latitudeOrigin) {
        Polygon validArea;
        double minLat = -89.999;
        double maxLat = 89.999;
        GeometryFactory gf = new GeometryFactory();
        if (centralMeridian < -90.0) {
            Polygon p1 = JTS.toGeometry(new Envelope(centralMeridian - 90.0 + 360.0, 179.999, minLat, maxLat));
            Polygon p2 = JTS.toGeometry(new Envelope(-180.001, centralMeridian + 90.0, minLat, maxLat));
            validArea = gf.createMultiPolygon(new Polygon[]{p1, p2});
        } else if (centralMeridian > 90.0) {
            Polygon p1 = JTS.toGeometry(new Envelope(-179.999, centralMeridian + 90.0 - 360.0, minLat, maxLat));
            Polygon p2 = JTS.toGeometry(new Envelope(centralMeridian - 90.0, 179.999, minLat, maxLat));
            validArea = gf.createMultiPolygon(new Polygon[]{p1, p2});
        } else {
            validArea = JTS.toGeometry(new Envelope(centralMeridian - 90.0, centralMeridian + 90.0, minLat, maxLat));
        }
        return Densifier.densify((Geometry)validArea, (double)1.0);
    }

    private Geometry getObliqueValidArea(double centralMeridian, double latitudeOrigin, CoordinateReferenceSystem targetCRS) throws FactoryException, TransformException {
        MathTransform mt = CRS.findMathTransform(DefaultGeographicCRS.WGS84, targetCRS);
        double offset = latitudeOrigin > 0.0 ? -90.0 : 90.0;
        double[] src = new double[]{centralMeridian, latitudeOrigin + offset};
        double[] dst = new double[2];
        mt.transform(src, 0, dst, 0, 1);
        double radius = Math.abs(dst[1]);
        ArrayList<Coordinate> coords = new ArrayList<Coordinate>();
        MathTransform inverse = mt.inverse();
        Coordinate prev = null;
        double NORMAL_STEP = 1.0;
        double SMALL_STEP = 0.1;
        double step = 1.0;
        boolean closingToDateline = false;
        for (double angle = 0.0; angle < 360.0; angle += step) {
            src[0] = radius * Math.cos(Math.toRadians(angle));
            src[1] = radius * Math.sin(Math.toRadians(angle));
            inverse.transform(src, 0, dst, 0, 1);
            Coordinate curr = new Coordinate(dst[0], dst[1]);
            if (prev != null) {
                double diff = curr.x - prev.x;
                if (Math.abs(diff) > 90.0) {
                    this.join(latitudeOrigin, coords, prev, curr);
                    step = 1.0;
                } else if (Math.abs(curr.x) > 177.0 && !closingToDateline) {
                    step = 0.1;
                    coords.add(curr);
                    closingToDateline = true;
                }
            }
            if (step > 0.1) {
                coords.add(curr);
            }
            prev = curr;
        }
        coords.add((Coordinate)coords.get(0));
        GeometryFactory gf = new GeometryFactory();
        Coordinate[] array = coords.toArray(new Coordinate[coords.size()]);
        LinearRing ring = gf.createLinearRing((CoordinateSequence)new CoordinateArraySequence(array));
        Polygon polygon = gf.createPolygon(ring);
        return polygon.buffer(-0.2);
    }

    private void join(double latitudeOrigin, List<Coordinate> coords, Coordinate prev, Coordinate curr) {
        double y;
        double sxp = Math.signum(prev.x);
        double sxc = Math.signum(curr.x);
        double sy = Math.signum(latitudeOrigin);
        coords.add(new Coordinate(prev.x, prev.y));
        if (sy > 0.0) {
            for (y = (prev.y + curr.y) / 2.0; y < 90.0; y += 1.0) {
                coords.add(new Coordinate(180.0 * sxp, y));
            }
            coords.add(new Coordinate(180.0 * sxp, sy * 90.0));
            coords.add(new Coordinate(180.0 * sxc, sy * 90.0));
            y -= 1.0;
            while (y > curr.y) {
                coords.add(new Coordinate(180.0 * sxc, y));
                y -= 1.0;
            }
        } else {
            while (y > -90.0) {
                coords.add(new Coordinate(180.0 * sxp, y));
                y -= 1.0;
            }
            coords.add(new Coordinate(180.0 * sxp, sy * 90.0));
            coords.add(new Coordinate(180.0 * sxc, sy * 90.0));
            y += 1.0;
            while (y < curr.y) {
                coords.add(new Coordinate(180.0 * sxc, y));
                y += 1.0;
            }
        }
    }

    private static class OrthographicProjectionHandler
    extends ProjectionHandler {
        Geometry p1;
        Geometry p2;

        public OrthographicProjectionHandler(CoordinateReferenceSystem sourceCRS, Geometry validArea, ReferencedEnvelope renderingEnvelope) throws FactoryException {
            super(sourceCRS, validArea, renderingEnvelope, true);
            if (validArea instanceof MultiPolygon) {
                MultiPolygon mp = (MultiPolygon)validArea;
                this.p1 = mp.getGeometryN(0);
                this.p2 = mp.getGeometryN(1);
            }
        }

        @Override
        protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS) throws TransformException, FactoryException {
            return this.transformEnvelope(envelope, targetCRS, this.validArea);
        }

        protected ReferencedEnvelope transformEnvelope(ReferencedEnvelope envelope, CoordinateReferenceSystem targetCRS, Geometry validArea) throws FactoryException, TransformException {
            Polygon geometry;
            Geometry intersection;
            CoordinateReferenceSystem envelopeCRS = envelope.getCoordinateReferenceSystem();
            if (CRS.equalsIgnoreMetadata(envelopeCRS, targetCRS)) {
                return envelope;
            }
            Geometry validAreaInEnvelopeCRS = JTS.transform(validArea, CRS.findMathTransform(DefaultGeographicCRS.WGS84, envelopeCRS));
            if (validArea instanceof MultiPolygon) {
                validAreaInEnvelopeCRS = validAreaInEnvelopeCRS.buffer(0.0);
            }
            if ((intersection = (geometry = JTS.toGeometry(envelope)).intersection(validAreaInEnvelopeCRS)) == null || intersection.isEmpty()) {
                return null;
            }
            Envelope ie = intersection.getEnvelopeInternal();
            double distance = (ie.getWidth() / 10.0 + ie.getHeight() / 10.0) / 2.0;
            intersection = Densifier.densify((Geometry)intersection, (double)distance);
            Geometry transformed = JTS.transform(intersection, CRS.findMathTransform(envelopeCRS, targetCRS));
            ProjectionHandler handler = ProjectionHandlerFinder.getHandler(new ReferencedEnvelope(targetCRS), DefaultGeographicCRS.WGS84, true, Collections.emptyMap());
            if (handler == null || handler instanceof WrappingProjectionHandler) {
                return new ReferencedEnvelope(transformed.getEnvelopeInternal(), targetCRS);
            }
            ReferencedEnvelope validAreaBounds = handler.getValidAreaBounds();
            Polygon validAreaTarget = JTS.toGeometry(validAreaBounds.transform(targetCRS, true));
            Geometry reduced = transformed.intersection((Geometry)validAreaTarget);
            if (reduced == null || reduced.isEmpty()) {
                return null;
            }
            return new ReferencedEnvelope(reduced.getEnvelopeInternal(), targetCRS);
        }

        @Override
        public List<ReferencedEnvelope> getQueryEnvelopes() throws TransformException, FactoryException {
            if (this.p1 == null) {
                return super.getQueryEnvelopes();
            }
            ReferencedEnvelope e1 = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS, this.p1);
            ReferencedEnvelope e2 = this.transformEnvelope(this.renderingEnvelope, this.sourceCRS, this.p2);
            if (e1 != null && e2 != null && e1.intersects(e2)) {
                e1.expandToInclude(e2);
                return Collections.singletonList(e1);
            }
            ArrayList<ReferencedEnvelope> result = new ArrayList<ReferencedEnvelope>();
            if (e1 != null) {
                result.add(e1);
            }
            if (e2 != null) {
                result.add(e2);
            }
            return result;
        }
    }
}

