/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.backgroundrunner;

import com.siggemannen.functional.throwing.ThrowingRunnable;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;

public class TriggeredDelayTaskRunner {
    private final ThrowingRunnable task;
    private final int misfireDelayIgnoreMs;
    private final List<Integer> delaySteps;
    private boolean cancel = false;
    private int currentStep = 0;
    private final AtomicBoolean started = new AtomicBoolean(false);
    private static final int MIN_RESOLUTION = 50;
    private final int resolution;
    private LocalDateTime triggerDate;
    private Thread t;

    public TriggeredDelayTaskRunner(ThrowingRunnable task, int misfireDelayIgnoreMs, List<Integer> delaySteps) {
        if (delaySteps == null || delaySteps.size() == 0) {
            throw new IllegalArgumentException("At least one delay step is required to be set");
        }
        this.task = task;
        this.misfireDelayIgnoreMs = misfireDelayIgnoreMs;
        this.delaySteps = delaySteps;
        this.resolution = Math.max(50, (int)((double)((Integer)delaySteps.stream().min(Integer::compareTo).get()).intValue() / 10.0));
    }

    public void cancel() {
        this.cancel = true;
        if (this.t != null) {
            this.t.interrupt();
            this.t = null;
        }
    }

    public synchronized void trigger() {
        if (this.started.compareAndSet(false, true)) {
            if (this.t != null) {
                this.t.interrupt();
                return;
            }
            this.t = new Thread(this::startLoop);
            if (this.task.getName() != null) {
                this.t.setName(this.task.getName());
            }
            this.t.setDaemon(true);
            this.t.start();
            return;
        }
        if (this.misfireDelayIgnoreMs == 0 || this.triggerDate == null || LocalDateTime.now().minus(Duration.ofMillis(this.misfireDelayIgnoreMs)).compareTo(this.triggerDate) > 0) {
            this.triggerDate = LocalDateTime.now();
            ++this.currentStep;
        } else {
            this.triggerDate = LocalDateTime.now();
        }
    }

    private void startLoop() {
        this.triggerDate = LocalDateTime.now();
        while (!this.cancel) {
            try {
                Thread.sleep(this.resolution);
            }
            catch (InterruptedException e) {
                break;
            }
            if (!this.checkIfWeShouldFire()) continue;
            this.reset();
            this.task.run();
            try {
                Thread.sleep(Integer.MAX_VALUE);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private void reset() {
        this.currentStep = 0;
        this.cancel = false;
        this.triggerDate = LocalDateTime.now();
        this.started.set(false);
    }

    private boolean checkIfWeShouldFire() {
        if (this.currentStep >= this.delaySteps.size()) {
            this.currentStep = this.delaySteps.size() - 1;
        }
        int delayStep = this.delaySteps.get(this.currentStep);
        return LocalDateTime.now().minus(Duration.ofMillis(delayStep)).compareTo(this.triggerDate) > 0;
    }
}

