/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.backgroundrunner;

import com.siggemannen.functional.throwing.ThrowingRunnable;
import java.util.Hashtable;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public final class AccumulatedBackgroundRunner {
    private static final Map<String, ScheduledFuture> JOB_MAP = new Hashtable<String, ScheduledFuture>();
    private static final ScheduledExecutorService THREAD_POOL = Executors.newScheduledThreadPool(5);

    private AccumulatedBackgroundRunner() {
    }

    public static void schedule(String taskId, ThrowingRunnable runnable, int delay, TimeUnit delayUnit) {
        ScheduledFuture future = JOB_MAP.get(taskId);
        if (future != null) {
            future.cancel(false);
        }
        JOB_MAP.put(taskId, THREAD_POOL.schedule(() -> AccumulatedBackgroundRunner.runAndRemoveFromSchedule(taskId, runnable), (long)delay, delayUnit));
    }

    private static void runAndRemoveFromSchedule(String taskId, ThrowingRunnable r) {
        String name = Thread.currentThread().getName();
        if (name == null || !name.contains(taskId)) {
            Thread.currentThread().setName(String.valueOf(name) + ", executing: " + taskId);
        }
        try {
            r.run();
        }
        finally {
            JOB_MAP.remove(taskId);
            Thread.currentThread().setName(name);
        }
    }
}

