/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.gribbs;

import com.siggemannen.gribbs.IVariableData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Optional;
import ucar.nc2.Attribute;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class Utils {
    public static Variable findGeospatVariable(NetcdfFile ncfile) {
        for (Variable v : ncfile.getVariables()) {
            if (v.getDimensions().size() < 3) continue;
            return v;
        }
        return null;
    }

    public static Double getDoubleValue(Attribute a) {
        return a.getNumericValue().doubleValue();
    }

    public static Variable findGeospatVariable(NetcdfFile ncfile, boolean hasTime) {
        ArrayList<Variable> potentials = new ArrayList<Variable>();
        for (Variable v : ncfile.getVariables()) {
            if (v.getDimensions().size() < 2 + (hasTime ? 1 : 0)) continue;
            potentials.add(v);
        }
        if (potentials.size() == 0) {
            return null;
        }
        potentials.sort(Comparator.comparingLong(Utils::size).reversed());
        return (Variable)potentials.get(0);
    }

    private static long size(Variable v) {
        long l = 1L;
        int x = 0;
        while (x < v.getShape().length) {
            l *= (long)v.getShape()[x];
            ++x;
        }
        return l;
    }

    public static Variable findGeospatVariable(NetcdfFile ncfile, IVariableData data, boolean hasTime) {
        String[] stringArray = data.getVariableBindings();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String s = stringArray[n2];
            Variable v = ncfile.findVariable(s);
            if (v != null) {
                return v;
            }
            ++n2;
        }
        return Utils.findGeospatVariable(ncfile, hasTime);
    }

    public static Optional<Variable> findByNameOrArray(NetcdfFile ncfile, IVariableData data, String ... namesForAutoDetect) {
        if (data.isAutodetected()) {
            String[] stringArray = namesForAutoDetect;
            int n = namesForAutoDetect.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                Variable v = ncfile.findVariable(s);
                if (v != null) {
                    return Optional.of(v);
                }
                ++n2;
            }
            return Optional.empty();
        }
        String[] stringArray = data.getVariableBindings();
        int n = stringArray.length;
        int n3 = 0;
        while (n3 < n) {
            String s = stringArray[n3];
            Variable v = ncfile.findVariable(s);
            if (v != null) {
                return Optional.of(v);
            }
            ++n3;
        }
        return Optional.empty();
    }

    public static Variable find2DVariable(NetcdfFile ncfile) {
        for (Variable v : ncfile.getVariables()) {
            if (v.getDimensions().size() < 2) continue;
            return v;
        }
        return null;
    }
}

