/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.gribbs;

import java.util.function.BiConsumer;
import java.util.function.Supplier;

public class ComposableStream {
    private final int runs;
    private ComposableStream child;
    private ComposableStream current;
    private final BiConsumer<Integer, Integer> runt;
    private int level = 0;

    public ComposableStream(int runs, BiConsumer<Integer, Integer> runt) {
        this.runs = runs;
        this.runt = runt;
    }

    public ComposableStream(BiConsumer<Integer, Integer> runt, int ... runs) {
        this.runs = runs.length == 0 ? 1 : runs[0];
        this.runt = runt;
        int i = 1;
        while (i < runs.length) {
            this.compose(runs[i]);
            ++i;
        }
    }

    public ComposableStream compose(int runs) {
        return this.compose(runs, this.runt);
    }

    public ComposableStream compose(int runs, BiConsumer<Integer, Integer> runt) {
        ComposableStream stream = new ComposableStream(runs, runt);
        if (this.current == null) {
            this.child = stream;
            stream.level = this.level + 1;
        } else {
            this.current.child = stream;
            stream.level = this.current.level + 1;
        }
        this.current = stream;
        return this;
    }

    public ComposableStream composeIf(Supplier<Boolean> truthSupplier, Supplier<Integer> runs, BiConsumer<Integer, Integer> runt) {
        if (truthSupplier.get().booleanValue()) {
            return this.compose(runs.get(), runt);
        }
        return this;
    }

    public ComposableStream composeIf(Supplier<Boolean> truthSupplier, Supplier<Integer> runs) {
        return this.composeIf(truthSupplier, runs, this.runt);
    }

    public ComposableStream composeIf(Supplier<Boolean> truthSupplier, int runs) {
        return this.composeIf(truthSupplier, () -> runs, this.runt);
    }

    public ComposableStream composeIf(boolean truth, int runs) {
        return this.composeIf(() -> truth, () -> runs, this.runt);
    }

    public void run() {
        this.run(() -> {});
    }

    public void run(Runnable r) {
        int i = 0;
        while (i < this.runs) {
            this.runt.accept(this.level, i);
            if (this.child != null) {
                this.child.run(r);
            } else {
                r.run();
            }
            ++i;
        }
    }
}

