/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.util;

import java.awt.AWTException;
import java.awt.DisplayMode;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.imageio.ImageIO;

public class Screenshot {
    private final BufferedImage image;
    private static Robot robot;

    public static final Screenshot capture(Rectangle screenRect) throws AWTException {
        return new Screenshot(Screenshot.getRobot().createScreenCapture(screenRect));
    }

    public static final Screenshot capture(int width, int height) throws AWTException {
        return Screenshot.capture(new Rectangle(width, height));
    }

    private static synchronized Robot getRobot() throws AWTException {
        if (robot == null) {
            robot = new Robot();
        }
        return robot;
    }

    private Screenshot(BufferedImage image) {
        this.image = image;
    }

    public Image getImage() {
        return this.image;
    }

    public boolean store(String formatName, File output) throws IOException {
        return ImageIO.write((RenderedImage)this.image, formatName, output);
    }

    public static final List<DisplayMode> getDisplayInfo() {
        ArrayList<DisplayMode> result = new ArrayList<DisplayMode>();
        GraphicsDevice[] graphicsDeviceArray = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices();
        int n = graphicsDeviceArray.length;
        int n2 = 0;
        while (n2 < n) {
            GraphicsDevice gs = graphicsDeviceArray[n2];
            result.add(gs.getDisplayMode());
            ++n2;
        }
        return result;
    }
}

