/*
 * Decompiled with CFR 0.152.
 */
package org.oxbow.swingbits.table.filter;

import com.siggemannen.view.UIBackgroundRunner;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.function.Predicate;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.JToolBar;
import javax.swing.SpinnerListModel;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import org.oxbow.swingbits.list.ActionCheckListModel;
import org.oxbow.swingbits.list.CheckList;
import org.oxbow.swingbits.list.CheckListFilterType;
import org.oxbow.swingbits.list.DefaultCheckListModel;
import org.oxbow.swingbits.list.ICheckListModel;
import org.oxbow.swingbits.list.IListFilter;
import org.oxbow.swingbits.misc.JSearchTextField;
import org.oxbow.swingbits.popup.PopupWindow;
import org.oxbow.swingbits.table.filter.DistinctColumnItem;
import org.oxbow.swingbits.table.filter.ITableFilter;
import org.oxbow.swingbits.table.filter.TableAwareCheckListRenderer;
import org.oxbow.swingbits.table.filter.TriFunction;
import org.oxbow.swingbits.util.CollectionUtils;
import org.oxbow.swingbits.util.IObjectToStringTranslator;

class TableFilterColumnPopup
extends PopupWindow
implements MouseListener {
    private boolean enabled = false;
    private final CheckList<DistinctColumnItem> filterList = new CheckList.Builder().build();
    private final JSearchTextField searchField = new JSearchTextField();
    private final Map<Integer, ColumnAttrs> colAttrs = new HashMap<Integer, ColumnAttrs>();
    private int mColumnIndex = -1;
    private final ITableFilter<?> filter;
    private boolean searchable;
    private IListFilter searchFilter = CheckListFilterType.CONTAINS;
    private IObjectToStringTranslator translator;
    private boolean actionsVisible = true;
    private boolean useTableRenderers = false;
    ResourceBundle bundle = ResourceBundle.getBundle("task-dialog");
    private JSpinner spinner;
    private JTextField predicateField;
    private final TriFunction<Integer, String, String, Predicate> predicator;

    public TableFilterColumnPopup(ITableFilter<?> filter) {
        this(filter, null);
    }

    public TableFilterColumnPopup(ITableFilter<?> filter, TriFunction<Integer, String, String, Predicate> predicator) {
        super(true);
        this.predicator = predicator;
        this.filter = filter;
        this.filterList.getList().setVisibleRowCount(8);
        this.setupTableHeader();
        ((Container)filter.getTable()).addPropertyChangeListener("tableHeader", evt -> this.setupTableHeader());
        ((Container)filter.getTable()).addPropertyChangeListener("model", evt -> this.colAttrs.clear());
        this.searchField.getDocument().addDocumentListener(this.docListener());
    }

    private DocumentListener docListener() {
        return new DocumentListener(){

            @Override
            public void removeUpdate(DocumentEvent e) {
                TableFilterColumnPopup.this.perform();
            }

            @Override
            public void insertUpdate(DocumentEvent e) {
                TableFilterColumnPopup.this.perform();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
            }
        };
    }

    private void perform() {
        this.filterList.filter(this.searchField.getText(), this.translator, this.searchFilter, this.predicateField == null || this.predicateField.getText().isEmpty() || this.predicator == null ? null : this.predicator.apply(this.mColumnIndex, (String)this.spinner.getModel().getValue(), this.predicateField.getText()));
    }

    public void setSearchable(boolean searchable) {
        this.searchable = searchable;
    }

    public void setSearchTranslator(IObjectToStringTranslator tranlsator) {
        this.translator = tranlsator;
    }

    public void setSearchFilter(IListFilter searchFilter) {
        this.searchFilter = searchFilter;
    }

    public void setActionsVisible(boolean actionsVisible) {
        this.actionsVisible = actionsVisible;
    }

    public void setUseTableRenderers(boolean reuseRenderers) {
        this.useTableRenderers = reuseRenderers;
    }

    private void setupTableHeader() {
        JTableHeader header = ((JTable)this.filter.getTable()).getTableHeader();
        if (header != null) {
            header.addMouseListener(this);
        }
    }

    @Override
    protected JComponent buildContent() {
        JPanel owner = new JPanel(new BorderLayout(3, 3));
        owner.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        owner.setPreferredSize(new Dimension(350, 250));
        Box commands = new Box(2);
        JToolBar toolbar = new JToolBar();
        toolbar.setFloatable(false);
        toolbar.setOpaque(false);
        toolbar.add(new PopupWindow.CommandAction(this, this.bundle.getString("Clear_ALL_COLUMN_FILTERS"), new ImageIcon(this.getClass().getResource("funnel_delete.png"))){

            @Override
            protected boolean perform() {
                return TableFilterColumnPopup.this.clearAllFilters();
            }
        });
        if (this.predicator != null) {
            JPanel jp = new JPanel(new BorderLayout());
            SpinnerListModel model = new SpinnerListModel(Arrays.asList("=", ">=", "<=", "contains"));
            model.addChangeListener(e -> {
                if (this.predicateField.getText().length() > 0) {
                    this.perform();
                }
            });
            this.spinner = new JSpinner(model);
            this.spinner.setEditor(new JSpinner.DefaultEditor(this.spinner));
            this.spinner.setMinimumSize(new Dimension(70, 25));
            this.spinner.setPreferredSize(new Dimension(70, 25));
            jp.add((Component)this.spinner, "West");
            this.predicateField = new JTextField("");
            this.predicateField.getDocument().addDocumentListener(this.docListener());
            jp.add((Component)this.predicateField, "Center");
            this.predicateField.addKeyListener(this.enterKeyListener());
            toolbar.add(jp);
        }
        commands.add(toolbar);
        commands.add(Box.createHorizontalGlue());
        commands.add(new JButton(new PopupWindow.CommandAction(this, this.bundle.getString("Apply")){

            @Override
            protected boolean perform() {
                return TableFilterColumnPopup.this.applyColumnFilter();
            }
        }));
        commands.add(Box.createHorizontalStrut(5));
        commands.add(new JButton(new PopupWindow.CommandAction(this.bundle.getString("Cancel"))));
        commands.setBorder(BorderFactory.createEmptyBorder(3, 0, 3, 0));
        commands.setBackground(UIManager.getColor("Panel.background"));
        commands.setOpaque(true);
        if (this.searchable) {
            owner.add((Component)this.searchField, "North");
        }
        owner.add((Component)new JScrollPane(this.filterList.getList()), "Center");
        owner.add((Component)commands, "South");
        this.searchField.addKeyListener(this.enterKeyListener());
        owner.invalidate();
        return owner;
    }

    private KeyAdapter enterKeyListener() {
        return new KeyAdapter(){

            @Override
            public void keyPressed(KeyEvent e) {
                if (e.getKeyCode() == 10) {
                    TableFilterColumnPopup.this.applyColumnFilter();
                    TableFilterColumnPopup.this.hide();
                }
            }
        };
    }

    private boolean applyColumnFilter() {
        Collection<DistinctColumnItem> checked = this.filterList.getCheckedItems();
        ICheckListModel<DistinctColumnItem> model = this.filterList.getModel();
        model.filter("", this.translator, CheckListFilterType.CONTAINS, null);
        this.filter.apply(this.mColumnIndex, checked);
        return true;
    }

    private boolean clearAllFilters() {
        this.filter.clear();
        return true;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    @Override
    public void mousePressed(MouseEvent e) {
        if (this.enabled && e.isPopupTrigger()) {
            this.showFilterPopup(e);
        }
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        if (this.enabled && e.isPopupTrigger()) {
            this.showFilterPopup(e);
        }
    }

    private void showFilterPopup(MouseEvent e) {
        JTableHeader header = (JTableHeader)e.getSource();
        TableColumnModel colModel = ((JTable)this.filter.getTable()).getColumnModel();
        int vColumnIndex = colModel.getColumnIndexAtX(e.getX());
        if (vColumnIndex < 0) {
            return;
        }
        Rectangle headerRect = ((JTable)this.filter.getTable()).getTableHeader().getHeaderRect(vColumnIndex);
        if (vColumnIndex == 0) {
            headerRect.width -= 2;
        } else {
            headerRect.grow(-2, 0);
        }
        if (!headerRect.contains(e.getX(), e.getY())) {
            return;
        }
        this.mColumnIndex = ((JTable)this.filter.getTable()).convertColumnIndexToModel(vColumnIndex);
        this.setPreferredSize(this.getColumnAttrs((int)vColumnIndex).preferredSize);
        UIBackgroundRunner.execute(null, () -> this.filter.getDistinctColumnItems(this.mColumnIndex), distinctItems -> {
            DefaultCheckListModel model = new DefaultCheckListModel(distinctItems);
            this.filterList.setModel(this.actionsVisible ? new ActionCheckListModel(model) : model);
            Collection<DistinctColumnItem> checked = this.filter.getFilterState(this.mColumnIndex);
            this.filterList.setCheckedItems(CollectionUtils.isEmpty(checked) ? distinctItems : checked);
            if (this.useTableRenderers) {
                this.filterList.getList().setCellRenderer(new TableAwareCheckListRenderer((JTable)this.filter.getTable(), vColumnIndex));
            }
            SwingUtilities.invokeLater(() -> this.show(header, rectangle.x, header.getHeight()));
        });
    }

    private ColumnAttrs getColumnAttrs(int column) {
        ColumnAttrs attrs = this.colAttrs.get(column);
        if (attrs == null) {
            attrs = new ColumnAttrs();
            this.colAttrs.put(column, attrs);
        }
        return attrs;
    }

    @Override
    protected void beforeShow() {
        if (this.searchable) {
            SwingUtilities.invokeLater(() -> {
                this.searchField.setText("");
                this.searchField.requestFocusInWindow();
            });
        }
        if (this.predicator != null) {
            SwingUtilities.invokeLater(() -> this.predicateField.setText(""));
        }
    }

    @Override
    public void beforeHide() {
        this.getColumnAttrs((int)this.mColumnIndex).preferredSize = this.getPreferredSize();
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    static class ColumnAttrs {
        public Dimension preferredSize;

        ColumnAttrs() {
        }
    }
}

