/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.table;

import com.sigge.dbrunner.table.DataType;
import java.util.Optional;

public class ColumnType {
    private final DataType type;
    private final Optional<Integer> length;
    private final Optional<Integer> precision;
    public static final ColumnType INT = new ColumnType(DataType.INT);
    public static final ColumnType LONG = new ColumnType(DataType.LONG);
    public static final ColumnType FLOAT = new ColumnType(DataType.FLOAT, 0, 53);
    public static final ColumnType DATETIME = new ColumnType(DataType.DATETIME);
    public static final ColumnType VARBINARY = new ColumnType(DataType.VARBINARY);
    public static final ColumnType TEXT = new ColumnType(DataType.TEXT);
    private final boolean isIdentity;

    public ColumnType(DataType type) {
        this(type, Optional.empty(), Optional.empty());
    }

    public ColumnType(DataType type, int length, int precision) {
        this(type, Optional.of(length), Optional.of(precision));
    }

    public ColumnType(DataType type, Optional<Integer> length, Optional<Integer> precision) {
        this(type, length, precision, false);
    }

    public ColumnType(DataType type, Optional<Integer> length, Optional<Integer> precision, boolean isIdentity) {
        this.type = type;
        this.length = length;
        this.precision = precision;
        this.isIdentity = isIdentity;
    }

    public DataType getType() {
        return this.type;
    }

    public Optional<Integer> getLength() {
        return this.length;
    }

    public Optional<Integer> getPrecision() {
        return this.precision;
    }

    public boolean isIdentity() {
        return this.isIdentity;
    }

    public String toString() {
        return (Object)((Object)this.type) + this.length.filter(f -> f > 0).map(f -> " (" + f.toString() + ")").orElse("");
    }
}

