/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.table;

import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.DataType;
import com.sigge.dbrunner.table.IBinder;
import com.sigge.dbrunner.table.IBulk;
import com.sigge.dbrunner.table.ITable;
import com.sigge.dbrunner.table.ITableOperator;
import com.sigge.dbrunner.table.ManualBulker;
import com.sigge.dbrunner.table.Table;
import com.sigge.dbrunner.table.TableException;
import com.sigge.dbrunner.table.TableNotExistsException;
import java.io.IOException;
import java.io.StringReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;

public abstract class ATableOperator
implements ITableOperator {
    protected final IDatabaseOperator operator;
    protected final Map<String, IScriptRunner> runners = new HashMap<String, IScriptRunner>();

    public ATableOperator(IDatabaseOperator operator) {
        this.operator = operator;
    }

    @Override
    public void close() throws IOException {
        for (IScriptRunner runner : this.runners.values()) {
            runner.closeConnection();
        }
        this.runners.clear();
    }

    @Override
    public ITable create(String database, String name, String schema, List<Column> columns) throws TableException, SQLException {
        IScriptRunner runner = this.getOrCreateRunnerFromPool(database);
        StringBuilder sb = new StringBuilder(" CREATE TABLE ");
        if (schema != null && schema.length() > 0) {
            sb.append(schema).append(".");
        }
        sb.append(name).append(" (");
        int i = 0;
        while (i < columns.size()) {
            Column ct;
            if (i > 0) {
                sb.append(",");
            }
            if ((ct = columns.get(i)).getStandardType().isPresent()) {
                sb.append(this.getNativeColumnDefinition(ct));
            } else {
                sb.append(this.getRawColumnDefinition(ct));
            }
            ++i;
        }
        sb.append(")");
        runner.changeDatabase(database);
        try {
            runner.runScript(new StringReader(sb.toString()), Collections.EMPTY_LIST, new SQLOptions());
        }
        catch (Exception e) {
            if (e instanceof SQLException) {
                throw (SQLException)e;
            }
            throw new TableException("Table exist or some other error occured", e);
        }
        return this.open(database, name, schema);
    }

    /*
     * Loose catch block
     */
    @Override
    public ITable open(String database, String name, String schema) throws TableException, SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try {
            Table table;
            ResultSet rs;
            Connection c;
            block70: {
                block69: {
                    c = this.operator.getDatabase().createConnection(database, new SQLOptions());
                    rs = c.getMetaData().getColumns(database, schema, name, null);
                    ArrayList<Column> cols = new ArrayList<Column>();
                    Table t = new Table(database, name, schema, cols, this);
                    while (rs.next()) {
                        ColumnType ct;
                        String columnname = rs.getString("COLUMN_NAME");
                        String type = rs.getString("TYPE_NAME").toUpperCase();
                        Optional<Integer> length = Optional.empty();
                        Optional<Integer> precision = Optional.empty();
                        int len = rs.getInt("COLUMN_SIZE");
                        if (!rs.wasNull()) {
                            length = Optional.of(len);
                        }
                        int prec2 = rs.getInt("DECIMAL_DIGITS");
                        if (!rs.wasNull()) {
                            precision = Optional.of(prec2);
                        }
                        switch (type) {
                            case "TINYINT": 
                            case "BIT": 
                            case "INT": 
                            case "SMALLINT": {
                                ct = new ColumnType(DataType.INT);
                                break;
                            }
                            case "BIGINT": {
                                ct = new ColumnType(DataType.LONG);
                                break;
                            }
                            case "REAL": 
                            case "FLOAT": 
                            case "MONEY": {
                                ct = new ColumnType(DataType.FLOAT);
                                break;
                            }
                            case "DECIMAL": 
                            case "NUMERIC": {
                                ct = new ColumnType(DataType.NUMERIC, length, precision);
                                break;
                            }
                            case "DATETIME2": 
                            case "DATETIME": 
                            case "DATE": 
                            case "TIME": {
                                ct = new ColumnType(DataType.DATETIME);
                                break;
                            }
                            case "TEXT": 
                            case "NTEXT": {
                                ct = new ColumnType(DataType.TEXT);
                                break;
                            }
                            case "VARCHAR": {
                                if (len == -1) {
                                    ct = new ColumnType(DataType.TEXT);
                                    break;
                                }
                                ct = new ColumnType(DataType.VARCHAR, len, 0);
                                break;
                            }
                            case "NVARCHAR": {
                                if (len == -1) {
                                    ct = new ColumnType(DataType.TEXT);
                                    break;
                                }
                                ct = new ColumnType(DataType.VARCHAR, len / 2, 0);
                                break;
                            }
                            default: {
                                ct = new ColumnType(DataType.UNSUPPORTED);
                            }
                        }
                        cols.add(new Column(columnname, ct));
                    }
                    if (cols.size() == 0) {
                        throw new TableNotExistsException("No columns found, table probably doesn't exist");
                    }
                    table = t;
                    if (rs == null) break block69;
                    rs.close();
                }
                if (c == null) break block70;
                c.close();
            }
            return table;
            {
                catch (Throwable throwable2) {
                    try {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        if (throwable == null) {
                            throwable = throwable3;
                        } else if (throwable != throwable3) {
                            throwable.addSuppressed(throwable3);
                        }
                        if (c != null) {
                            c.close();
                        }
                        throw throwable;
                    }
                }
            }
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void insert(ITable table, List<Column> columns, IBinder binder) throws TableException, SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());){
            c.setAutoCommit(false);
            String finalName = this.getSafeTableName(table);
            StringBuilder sqlTemplate = new StringBuilder("INSERT INTO ").append(finalName).append("(");
            int i = 0;
            while (i < columns.size()) {
                if (i > 0) {
                    sqlTemplate.append(",");
                }
                sqlTemplate.append(this.operator.getQuotedIdentifier(columns.get(i).getName()));
                ++i;
            }
            sqlTemplate.append(")VALUES(");
            i = 0;
            while (i < columns.size()) {
                if (i > 0) {
                    sqlTemplate.append(",");
                }
                sqlTemplate.append("?");
                ++i;
            }
            sqlTemplate.append(")");
            int counter = 0;
            int batches = 800;
            Throwable throwable2 = null;
            Object var12_15 = null;
            try (PreparedStatement st = c.prepareStatement(sqlTemplate.toString());){
                while (binder.next()) {
                    int x = 0;
                    while (x < columns.size()) {
                        binder.bind(st, counter, x, x + 1);
                        ++x;
                    }
                    st.addBatch();
                    if (++counter != batches) continue;
                    st.executeBatch();
                    counter = 0;
                }
                if (counter > 0) {
                    st.executeBatch();
                }
            }
            catch (Throwable throwable3) {
                if (throwable2 == null) {
                    throwable2 = throwable3;
                } else if (throwable2 != throwable3) {
                    throwable2.addSuppressed(throwable3);
                }
                throw throwable2;
            }
            c.commit();
        }
        catch (Throwable throwable4) {
            if (throwable == null) {
                throwable = throwable4;
            } else if (throwable != throwable4) {
                throwable.addSuppressed(throwable4);
            }
            throw throwable;
        }
    }

    @Override
    public void insert(ITable table, List<ColumnMapping> mapping, IBulk bulker) throws TableException, SQLException {
        Throwable throwable = null;
        Object var5_6 = null;
        try (Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());){
            c.setAutoCommit(false);
            new ManualBulker(){}.insert(this.operator, c, this.getSafeTableName(table), mapping, bulker);
            c.commit();
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    private String getSafeTableName(ITable table) {
        String tableName = table.getName();
        String finalName = "";
        if (table.getSchema() != null && table.getSchema().length() > 0) {
            finalName = String.valueOf(finalName) + this.operator.getQuotedIdentifier(table.getSchema()) + ".";
        }
        finalName = String.valueOf(finalName) + this.operator.getQuotedIdentifier(tableName);
        return finalName;
    }

    protected Object getCreationOptions() {
        return null;
    }

    protected String getRawColumnDefinition(Column column) {
        return String.valueOf(this.operator.getQuotedIdentifier(column.getName())) + " " + column.getNativeType().get();
    }

    protected String getNativeColumnDefinition(Column column) throws TableException {
        ColumnType cp = column.getStandardType().get();
        StringBuilder sb = new StringBuilder();
        sb.append(this.operator.getQuotedIdentifier(column.getName())).append(" ");
        switch (cp.getType()) {
            case DATETIME: {
                sb.append("DATETIME");
                break;
            }
            case FLOAT: {
                sb.append("FLOAT");
                break;
            }
            case LONG: {
                sb.append("BIGINT");
                break;
            }
            case TEXT: {
                sb.append("TEXT");
                break;
            }
            case INT: {
                sb.append("INT");
                break;
            }
            case NUMERIC: {
                sb.append("NUMERIC");
                cp.getLength().ifPresent(e -> {
                    StringBuilder stringBuilder2 = sb.append("(").append(e);
                });
                cp.getPrecision().ifPresent(e -> {
                    StringBuilder stringBuilder2 = sb.append(",").append(e);
                });
                if (!cp.getLength().isPresent()) break;
                sb.append(")");
                break;
            }
            case VARCHAR: {
                sb.append("VARCHAR(");
                sb.append(cp.getLength());
                sb.append(")");
                break;
            }
            default: {
                throw new TableException("Unsupported column type: " + (Object)((Object)cp.getType()));
            }
        }
        return sb.toString();
    }

    @Override
    public void delete(ITable table) throws TableException, SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());){
            c.createStatement().execute("DROP TABLE " + this.getSafeTableName(table));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void drop(ITable table) throws TableException, SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());){
            c.createStatement().execute("DELETE  " + this.getSafeTableName(table));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    @Override
    public void truncate(ITable table) throws TableException, SQLException {
        Throwable throwable = null;
        Object var3_4 = null;
        try (Connection c = this.operator.getDatabase().createConnection(table.getDatabase(), new SQLOptions());){
            c.createStatement().execute("TRUNCATE TABLE " + this.getSafeTableName(table));
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
    }

    protected IScriptRunner getOrCreateRunnerFromPool(String databaseName) throws SQLException {
        IScriptRunner runner = this.runners.get(databaseName);
        if (runner == null) {
            runner = this.operator.getDatabase().createRunner(databaseName, this.getCreationOptions());
        }
        if (!runner.isAlive()) {
            runner.closeConnection();
            runner = this.operator.getDatabase().createRunner(databaseName, this.getCreationOptions());
        }
        this.runners.put(databaseName, runner);
        return runner;
    }

    @Override
    public Database getDatabase() {
        return this.operator.getDatabase();
    }
}

