/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.sqlserver.table;

import com.microsoft.sqlserver.jdbc.ISQLServerBulkData;
import com.sigge.dbrunner.table.Column;
import com.sigge.dbrunner.table.ColumnMapping;
import com.sigge.dbrunner.table.ColumnType;
import com.sigge.dbrunner.table.IBulk;
import java.sql.JDBCType;
import java.sql.SQLException;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.IntStream;

public class SQLServerBulk
implements ISQLServerBulkData {
    private final IBulk bulk;
    private final List<ColumnMapping> mapping;

    SQLServerBulk(List<ColumnMapping> mapping, IBulk bulk) {
        this.mapping = mapping;
        this.bulk = bulk;
    }

    public boolean next() {
        return this.bulk.next();
    }

    public Set<Integer> getColumnOrdinals() {
        return IntStream.range(1, this.mapping.size() + 1).boxed().collect(Collectors.toSet());
    }

    private Column col(int column) {
        return this.mapping.get(column - 1).getFrom();
    }

    public String getColumnName(int column) {
        return this.col(column).getName();
    }

    public int getColumnType(int column) {
        return JDBCType.LONGNVARCHAR.getVendorTypeNumber();
    }

    public int getPrecision(int column) {
        return this.col(column).getStandardType().flatMap(ColumnType::getPrecision).orElse(0);
    }

    public int getScale(int column) {
        return this.col(column).getStandardType().flatMap(ColumnType::getPrecision).orElse(0);
    }

    public Object[] getRowData() throws SQLException {
        return this.bulk.getData();
    }
}

