/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.sqlserver;

import java.util.Objects;

public class SQLServerDatabaseConfig {
    private final String serverName;
    private final String userName;
    private final String password;
    private final boolean useAD;
    private final String label;
    private final String url;
    private String applicationName;

    public SQLServerDatabaseConfig(String serverName, String userName, String password, boolean useAD, String label) {
        this.serverName = serverName;
        this.userName = userName;
        this.password = password;
        this.useAD = useAD;
        this.label = label;
        this.url = null;
    }

    public SQLServerDatabaseConfig(String url, String label) {
        this.serverName = null;
        this.userName = null;
        this.password = null;
        this.useAD = false;
        this.label = label;
        this.url = url;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.serverName == null ? 0 : this.serverName.hashCode());
        result = 31 * result + (this.userName == null ? 0 : this.userName.hashCode());
        result = 31 * result + (this.useAD ? 1 : 0);
        result = 31 * result + (this.url == null ? 0 : this.url.hashCode());
        return result;
    }

    public String getUserName() {
        return this.userName;
    }

    public String getPassword() {
        return this.password;
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isUseAD() {
        return this.useAD;
    }

    public String getLabel() {
        return this.label;
    }

    public String getUrl() {
        return this.url;
    }

    public String getApplicationName() {
        return this.applicationName;
    }

    public void setApplicationName(String applicationName) {
        this.applicationName = applicationName;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        SQLServerDatabaseConfig other = (SQLServerDatabaseConfig)obj;
        return Objects.equals(this.serverName, other.serverName) && Objects.equals(this.userName, other.userName) && Objects.equals(this.useAD, other.useAD) && Objects.equals(this.url, other.url);
    }
}

