/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.sqlserver;

import com.sigge.dbrunner.ADatabase;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IDatabaseOperator;
import com.sigge.dbrunner.sqlserver.SQLServerDatabaseConfig;
import com.sigge.dbrunner.sqlserver.SQLServerDatabaseOperator;
import com.sigge.dbrunner.sqlserver.SQLServerScriptRunner;
import com.siggemannen.functional.throwing.ThrowingFunction;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class SQLServerDatabase
extends ADatabase<SQLServerScriptRunner> {
    public static String PROVIDER_NAME = "MSSQL";
    private final Optional<SQLServerDatabaseConfig> config;
    private static final String master = "master";
    private final ThrowingFunction<String, Connection> connectionSupplier;
    private static final String GET_DATABASES_SQL = "SELECT RTRIM(name) AS name " + "FROM   master..sysdatabases (NOLOCK)" + " order by case when name in ('master','model','msdb','tempdb') or category & 16 > 0  then 0 else 1 END, lower(name)";
    private Driver chosenDriver = null;
    private Boolean setSSL = null;
    private int major;
    private int minor;

    public SQLServerDatabase(SQLServerDatabaseConfig config) {
        this.config = Optional.of(config);
        this.connectionSupplier = db -> DriverManager.getConnection(this.generateConnectionString(config, (String)db));
    }

    SQLServerDatabase(ThrowingFunction<String, Connection> connectionSupplier) {
        this.config = Optional.empty();
        this.connectionSupplier = connectionSupplier;
    }

    @Override
    public void closeAllSessions() {
        super.closeAllSessions();
        if (this.chosenDriver != Driver.SQL_SERVER) {
            System.gc();
        }
    }

    public String toString() {
        return this.config.map(cf -> "Server: " + cf.getUserName() + "@" + cf.getServerName()).orElse("Unknown configuration");
    }

    @Override
    public boolean checkConnection() {
        try {
            ((SQLServerScriptRunner)this.getScriptRunner(master)).executeQuery("SELECT @@SPID as session_id");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public List<String> getDatabases() throws SQLException {
        ArrayList<String> databases = new ArrayList<String>();
        Throwable throwable = null;
        Object var3_4 = null;
        try (ResultSet rs = ((SQLServerScriptRunner)this.getScriptRunner(master)).executeQuery(GET_DATABASES_SQL);){
            while (rs.next()) {
                databases.add(rs.getString(1));
            }
        }
        catch (Throwable throwable2) {
            if (throwable == null) {
                throwable = throwable2;
            } else if (throwable != throwable2) {
                throwable.addSuppressed(throwable2);
            }
            throw throwable;
        }
        return databases;
    }

    @Override
    protected SQLServerScriptRunner createScriptRunner(String databaseName) throws SQLException {
        Connection con = this.createConnection(databaseName, null);
        if (databaseName != null && databaseName.length() > 0 && this.config.map(c -> c.getUrl() != null && c.getUrl().length() > 0).orElse(false).booleanValue()) {
            con.setCatalog(databaseName);
        }
        SQLServerScriptRunner scriptRunner = new SQLServerScriptRunner(con, this);
        scriptRunner.setDelimiter("GO");
        scriptRunner.setFullLineDelimiter(true);
        scriptRunner.setAutoCommit(true);
        return scriptRunner;
    }

    @Override
    public String getServerLabel() {
        if (this.config.isPresent()) {
            return this.config.get().getLabel();
        }
        return null;
    }

    String generateConnectionString(SQLServerDatabaseConfig config, String databaseName) {
        if (config.getUrl() != null && config.getUrl().length() > 0) {
            return config.getUrl();
        }
        if (this.chosenDriver == null || this.chosenDriver == Driver.SQL_SERVER) {
            StringBuilder connString = new StringBuilder().append("jdbc:sqlserver://").append(config.getServerName());
            if (databaseName != null) {
                connString.append(";databaseName=").append(databaseName);
            }
            if (config.isUseAD()) {
                connString.append(";integratedSecurity=true");
            } else {
                connString.append(";user=").append(config.getUserName()).append(";password=").append(config.getPassword());
            }
            connString.append(";lastUpdateCount=false");
            connString.append(";encrypt=false;trustServerCertificate=true");
            connString.append(";selectMethod=direct");
            connString.append(";responseBuffering=adaptive");
            if (config.getApplicationName() != null && config.getApplicationName().length() > 0) {
                connString.append(";applicationName=" + config.getApplicationName());
            } else {
                connString.append(";applicationName=DBRunner");
            }
            return connString.toString();
        }
        StringBuilder sb = new StringBuilder().append("jdbc:jtds:sqlserver://").append(config.getServerName());
        if (databaseName != null) {
            sb.append("/").append(databaseName);
        }
        if (config.getApplicationName() != null && config.getApplicationName().length() > 0) {
            sb.append(";appname=" + config.getApplicationName());
        } else {
            sb.append(";appname=DBRunner");
        }
        if (this.setSSL != null && this.setSSL.booleanValue()) {
            sb.append(";ssl=request");
        }
        sb.append(";useLOBs=false");
        if (!config.isUseAD()) {
            sb.append(";user=").append(config.getUserName()).append(";password=").append(config.getPassword());
        }
        if (this.chosenDriver == Driver.JTDS_4_2) {
            sb.append(";tds=4.2");
        }
        return sb.toString();
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.getUniqueProviderName());
    }

    @Override
    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof SQLServerDatabase)) {
            if (other instanceof Database) {
                System.out.println("Trying to compare this" + this + " raw db with config: " + other);
            }
            return false;
        }
        SQLServerDatabase that = (SQLServerDatabase)other;
        if (that == this) {
            return true;
        }
        return Objects.equals(this.config, that.config);
    }

    @Override
    public String getServer() {
        return this.config.map(c -> c.getServerName()).orElse(null);
    }

    @Override
    public String getUser() {
        return this.config.map(c -> c.getUserName()).orElse(null);
    }

    @Override
    public String getUniqueProviderName() {
        return this.config.map(c -> String.valueOf(c.getUrl() != null && c.getUrl().length() > 0 ? c.getUrl() : String.valueOf(this.getDatabaseProvider()) + ":" + this.getServer() + "@" + this.getUser()) + "/" + (c.getLabel() != null ? c.getLabel() : "")).orElseThrow(() -> new RuntimeException("Config not in use"));
    }

    @Override
    public String getPassword() {
        return this.config.map(c -> c.getPassword()).orElse(null);
    }

    @Override
    public boolean isUseAD() {
        return this.config.map(c -> c.isUseAD()).orElse(false);
    }

    @Override
    public String getDatabaseProvider() {
        return PROVIDER_NAME;
    }

    @Override
    public Connection createConnection(String database, Object options) throws SQLException {
        block10: {
            if (this.chosenDriver == null) {
                try {
                    Connection cn = (Connection)this.connectionSupplier.apply((Object)database);
                    this.major = cn.getMetaData().getDatabaseMajorVersion();
                    this.minor = cn.getMetaData().getDatabaseMinorVersion();
                    this.chosenDriver = Driver.SQL_SERVER;
                    return cn;
                }
                catch (Exception sex) {
                    if (sex.getMessage() == null || !sex.getMessage().matches(".*SQL Server did not return a response.*") && !sex.getMessage().matches(".*SQL Server version .* is not supported by this driver.*") && !sex.getMessage().matches(".*The TDS protocol stream is not valid.*")) break block10;
                    this.chosenDriver = Driver.JTDS;
                    try {
                        Class.forName("net.sourceforge.jtds.jdbc.Driver");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        // empty catch block
                    }
                    try {
                        Connection cn = (Connection)this.connectionSupplier.apply((Object)database);
                        this.major = cn.getMetaData().getDatabaseMajorVersion();
                        this.minor = cn.getMetaData().getDatabaseMinorVersion();
                        this.setSSL = this.major != 9;
                        return cn;
                    }
                    catch (Exception ex) {
                        if (ex.getMessage() != null && ex.getMessage().matches(".*Stream .* attempting to read when no request has been sent.*")) {
                            this.chosenDriver = Driver.JTDS_4_2;
                            try {
                                Connection cn = (Connection)this.connectionSupplier.apply((Object)database);
                                this.major = cn.getMetaData().getDatabaseMajorVersion();
                                this.minor = cn.getMetaData().getDatabaseMinorVersion();
                                this.setSSL = this.major != 9;
                                return cn;
                            }
                            catch (Exception ex2) {
                                this.chosenDriver = null;
                                throw ex2;
                            }
                        }
                        this.chosenDriver = null;
                        throw ex;
                    }
                }
            }
        }
        return (Connection)this.connectionSupplier.apply((Object)database);
    }

    @Override
    public String getUrl() {
        return this.config.map(c -> c.getUrl()).orElse(null);
    }

    @Override
    public IDatabaseOperator getDatabaseOperator() {
        return new SQLServerDatabaseOperator(this);
    }

    public int getMajor() {
        return this.major;
    }

    public int getMinor() {
        return this.minor;
    }

    @Override
    public String getConnectionUrl() {
        if (!this.config.isPresent()) {
            return null;
        }
        return this.generateConnectionString(this.config.orElse(null), "");
    }

    private static enum Driver {
        SQL_SERVER,
        JTDS,
        JTDS_4_2;

    }
}

