/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner.sqlite;

import com.sigge.dbrunner.AScriptRunner;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.NewLineReader;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.dbrunner.sqlite.SQLiteDatabase;
import com.siggemannen.codeparser.antler.CaseChangingCharStreamUpper;
import com.siggemannen.codeparser.antler.SQLiteLexer;
import com.siggemannen.codeparser.antler.SQLiteParser;
import java.io.IOException;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.List;
import org.antlr.v4.runtime.ANTLRErrorListener;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CodePointCharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.Parser;
import org.antlr.v4.runtime.RecognitionException;
import org.antlr.v4.runtime.Recognizer;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.atn.ATNConfigSet;
import org.antlr.v4.runtime.atn.ParserATNSimulator;
import org.antlr.v4.runtime.atn.PredictionMode;
import org.antlr.v4.runtime.dfa.DFA;

public class SQLiteScriptRunner
extends AScriptRunner<SQLiteDatabase> {
    public SQLiteScriptRunner(Connection connection, SQLiteDatabase database) {
        super(connection, database);
        this.setSendFullScript(false);
        this.setAutoCommit(true);
    }

    @Override
    protected void executeByBatches(Reader reader, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, UnsupportedEncodingException, IOException {
        String script = NewLineReader.readAll(reader);
        CodePointCharStream s = CharStreams.fromString((String)script);
        CaseChangingCharStreamUpper upper = new CaseChangingCharStreamUpper((CharStream)s);
        SQLiteLexer lt = new SQLiteLexer((CharStream)upper);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lt);
        SQLiteParser parser = new SQLiteParser((TokenStream)tokens);
        lt.removeErrorListeners();
        parser.removeErrorListeners();
        parser.setTrace(false);
        parser.setProfile(false);
        ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
        parser.setBuildParseTree(true);
        ANTLRErrorListener listener = new ANTLRErrorListener(){

            public void syntaxError(Recognizer<?, ?> recognizer, Object offendingSymbol, int line, int charPositionInLine, String msg, RecognitionException e) {
            }

            public void reportContextSensitivity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, int prediction, ATNConfigSet configs) {
            }

            public void reportAttemptingFullContext(Parser recognizer, DFA dfa, int startIndex, int stopIndex, BitSet conflictingAlts, ATNConfigSet configs) {
            }

            public void reportAmbiguity(Parser recognizer, DFA dfa, int startIndex, int stopIndex, boolean exact, BitSet ambigAlts, ATNConfigSet configs) {
            }
        };
        lt.addErrorListener(listener);
        parser.addErrorListener(listener);
        SQLiteParser.ParseContext pt = parser.parse();
        List list = pt.sql_stmt_list();
        ArrayList<String> execs = new ArrayList<String>();
        try {
            for (SQLiteParser.Sql_stmt_listContext sl : list) {
                for (SQLiteParser.Sql_stmtContext stmt : sl.sql_stmt()) {
                    execs.add(script.substring(stmt.getStart().getStartIndex(), stmt.getStop().getStopIndex() + 1));
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.executeStatement(script, reporter, options);
            return;
        }
        for (String exec : execs) {
            this.executeStatement(exec, reporter, options);
        }
    }

    @Override
    public int openTransactions() {
        return 0;
    }

    @Override
    protected boolean runCommand(String command, SQLOptions options, Statement statement) throws SQLException {
        this.currentDatabase = null;
        if (options.isParseOnly()) {
            Throwable throwable = null;
            Object var5_5 = null;
            try {
                PreparedStatement ps = this.connection.prepareStatement(command);
                if (ps != null) {
                    ps.close();
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            return false;
        }
        return statement.execute(command);
    }
}

