/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.dbrunner;

import com.sigge.dbrunner.AScriptRunner;
import com.sigge.dbrunner.Database;
import com.sigge.dbrunner.IProgressReporter;
import com.sigge.dbrunner.IScriptRunner;
import com.sigge.dbrunner.SQLOptions;
import java.io.Reader;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public abstract class ADatabase<E extends AScriptRunner>
implements Database {
    public static final String DEFAULT_NO_DATABASE = "(default)";
    protected final Map<String, E> scriptRunners = new HashMap<String, E>();

    @Override
    public List<String> getDatabases() throws SQLException {
        ArrayList<String> dbs = new ArrayList<String>();
        E r = this.getScriptRunner("");
        try {
            Throwable throwable = null;
            Object var4_6 = null;
            try (ResultSet rs = ((AScriptRunner)r).getConnection().getMetaData().getCatalogs();){
                while (rs.next()) {
                    String string = rs.getString("TABLE_CAT");
                    dbs.add(string != null ? string : DEFAULT_NO_DATABASE);
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (dbs.size() == 0) {
            dbs.add(DEFAULT_NO_DATABASE);
        }
        return dbs;
    }

    @Override
    public boolean checkConnection() {
        try {
            ((AScriptRunner)this.getScriptRunner("")).executeQuery("SELECT 1");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    @Override
    public void executeScript(Reader scriptText, String databaseName, SQLOptions options) throws SQLException, Exception {
        this.executeScript(scriptText, databaseName, Arrays.asList(new IProgressReporter[0]), options);
    }

    @Override
    public void executeScript(Reader scriptText, String databaseName, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, Exception {
        ((AScriptRunner)this.getScriptRunner(databaseName)).runScript(scriptText, reporter, options);
        scriptText.close();
    }

    @Override
    public void executeScript(Reader scriptText, IScriptRunner scriptRunner, String databaseName, List<IProgressReporter> reporter, SQLOptions options) throws SQLException, Exception {
        scriptRunner.changeDatabase(databaseName);
        scriptRunner.runScript(scriptText, reporter, options);
        scriptText.close();
    }

    protected E getScriptRunner(String databaseName) throws SQLException {
        AScriptRunner scriptRunner = (AScriptRunner)this.scriptRunners.get(databaseName);
        if (scriptRunner == null || !scriptRunner.isAlive()) {
            scriptRunner = this.createScriptRunner(databaseName);
            this.scriptRunners.put(databaseName, scriptRunner);
        }
        return (E)scriptRunner;
    }

    protected abstract E createScriptRunner(String var1) throws SQLException;

    @Override
    public IScriptRunner createRunner(String databaseName, Object options) throws SQLException {
        return this.createScriptRunner(databaseName);
    }

    @Override
    public void closeAllSessions() {
        this.scriptRunners.values().forEach(IScriptRunner::closeConnection);
        this.scriptRunners.clear();
    }

    public int hashCode() {
        return Objects.hash(this.getUniqueProviderName());
    }

    public boolean equals(Object other) {
        if (other == null) {
            return false;
        }
        if (!(other instanceof Database)) {
            return false;
        }
        Database that = (Database)other;
        if (that == this) {
            return true;
        }
        return Objects.equals(this.getUniqueProviderName(), that.getUniqueProviderName());
    }

    @Override
    public String getServerLabel() {
        return null;
    }
}

