/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.db2.cmx.runtime.internal.xml;

import com.ibm.db2.cmx.runtime.internal.db.XmlFileHelper;
import com.ibm.db2.cmx.runtime.internal.metadata.StatementAttributes;
import com.ibm.db2.cmx.runtime.internal.xml.PDQXmlStatementDescriptor;
import com.ibm.db2.cmx.runtime.internal.xml.XmlBuf;
import com.ibm.db2.cmx.runtime.internal.xml.XmlExporter;
import com.ibm.db2.cmx.runtime.internal.xml.XmlTags;
import com.ibm.db2.cmx.runtime.statement.SqlStatementType;
import java.util.TreeSet;

public class PDQXmlStatementAttributes
implements XmlExporter {
    private int concurrency_ = 1007;
    private int holdability_;
    private int type_ = 1003;
    private int parameterType_ = 1;
    private int rowType_ = 5;
    private String cursorName_;
    private TreeSet<Integer> incrementalSpecialRegValuesUsed_;
    private String positionedCursorName_;
    private boolean isBindable_ = true;
    private Boolean allowStaticRowsetCursors_ = null;
    private String prepareOptions_ = null;
    PDQXmlStatementDescriptor statementDesc_;
    public static final int SINGLE_ROW_PARAMETERS = 1;
    public static final int MULTI_ROW_PARAMETERS = 2;
    public static final int NO_PARAMETERS = 3;
    public static final int SINGLE_ROW_RESULT = 4;
    public static final int MULTI_ROW_RESULT = 5;

    @Deprecated
    public PDQXmlStatementAttributes() {
        this.holdability_ = 2;
    }

    private PDQXmlStatementAttributes(int n2) {
        this.holdability_ = n2;
    }

    public static PDQXmlStatementAttributes getPDQXmlStatementAttributesForClientOptimizer() {
        return new PDQXmlStatementAttributes(1);
    }

    public static PDQXmlStatementAttributes getPDQXmlStatementAttributesForPdqAPI() {
        return new PDQXmlStatementAttributes(2);
    }

    public Integer getConcurrency() {
        return this.concurrency_;
    }

    public void setConcurrency(Integer n2) {
        this.concurrency_ = n2;
    }

    public Integer getHoldability() {
        return this.holdability_;
    }

    public void setHoldability(Integer n2) {
        this.holdability_ = n2;
    }

    public Integer getType() {
        return this.type_;
    }

    public void setType(Integer n2) {
        this.type_ = n2;
    }

    @Override
    public String getXml(int n2) {
        XmlBuf xmlBuf = new XmlBuf(n2);
        xmlBuf.startElement("statementAttributes");
        xmlBuf.addAttrib("cursorName", this.cursorName_);
        if (null != this.incrementalSpecialRegValuesUsed_ && 0 < this.incrementalSpecialRegValuesUsed_.size()) {
            xmlBuf.addAttrib("incrementalSpecialRegValuesUsed", XmlFileHelper.getIntegerSetAsString(this.incrementalSpecialRegValuesUsed_));
        }
        xmlBuf.addAttrib("resultSetConcurrency", XmlTags.getConcurrencyName(this.concurrency_));
        xmlBuf.addAttrib("resultSetHoldability", XmlTags.getHoldabilityName(this.holdability_));
        xmlBuf.addAttrib("resultSetType", XmlTags.getCursorTypeName(this.type_));
        SqlStatementType sqlStatementType = this.statementDesc_.getStatementTypeEnum();
        if (SqlStatementType.isSELECTorXQUERY(sqlStatementType) || SqlStatementType.SINGLE_ROW_QUERY == sqlStatementType) {
            xmlBuf.addAttrib("rowType", XmlTags.getStatementAttributesRowTypeName(this.rowType_));
        }
        xmlBuf.addAttrib("positionedUpdateCursor", this.positionedCursorName_);
        xmlBuf.addAttrib("parameterType", XmlTags.getStatementAttributesParameterTypeName(this.parameterType_));
        xmlBuf.addAttrib("isBindable", String.valueOf(this.isBindable_));
        if (null != this.allowStaticRowsetCursors_) {
            xmlBuf.addAttrib("allowStaticRowsetCursors", this.allowStaticRowsetCursors_.toString());
        }
        xmlBuf.addAttrib("prepareOptions", this.prepareOptions_);
        xmlBuf.endElement();
        return xmlBuf.toString();
    }

    static int[] createStatementAttributesArray(PDQXmlStatementAttributes pDQXmlStatementAttributes) {
        int[] nArray = StatementAttributes.getStatementAttributesDefaultArray();
        if (pDQXmlStatementAttributes != null) {
            nArray[2] = pDQXmlStatementAttributes.concurrency_;
            nArray[3] = pDQXmlStatementAttributes.holdability_;
            nArray[4] = pDQXmlStatementAttributes.type_;
            nArray[0] = pDQXmlStatementAttributes.parameterType_;
            nArray[1] = pDQXmlStatementAttributes.rowType_;
            nArray[5] = StatementAttributes.getIntValueOfBooleanAllowStaticRowsetCursor(pDQXmlStatementAttributes.isAllowStaticRowsetCursors());
        }
        return nArray;
    }

    public Integer getParameterType() {
        return this.parameterType_;
    }

    public void setParameterType(Integer n2) {
        this.parameterType_ = n2;
    }

    public Integer getRowType() {
        return this.rowType_;
    }

    public void setRowType(Integer n2) {
        this.rowType_ = n2;
    }

    public String getCursorName() {
        return this.cursorName_;
    }

    public void setCursorName(String string) {
        this.cursorName_ = string;
    }

    TreeSet<Integer> getIncrementalSpecialRegValuesUsed() {
        return this.incrementalSpecialRegValuesUsed_;
    }

    void setIncrementalSpecialRegValuesUsed(TreeSet<Integer> treeSet) {
        this.incrementalSpecialRegValuesUsed_ = treeSet;
    }

    public boolean isBindable() {
        return this.isBindable_;
    }

    public void setBindable(boolean bl2) {
        this.isBindable_ = bl2;
    }

    public String getPositionedCursorName() {
        return this.positionedCursorName_;
    }

    public void setPositionedCursorName(String string) {
        this.positionedCursorName_ = string;
    }

    public boolean isAllowStaticRowsetCursors() {
        if (null == this.allowStaticRowsetCursors_) {
            return false;
        }
        return this.allowStaticRowsetCursors_;
    }

    public void setAllowStaticRowsetCursors(boolean bl2) {
        this.allowStaticRowsetCursors_ = bl2;
    }

    public String getPrepareOptions() {
        return this.prepareOptions_;
    }

    public void setPrepareOptions(String string) {
        this.prepareOptions_ = string;
    }
}

