/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view.multiple;

import com.siggemannen.view.UIOptionRunnable;
import com.siggemannen.view.UIOptionSupplier;
import com.siggemannen.view.multiple.BackgroundJob;
import com.siggemannen.view.multiple.JobRunnerModel;
import com.siggemannen.view.multiple.MultiplePanelView;
import java.awt.Component;
import java.awt.Frame;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JProgressBar;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableModel;

public class MultipleUIBackgroundRunner {
    private final MultiplePanelView view = new MultiplePanelView();
    private final ExecutorService service = Executors.newWorkStealingPool();
    private final JobRunnerModel model = new JobRunnerModel();
    private JDialog panel;

    public MultipleUIBackgroundRunner(Frame container) {
        this.model.setColumns(Arrays.asList("Name", "Progress"));
        this.model.setRows(new ArrayList());
        this.view.jobTable.setModel((TableModel)this.model);
        this.panel = new JDialog(container, "Running jobs");
        this.panel.getContentPane().add(this.view);
        this.panel.pack();
        this.view.jobTable.getColumn(1).setCellRenderer(new TableCellRenderer(){
            private final JProgressBar bar = new JProgressBar();
            private final JProgressBar indet = new JProgressBar(){

                @Override
                public boolean isDisplayable() {
                    return true;
                }

                @Override
                public void repaint() {
                    ((MultipleUIBackgroundRunner)(this).MultipleUIBackgroundRunner.this).view.jobTable.repaint();
                }
            };

            @Override
            public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
                BackgroundJob job = (BackgroundJob)MultipleUIBackgroundRunner.this.model.getValueAt(((MultipleUIBackgroundRunner)MultipleUIBackgroundRunner.this).view.jobTable.convertRowIndexToModel(row));
                if (job == null) {
                    return null;
                }
                if (job.isDeterministicProgress() || job.isDone()) {
                    this.bar.setIndeterminate(false);
                    this.bar.setMinimum(0);
                    this.bar.setMaximum(100);
                    this.bar.setStringPainted(true);
                    this.bar.setValue(job.getProgressStatus());
                    this.bar.setString(job.getProgressMessage());
                    return this.bar;
                }
                this.indet.setIndeterminate(!job.isDone());
                this.indet.setStringPainted(true);
                this.indet.setString(job.getProgressMessage());
                return this.indet;
            }
        });
        this.panel.setLocationRelativeTo(new JFrame(this.view == null ? null : this.view.getGraphicsConfiguration()));
    }

    public void setVisible(boolean visible) {
        this.panel.setVisible(visible);
    }

    public void dispose() {
        this.panel.setVisible(false);
        this.panel.dispose();
    }

    public <T> void attachJob(UIOptionSupplier<T> supplier) {
        BackgroundJob job = new BackgroundJob(supplier.getTitle(), supplier.getCompletionProgress() != null);
        this.model.addRow(job);
        if (supplier.getCompletionProgress() != null) {
            supplier.getCompletionProgress().accept((percentage, message, ex) -> {
                job.setProgressStatus(percentage);
                job.setProgressMessage(message);
                this.replaceJobRow(job);
            });
        } else if (supplier.getProgress() != null) {
            supplier.getProgress().accept((message, ex) -> {
                job.setProgressMessage(message);
                this.replaceJobRow(job);
            });
        } else {
            job.setProgressMessage(supplier.getBusyMessage() != null ? supplier.getBusyMessage() : "Processing...");
        }
        this.service.submit(() -> {
            try {
                try {
                    supplier.getCallback().accept(supplier.getSupplier().get());
                }
                catch (Exception ex) {
                    if (supplier.getExceptionCallback() != null) {
                        supplier.getExceptionCallback().accept((Object)ex);
                    }
                    job.setDone(true);
                    job.setProgressStatus(100);
                    this.replaceJobRow(job);
                }
            }
            finally {
                job.setDone(true);
                job.setProgressStatus(100);
                this.replaceJobRow(job);
            }
        });
    }

    public void attachJob(UIOptionRunnable supplier) {
        BackgroundJob job = new BackgroundJob(supplier.getTitle(), supplier.getCompletionProgress() != null);
        this.model.addRow(job);
        if (supplier.getCompletionProgress() != null) {
            supplier.getCompletionProgress().accept((percentage, message, ex) -> {
                job.setProgressStatus(percentage);
                job.setProgressMessage(message);
                this.replaceJobRow(job);
            });
        } else if (supplier.getProgress() != null) {
            supplier.getProgress().accept((message, ex) -> {
                job.setProgressMessage(message);
                this.replaceJobRow(job);
            });
        } else {
            job.setProgressMessage(supplier.getBusyMessage() != null ? supplier.getBusyMessage() : "Processing...");
        }
        this.service.submit(() -> {
            try {
                try {
                    supplier.getRunnable().run();
                    supplier.getCallback().run();
                }
                catch (Exception ex) {
                    if (supplier.getExceptionCallback() != null) {
                        supplier.getExceptionCallback().accept((Object)ex);
                    }
                    job.setDone(true);
                    job.setProgressStatus(100);
                    this.replaceJobRow(job);
                }
            }
            finally {
                job.setDone(true);
                job.setProgressStatus(100);
                this.replaceJobRow(job);
            }
        });
    }

    private void replaceJobRow(BackgroundJob job) {
        SwingUtilities.invokeLater(() -> {
            int i = 0;
            while (i < this.model.getRowCount()) {
                try {
                    BackgroundJob backJob = (BackgroundJob)this.model.getValueAt(i);
                    if (backJob == job) {
                        this.model.replaceRow(i, backJob);
                    }
                }
                catch (Exception exx) {}
                break;
                ++i;
            }
        });
    }
}

