/*
 * Decompiled with CFR 0.152.
 */
package com.siggemannen.view;

import com.siggemannen.view.GhostGlassPane;
import com.siggemannen.view.TabMoveListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.datatransfer.DataFlavor;
import java.awt.datatransfer.Transferable;
import java.awt.dnd.DragGestureListener;
import java.awt.dnd.DragSource;
import java.awt.dnd.DragSourceDragEvent;
import java.awt.dnd.DragSourceDropEvent;
import java.awt.dnd.DragSourceEvent;
import java.awt.dnd.DragSourceListener;
import java.awt.dnd.DropTarget;
import java.awt.dnd.DropTargetDragEvent;
import java.awt.dnd.DropTargetDropEvent;
import java.awt.dnd.DropTargetEvent;
import java.awt.dnd.DropTargetListener;
import java.awt.dnd.InvalidDnDOperationException;
import java.awt.event.ActionEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;

public class DnDTabbedPane
extends JTabbedPane {
    public static final long serialVersionUID = 1L;
    private static final int LINEWIDTH = 3;
    private static final String NAME = "TabTransferData";
    private final DataFlavor FLAVOR = new DataFlavor("application/x-java-jvm-local-objectref", "TabTransferData");
    private static GhostGlassPane s_glassPane = new GhostGlassPane();
    private boolean m_isDrawRect = false;
    private final Rectangle2D m_lineRect = new Rectangle2D.Double();
    private final Color m_lineColor = new Color(0, 100, 255);
    private TabAcceptor m_acceptor = null;
    private static int rwh = 20;
    private static int buttonsize = 30;
    private static Rectangle rBackward = new Rectangle();
    private static Rectangle rForward = new Rectangle();
    private final List<TabMoveListener> listeners = new ArrayList<TabMoveListener>();
    private boolean m_hasGhost = true;

    private void clickArrowButton(String actionKey) {
        Action action;
        ActionMap map = this.getActionMap();
        if (map != null && (action = map.get(actionKey)) != null && action.isEnabled()) {
            action.actionPerformed(new ActionEvent(this, 1001, null, 0L, 0));
        }
    }

    public void addTabMoveListener(TabMoveListener listener) {
        if (listener != null && !this.listeners.contains(listener)) {
            this.listeners.add(listener);
        }
    }

    public void removeTabMoveListener(TabMoveListener listener) {
        this.listeners.remove(listener);
    }

    private void autoScrollTest(Point glassPt) {
        Rectangle r = this.getTabAreaBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1 || tabPlacement == 3) {
            rBackward.setBounds(r.x, r.y - 40, rwh, r.height + 40);
            rForward.setBounds(r.x + r.width - rwh - buttonsize - 40, r.y - 40, rwh + buttonsize + 50, r.height + 40);
        } else if (tabPlacement == 2 || tabPlacement == 4) {
            rBackward.setBounds(r.x, r.y, r.width, rwh);
            rForward.setBounds(r.x, r.y + r.height - rwh - buttonsize, r.width, rwh + buttonsize);
        }
        if (rBackward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsBackwardAction");
        } else if (rForward.contains(glassPt)) {
            this.clickArrowButton("scrollTabsForwardAction");
        }
    }

    private Rectangle getTabAreaBounds() {
        Rectangle tabbedRect = this.getBounds();
        Component comp = this.getSelectedComponent();
        int idx = 0;
        while (comp == null && idx < this.getTabCount()) {
            comp = this.getComponentAt(idx++);
        }
        Rectangle compRect = comp == null ? new Rectangle() : comp.getBounds();
        int tabPlacement = this.getTabPlacement();
        if (tabPlacement == 1) {
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 3) {
            tabbedRect.y = tabbedRect.y + compRect.y + compRect.height;
            tabbedRect.height -= compRect.height;
        } else if (tabPlacement == 2) {
            tabbedRect.width -= compRect.width;
        } else if (tabPlacement == 4) {
            tabbedRect.x = tabbedRect.x + compRect.x + compRect.width;
            tabbedRect.width -= compRect.width;
        }
        tabbedRect.grow(2, 2);
        return tabbedRect;
    }

    public DnDTabbedPane() {
        DragSourceListener dsl = new DragSourceListener(){

            @Override
            public void dragEnter(DragSourceDragEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragExit(DragSourceEvent e) {
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                DnDTabbedPane.this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                DnDTabbedPane.this.m_isDrawRect = false;
                s_glassPane.setPoint(new Point(-1000, -1000));
                s_glassPane.repaint();
            }

            @Override
            public void dragOver(DragSourceDragEvent e) {
                TabTransferData data = DnDTabbedPane.this.getTabTransferData(e);
                if (data == null) {
                    e.getDragSourceContext().setCursor(DragSource.DefaultMoveNoDrop);
                    return;
                }
                e.getDragSourceContext().setCursor(DragSource.DefaultMoveDrop);
            }

            @Override
            public void dragDropEnd(DragSourceDropEvent e) {
                DnDTabbedPane.this.m_isDrawRect = false;
                DnDTabbedPane.this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                if (DnDTabbedPane.this.hasGhost()) {
                    s_glassPane.setVisible(false);
                    s_glassPane.setImage(null);
                }
            }

            @Override
            public void dropActionChanged(DragSourceDragEvent e) {
            }
        };
        DragGestureListener dgl = e -> {
            Point tabPt = e.getDragOrigin();
            int dragTabIndex = this.indexAtLocation(tabPt.x, tabPt.y);
            if (dragTabIndex < 0) {
                return;
            }
            this.initGlassPane(e.getComponent(), e.getDragOrigin(), dragTabIndex);
            try {
                e.startDrag(DragSource.DefaultMoveDrop, new TabTransferable(this, dragTabIndex), dsl);
            }
            catch (InvalidDnDOperationException idoe) {
                idoe.printStackTrace();
            }
        };
        new DropTarget(this, 3, new CDropTargetListener(), true);
        new DragSource().createDefaultDragGestureRecognizer(this, 3, dgl);
        this.m_acceptor = (a_component, a_index) -> true;
    }

    public TabAcceptor getAcceptor() {
        return this.m_acceptor;
    }

    public void setAcceptor(TabAcceptor a_value) {
        this.m_acceptor = a_value;
    }

    private TabTransferData getTabTransferData(DropTargetDropEvent a_event) {
        try {
            TabTransferData data = (TabTransferData)a_event.getTransferable().getTransferData(this.FLAVOR);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TabTransferData getTabTransferData(DropTargetDragEvent a_event) {
        try {
            TabTransferData data = (TabTransferData)a_event.getTransferable().getTransferData(this.FLAVOR);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private TabTransferData getTabTransferData(DragSourceDragEvent a_event) {
        try {
            TabTransferData data = (TabTransferData)a_event.getDragSourceContext().getTransferable().getTransferData(this.FLAVOR);
            return data;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    private Point buildGhostLocation(Point a_location) {
        Point retval = new Point(a_location);
        switch (this.getTabPlacement()) {
            case 1: {
                retval.y = 1;
                retval.x -= s_glassPane.getGhostWidth() / 2;
                break;
            }
            case 3: {
                retval.y = this.getHeight() - 1 - s_glassPane.getGhostHeight();
                retval.x -= s_glassPane.getGhostWidth() / 2;
                break;
            }
            case 2: {
                retval.x = 1;
                retval.y -= s_glassPane.getGhostHeight() / 2;
                break;
            }
            case 4: {
                retval.x = this.getWidth() - 1 - s_glassPane.getGhostWidth();
                retval.y -= s_glassPane.getGhostHeight() / 2;
            }
        }
        retval = SwingUtilities.convertPoint(this, retval, s_glassPane);
        return retval;
    }

    public void setPaintGhost(boolean flag) {
        this.m_hasGhost = flag;
    }

    public boolean hasGhost() {
        return this.m_hasGhost;
    }

    private int getTargetTabIndex(Point a_point) {
        boolean isTopOrBottom;
        boolean bl = isTopOrBottom = this.getTabPlacement() == 1 || this.getTabPlacement() == 3;
        if (this.getTabCount() == 0) {
            return 0;
        }
        int i = 0;
        while (i < this.getTabCount()) {
            Rectangle r = this.getBoundsAt(i);
            if (isTopOrBottom) {
                r.setRect(r.x - r.width / 2, r.y, r.width, r.height);
            } else {
                r.setRect(r.x, r.y - r.height / 2, r.width, r.height);
            }
            if (r.contains(a_point)) {
                return i;
            }
            ++i;
        }
        Rectangle r = this.getBoundsAt(this.getTabCount() - 1);
        if (isTopOrBottom) {
            int x = r.x + r.width / 2;
            r.setRect(x, r.y, this.getWidth() - x, r.height);
        } else {
            int y = r.y + r.height / 2;
            r.setRect(r.x, y, r.width, this.getHeight() - y);
        }
        return r.contains(a_point) ? this.getTabCount() : -1;
    }

    private void convertTab(TabTransferData a_data, int a_targetIndex) {
        DnDTabbedPane source = a_data.getTabbedPane();
        int sourceIndex = a_data.getTabIndex();
        if (sourceIndex < 0) {
            return;
        }
        Component cmp = source.getComponentAt(sourceIndex);
        Component tabComp = source.getTabComponentAt(sourceIndex);
        String str = source.getTitleAt(sourceIndex);
        if (this != source) {
            source.remove(sourceIndex);
            if (a_targetIndex == this.getTabCount()) {
                this.addTab(str, cmp);
                this.setTabComponentAt(this.getTabCount() - 1, tabComp);
            } else {
                if (a_targetIndex < 0) {
                    a_targetIndex = 0;
                }
                this.insertTab(str, null, cmp, null, a_targetIndex);
                this.setTabComponentAt(a_targetIndex, tabComp);
            }
            this.setSelectedComponent(cmp);
            return;
        }
        if (a_targetIndex < 0 || sourceIndex == a_targetIndex) {
            return;
        }
        if (a_targetIndex == this.getTabCount()) {
            source.remove(sourceIndex);
            this.addTab(str, cmp);
            this.setTabComponentAt(this.getTabCount() - 1, tabComp);
            this.setSelectedIndex(this.getTabCount() - 1);
        } else if (sourceIndex > a_targetIndex) {
            source.remove(sourceIndex);
            this.insertTab(str, null, cmp, null, a_targetIndex);
            this.setTabComponentAt(a_targetIndex, tabComp);
            this.setSelectedIndex(a_targetIndex);
        } else {
            source.remove(sourceIndex);
            this.insertTab(str, null, cmp, null, a_targetIndex - 1);
            this.setTabComponentAt(a_targetIndex - 1, tabComp);
            this.setSelectedIndex(a_targetIndex - 1);
        }
        ActionEvent aie = null;
        int idx = this.listeners.size() - 1;
        while (idx >= 0) {
            TabMoveListener listener = this.listeners.get(idx);
            if (aie == null) {
                aie = new ActionEvent(this, 1001, "move");
            }
            listener.tabMoved(aie, sourceIndex, a_targetIndex);
            --idx;
        }
    }

    private void initTargetLeftRightLine(int next, TabTransferData a_data) {
        if (next < 0) {
            this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.m_isDrawRect = false;
            return;
        }
        if (a_data.getTabbedPane() == this && (a_data.getTabIndex() == next || next - a_data.getTabIndex() == 1)) {
            this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.m_isDrawRect = false;
        } else {
            if (this.getTabCount() == 0) {
                this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                this.m_isDrawRect = false;
                return;
            }
            if (next == 0) {
                Rectangle rect = this.getBoundsAt(0);
                this.m_lineRect.setRect(-1.0, rect.y, 3.0, rect.height);
                this.m_isDrawRect = true;
            } else if (next == this.getTabCount()) {
                Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
                this.m_lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
                this.m_isDrawRect = true;
            } else {
                Rectangle rect = this.getBoundsAt(next - 1);
                this.m_lineRect.setRect(rect.x + rect.width - 1, rect.y, 3.0, rect.height);
                this.m_isDrawRect = true;
            }
        }
    }

    private void initTargetTopBottomLine(int next, TabTransferData a_data) {
        if (next < 0) {
            this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.m_isDrawRect = false;
            return;
        }
        if (a_data.getTabbedPane() == this && (a_data.getTabIndex() == next || next - a_data.getTabIndex() == 1)) {
            this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
            this.m_isDrawRect = false;
        } else {
            if (this.getTabCount() == 0) {
                this.m_lineRect.setRect(0.0, 0.0, 0.0, 0.0);
                this.m_isDrawRect = false;
                return;
            }
            if (next == this.getTabCount()) {
                Rectangle rect = this.getBoundsAt(this.getTabCount() - 1);
                this.m_lineRect.setRect(rect.x, rect.y + rect.height - 1, rect.width, 3.0);
                this.m_isDrawRect = true;
            } else if (next == 0) {
                Rectangle rect = this.getBoundsAt(0);
                this.m_lineRect.setRect(rect.x, -1.0, rect.width, 3.0);
                this.m_isDrawRect = true;
            } else {
                Rectangle rect = this.getBoundsAt(next - 1);
                this.m_lineRect.setRect(rect.x, rect.y + rect.height - 1, rect.width, 3.0);
                this.m_isDrawRect = true;
            }
        }
    }

    private void initGlassPane(Component c, Point tabPt, int a_tabIndex) {
        this.getRootPane().setGlassPane(s_glassPane);
        if (this.hasGhost()) {
            Rectangle rect = this.getBoundsAt(a_tabIndex);
            BufferedImage image = new BufferedImage(c.getWidth(), c.getHeight(), 2);
            Graphics g = image.getGraphics();
            c.paint(g);
            image = image.getSubimage(rect.x, rect.y, rect.width, rect.height);
            s_glassPane.setImage(image);
        }
        s_glassPane.setPoint(this.buildGhostLocation(tabPt));
        s_glassPane.setVisible(true);
    }

    private Rectangle getTabAreaBound() {
        Rectangle lastTab = this.getUI().getTabBounds(this, this.getTabCount() - 1);
        return new Rectangle(0, 0, this.getWidth(), lastTab.y + lastTab.height);
    }

    @Override
    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        if (this.m_isDrawRect) {
            Graphics2D g2 = (Graphics2D)g;
            g2.setPaint(this.m_lineColor);
            g2.fill(this.m_lineRect);
        }
    }

    class CDropTargetListener
    implements DropTargetListener {
        CDropTargetListener() {
        }

        @Override
        public void dragEnter(DropTargetDragEvent e) {
            if (this.isDragAcceptable(e)) {
                e.acceptDrag(e.getDropAction());
            } else {
                e.rejectDrag();
            }
        }

        @Override
        public void dragExit(DropTargetEvent e) {
            DnDTabbedPane.this.m_isDrawRect = false;
        }

        @Override
        public void dropActionChanged(DropTargetDragEvent e) {
        }

        @Override
        public void dragOver(DropTargetDragEvent e) {
            TabTransferData data = DnDTabbedPane.this.getTabTransferData(e);
            if (DnDTabbedPane.this.getTabPlacement() == 1 || DnDTabbedPane.this.getTabPlacement() == 3) {
                DnDTabbedPane.this.initTargetLeftRightLine(DnDTabbedPane.this.getTargetTabIndex(e.getLocation()), data);
            } else {
                DnDTabbedPane.this.initTargetTopBottomLine(DnDTabbedPane.this.getTargetTabIndex(e.getLocation()), data);
            }
            DnDTabbedPane.this.repaint();
            if (DnDTabbedPane.this.hasGhost()) {
                Point buildGhostLocation = DnDTabbedPane.this.buildGhostLocation(e.getLocation());
                s_glassPane.setPoint(buildGhostLocation);
                s_glassPane.repaint();
                DnDTabbedPane.this.autoScrollTest(e.getLocation());
            }
        }

        @Override
        public void drop(DropTargetDropEvent a_event) {
            if (this.isDropAcceptable(a_event)) {
                DnDTabbedPane.this.convertTab(DnDTabbedPane.this.getTabTransferData(a_event), DnDTabbedPane.this.getTargetTabIndex(a_event.getLocation()));
                a_event.dropComplete(true);
            } else {
                a_event.dropComplete(false);
            }
            DnDTabbedPane.this.m_isDrawRect = false;
            DnDTabbedPane.this.repaint();
        }

        public boolean isDragAcceptable(DropTargetDragEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] flavor = e.getCurrentDataFlavors();
            if (!t.isDataFlavorSupported(flavor[0])) {
                return false;
            }
            TabTransferData data = DnDTabbedPane.this.getTabTransferData(e);
            if (DnDTabbedPane.this == data.getTabbedPane() && data.getTabIndex() >= 0) {
                return true;
            }
            if (DnDTabbedPane.this != data.getTabbedPane() && DnDTabbedPane.this.m_acceptor != null) {
                return DnDTabbedPane.this.m_acceptor.isDropAcceptable(data.getTabbedPane(), data.getTabIndex());
            }
            return false;
        }

        public boolean isDropAcceptable(DropTargetDropEvent e) {
            Transferable t = e.getTransferable();
            if (t == null) {
                return false;
            }
            DataFlavor[] flavor = e.getCurrentDataFlavors();
            if (!t.isDataFlavorSupported(flavor[0])) {
                return false;
            }
            TabTransferData data = DnDTabbedPane.this.getTabTransferData(e);
            if (DnDTabbedPane.this == data.getTabbedPane() && data.getTabIndex() >= 0) {
                return true;
            }
            if (DnDTabbedPane.this != data.getTabbedPane() && DnDTabbedPane.this.m_acceptor != null) {
                return DnDTabbedPane.this.m_acceptor.isDropAcceptable(data.getTabbedPane(), data.getTabIndex());
            }
            return false;
        }
    }

    public static interface TabAcceptor {
        public boolean isDropAcceptable(DnDTabbedPane var1, int var2);
    }

    class TabTransferData {
        private DnDTabbedPane m_tabbedPane = null;
        private int m_tabIndex = -1;

        public TabTransferData() {
        }

        public TabTransferData(DnDTabbedPane a_tabbedPane, int a_tabIndex) {
            this.m_tabbedPane = a_tabbedPane;
            this.m_tabIndex = a_tabIndex;
        }

        public DnDTabbedPane getTabbedPane() {
            return this.m_tabbedPane;
        }

        public void setTabbedPane(DnDTabbedPane pane) {
            this.m_tabbedPane = pane;
        }

        public int getTabIndex() {
            return this.m_tabIndex;
        }

        public void setTabIndex(int index) {
            this.m_tabIndex = index;
        }
    }

    class TabTransferable
    implements Transferable {
        private TabTransferData m_data = null;

        public TabTransferable(DnDTabbedPane a_tabbedPane, int a_tabIndex) {
            this.m_data = new TabTransferData(DnDTabbedPane.this, a_tabIndex);
        }

        @Override
        public Object getTransferData(DataFlavor flavor) {
            return this.m_data;
        }

        @Override
        public DataFlavor[] getTransferDataFlavors() {
            DataFlavor[] f = new DataFlavor[]{DnDTabbedPane.this.FLAVOR};
            return f;
        }

        @Override
        public boolean isDataFlavorSupported(DataFlavor flavor) {
            return flavor.getHumanPresentableName().equals(DnDTabbedPane.NAME);
        }
    }
}

