/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.xml.xpath2.processor.internal.function;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import org.eclipse.wst.xml.xpath2.api.EvaluationContext;
import org.eclipse.wst.xml.xpath2.api.ResultBuffer;
import org.eclipse.wst.xml.xpath2.api.ResultSequence;
import org.eclipse.wst.xml.xpath2.api.StaticContext;
import org.eclipse.wst.xml.xpath2.processor.DynamicError;
import org.eclipse.wst.xml.xpath2.processor.internal.SeqType;
import org.eclipse.wst.xml.xpath2.processor.internal.function.Function;
import org.eclipse.wst.xml.xpath2.processor.internal.types.ElementType;
import org.eclipse.wst.xml.xpath2.processor.internal.types.QName;
import org.eclipse.wst.xml.xpath2.processor.internal.types.XSString;
import org.w3c.dom.Element;

public class FnResolveQName
extends Function {
    private static Collection<SeqType> _expected_args = null;

    public FnResolveQName() {
        super(new QName("resolve-QName"), 2);
    }

    @Override
    public ResultSequence evaluate(Collection<ResultSequence> args, EvaluationContext ec) throws DynamicError {
        return FnResolveQName.resolve_QName(args, ec.getStaticContext());
    }

    public static ResultSequence resolve_QName(Collection<ResultSequence> args, StaticContext sc) throws DynamicError {
        Collection<ResultSequence> cargs = args;
        Iterator<ResultSequence> argiter = cargs.iterator();
        ResultSequence arg1 = argiter.next();
        if (arg1.empty()) {
            return ResultBuffer.EMPTY;
        }
        ResultSequence arg2 = argiter.next();
        String name = ((XSString)arg1.first()).value();
        QName qn = QName.parse_QName(name);
        if (qn == null) {
            throw DynamicError.lexical_error(null, null);
        }
        ElementType xselement = (ElementType)arg2.first();
        Element element = (Element)xselement.node_value();
        if (qn.prefix() != null) {
            String namespaceURI = element.lookupNamespaceURI(qn.prefix());
            if (namespaceURI == null) {
                throw DynamicError.invalidPrefix();
            }
            qn.set_namespace(namespaceURI);
        } else if (qn.local().equals(element.getLocalName()) && element.isDefaultNamespace(element.getNamespaceURI())) {
            qn.set_namespace(element.getNamespaceURI());
        }
        return qn;
    }

    public static synchronized Collection<SeqType> expected_args() {
        if (_expected_args == null) {
            _expected_args = new ArrayList<SeqType>();
            SeqType arg = new SeqType(new XSString(), 3);
            _expected_args.add(arg);
            _expected_args.add(new SeqType(new ElementType(), 0));
        }
        return _expected_args;
    }
}

