/*
 * Decompiled with CFR 0.152.
 */
package org.geotools.util.factory;

import java.awt.RenderingHints;
import java.lang.ref.Reference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Predicate;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.stream.Stream;
import org.geotools.metadata.i18n.Errors;
import org.geotools.metadata.i18n.Loggings;
import org.geotools.util.Classes;
import org.geotools.util.Utilities;
import org.geotools.util.factory.CategoryRegistry;
import org.geotools.util.factory.Factory;
import org.geotools.util.factory.FactoryIteratorProvider;
import org.geotools.util.factory.FactoryIteratorProviders;
import org.geotools.util.factory.FactoryNotFoundException;
import org.geotools.util.factory.FactoryRegistryException;
import org.geotools.util.factory.GeoTools;
import org.geotools.util.factory.Hints;
import org.geotools.util.factory.OptionalFactory;
import org.geotools.util.factory.RecursionCheckingHelper;
import org.geotools.util.factory.RecursiveSearchException;
import org.geotools.util.logging.Logging;

public class FactoryRegistry {
    protected static final Logger LOGGER = Logging.getLogger(FactoryRegistry.class);
    private static final Level DEBUG_LEVEL = Level.FINEST;
    private final CategoryRegistry registry;
    private final FactoryIteratorProviders globalConfiguration = new FactoryIteratorProviders();
    private final Set<Class<?>> needScanForPlugins = Collections.newSetFromMap(new ConcurrentHashMap());
    private final RecursionCheckingHelper scanningCategories = new RecursionCheckingHelper();
    private final RecursionCheckingHelper testingAvailability = new RecursionCheckingHelper();
    private final RecursionCheckingHelper testingHints = new RecursionCheckingHelper();

    public FactoryRegistry(Class<?> category) {
        this(Collections.singleton(category));
    }

    public FactoryRegistry(Class<?> ... categories) {
        this(Arrays.asList(categories));
    }

    protected void finalize() throws Throwable {
        this.deregisterAll();
        super.finalize();
    }

    public FactoryRegistry(Collection<Class<?>> categories) {
        this.registry = new CategoryRegistry(this, categories);
        this.needScanForPlugins.addAll(categories);
    }

    public Stream<Class<?>> streamCategories() {
        return this.registry.streamCategories();
    }

    public <T> T getFactoryByClass(Class<T> category) {
        return this.registry.getInstanceOfType(category).orElse(null);
    }

    public <T> Stream<T> getFactories(Class<T> category, boolean useOrdering) {
        return this.registry.streamInstances(category, useOrdering);
    }

    public <T> Stream<T> getFactories(Class<T> category, Predicate<? super T> factoryFilter, boolean useOrdering) {
        Stream<? super T> factories = this.getFactories(category, useOrdering);
        return factoryFilter == null ? factories : factories.filter(factoryFilter);
    }

    public <T> Stream<T> getFactories(Class<T> category, Predicate<? super T> filter, Hints hints) {
        if (this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        this.synchronizeIteratorProviders();
        this.scanForPluginsIfNeeded(category);
        Predicate<Object> isAcceptable = factory -> this.isAcceptable(category.cast(factory), category, hints, filter);
        return this.getFactories(category, isAcceptable, true);
    }

    final <T> Stream<T> getUnfilteredFactories(Class<T> category) {
        if (this.scanningCategories.contains(category)) {
            throw new RecursiveSearchException(category);
        }
        this.scanForPluginsIfNeeded(category);
        return this.getFactories(category, true);
    }

    public <T> T getFactory(Class<T> category, Predicate<? super T> filter, Hints hints, Hints.Key key) throws FactoryRegistryException {
        Optional<T> candidate;
        this.synchronizeIteratorProviders();
        boolean debug = LOGGER.isLoggable(DEBUG_LEVEL);
        if (debug) {
            FactoryRegistry.debug("ENTRY", category, key, null, null);
        }
        Class implementation = null;
        if (key != null) {
            Object hint;
            Class<?> valueClass = key.getValueClass();
            if (!category.isAssignableFrom(valueClass)) {
                if (debug) {
                    FactoryRegistry.debug("THROW", category, key, "unexpected type:", valueClass);
                }
                throw new IllegalArgumentException(Errors.format(69, key));
            }
            if (hints != null && (hint = hints.get(key)) != null) {
                if (debug) {
                    FactoryRegistry.debug("CHECK", category, key, "user provided a", hint.getClass());
                }
                if (category.isInstance(hint)) {
                    if (debug) {
                        FactoryRegistry.debug("RETURN", category, key, "return hint as provided.", null);
                    }
                    return category.cast(hint);
                }
                if ((hints = new Hints(hints)).remove(key) != hint) {
                    throw new AssertionError(key);
                }
                if (hint instanceof Class[]) {
                    Class[] types = (Class[])hint;
                    int length = types.length;
                    for (int i = 0; i < length - 1; ++i) {
                        Optional<T> candidate2;
                        Class type = types[i];
                        if (debug) {
                            FactoryRegistry.debug("CHECK", category, key, "consider hint[" + i + ']', type);
                        }
                        if (!(candidate2 = this.getFactoryImplementation(category, type, filter, hints)).isPresent()) continue;
                        if (debug) {
                            FactoryRegistry.debug("RETURN", category, key, "found implementation", candidate2.getClass());
                        }
                        return candidate2.get();
                    }
                    if (length != 0) {
                        implementation = types[length - 1];
                    }
                } else {
                    implementation = (Class)hint;
                }
            }
        }
        if (debug && implementation != null) {
            FactoryRegistry.debug("CHECK", category, key, "consider hint[last]", implementation);
        }
        if ((candidate = this.getFactoryImplementation(category, implementation, filter, hints)).isPresent()) {
            if (debug) {
                FactoryRegistry.debug("RETURN", category, key, "found implementation", candidate.getClass());
            }
            return candidate.get();
        }
        if (debug) {
            FactoryRegistry.debug("THROW", category, key, "could not find implementation.", null);
        }
        throw new FactoryNotFoundException(Errors.format(49, implementation != null ? implementation : category));
    }

    private static void debug(String status, Class<?> category, Hints.Key key, String message, Class<?> type) {
        if (LOGGER.isLoggable(DEBUG_LEVEL)) {
            StringBuilder buffer = new StringBuilder(status);
            buffer.append(Utilities.spaces(Math.max(1, 7 - status.length()))).append('(').append(Classes.getShortName(category));
            if (key != null) {
                buffer.append(", ").append(key);
            }
            buffer.append(')');
            if (message != null) {
                buffer.append(": ").append(message);
            }
            if (type != null) {
                buffer.append(' ').append(Classes.getShortName(type)).append('.');
            }
            LogRecord record = new LogRecord(DEBUG_LEVEL, buffer.toString());
            record.setSourceClassName(FactoryRegistry.class.getName());
            record.setSourceMethodName("getFactory");
            record.setLoggerName(LOGGER.getName());
            LOGGER.log(record);
        }
    }

    private <T> Optional<T> getFactoryImplementation(Class<T> category, Class<?> implementation, Predicate<? super T> filter, Hints hints) {
        Optional<Object> factory = this.getUnfilteredFactories(category).filter(candidate -> implementation == null || implementation.isInstance(candidate)).filter(candidate -> this.isAcceptable(candidate, category, hints, filter)).findFirst();
        if (factory.isPresent()) {
            return factory;
        }
        List<Reference<T>> cached = this.getCachedFactories(category);
        if (cached == null) {
            return Optional.empty();
        }
        Iterator<Reference<T>> it = cached.iterator();
        while (it.hasNext()) {
            T candidate2 = it.next().get();
            if (candidate2 == null) {
                it.remove();
                continue;
            }
            if (implementation != null && !implementation.isInstance(candidate2) || !this.isAcceptable(candidate2, category, hints, filter)) continue;
            return Optional.of(candidate2);
        }
        return Optional.empty();
    }

    <T> List<Reference<T>> getCachedFactories(Class<T> category) {
        return null;
    }

    final <T> boolean isAcceptable(T candidate, Class<T> category, Hints hints, Predicate<? super T> candidateFilter) {
        if (candidateFilter != null && !candidateFilter.test(candidate)) {
            return false;
        }
        if (!this.isAvailable(candidate)) {
            return false;
        }
        if (hints != null && candidate instanceof Factory && !this.usesAcceptableHints((Factory)candidate, category, hints, null)) {
            return false;
        }
        return this.isAcceptable(candidate, category, hints);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean usesAcceptableHints(Factory factory, Class<?> category, Hints hints, Set<Factory> alreadyDone) {
        Map<RenderingHints.Key, Object> implementationHints;
        if (!this.testingHints.addAndCheck(factory)) {
            return false;
        }
        try {
            implementationHints = Hints.stripNonKeys(factory.getImplementationHints());
        }
        finally {
            this.testingHints.removeAndCheck(factory);
        }
        if (implementationHints == null) {
            return true;
        }
        Hints remaining = null;
        for (Map.Entry<RenderingHints.Key, Object> entry : implementationHints.entrySet()) {
            Class type;
            RenderingHints.Key key = entry.getKey();
            Object value = entry.getValue();
            Object expected = hints.get(key);
            if (expected != null) {
                if (expected instanceof Class) {
                    if (!((Class)expected).isInstance(value)) {
                        return false;
                    }
                } else if (expected instanceof Class[]) {
                    Class[] types = (Class[])expected;
                    int i = 0;
                    do {
                        if (i < types.length) continue;
                        return false;
                    } while (!types[i++].isInstance(value));
                } else if (!expected.equals(value)) {
                    return false;
                }
            }
            if (!(value instanceof Factory)) continue;
            Factory dependency = (Factory)value;
            if (alreadyDone == null) {
                alreadyDone = new HashSet<Factory>();
            }
            if (alreadyDone.contains(dependency)) continue;
            alreadyDone.add(factory);
            if (remaining == null) {
                remaining = new Hints(hints);
                remaining.keySet().removeAll(implementationHints.keySet());
            }
            if (this.usesAcceptableHints(dependency, type = key instanceof Hints.Key ? ((Hints.Key)key).getValueClass() : Factory.class, remaining, alreadyDone)) continue;
            return false;
        }
        return true;
    }

    protected <T> boolean isAcceptable(T factory, Class<T> category, Hints hints) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isAvailable(Object factory) {
        if (!(factory instanceof OptionalFactory)) {
            return true;
        }
        OptionalFactory optionalFactory = (OptionalFactory)factory;
        Class<?> type = optionalFactory.getClass();
        if (!this.testingAvailability.addAndCheck(type)) {
            throw new RecursiveSearchException(type);
        }
        try {
            boolean bl = optionalFactory.isAvailable();
            return bl;
        }
        finally {
            this.testingAvailability.removeAndCheck(type);
        }
    }

    public final Set<ClassLoader> getClassLoaders() {
        ClassLoader[] asArray;
        HashSet<ClassLoader> loaders = new HashSet<ClassLoader>();
        for (int i = 0; i < 4; ++i) {
            ClassLoader loader;
            try {
                switch (i) {
                    case 0: {
                        loader = this.getClass().getClassLoader();
                        break;
                    }
                    case 1: {
                        loader = FactoryRegistry.class.getClassLoader();
                        break;
                    }
                    case 2: {
                        loader = Thread.currentThread().getContextClassLoader();
                        break;
                    }
                    case 3: {
                        loader = ClassLoader.getSystemClassLoader();
                        break;
                    }
                    default: {
                        throw new AssertionError(i);
                    }
                }
            }
            catch (SecurityException exception) {
                continue;
            }
            loaders.add(loader);
        }
        loaders.remove(null);
        loaders.addAll(GeoTools.getClassLoaders());
        for (ClassLoader loader : asArray = loaders.toArray(new ClassLoader[loaders.size()])) {
            try {
                while ((loader = loader.getParent()) != null) {
                    loaders.remove(loader);
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        if (loaders.isEmpty()) {
            LOGGER.warning("No class loaders available.");
        }
        return loaders;
    }

    public void scanForPlugins() {
        Set<ClassLoader> loaders = this.getClassLoaders();
        this.registry.streamCategories().forEach(category -> this.scanForPlugins((Collection<ClassLoader>)loaders, (Class)category));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private <T> void scanForPlugins(Collection<ClassLoader> loaders, Class<T> category) {
        if (!this.scanningCategories.addAndCheck(category)) {
            throw new RecursiveSearchException(category);
        }
        try {
            FactoryIteratorProvider[] fip;
            StringBuilder message = FactoryRegistry.getLogHeader(category);
            boolean newFactories = false;
            for (ClassLoader loader : loaders) {
                Iterator<T> factories = ServiceLoader.load(category, loader).iterator();
                newFactories |= this.register(factories, category, message);
                newFactories |= this.registerFromSystemProperty(loader, category, message);
            }
            for (FactoryIteratorProvider aFip : fip = FactoryIteratorProviders.getIteratorProviders()) {
                Iterator<T> it = aFip.iterator(category);
                if (it == null) continue;
                newFactories |= this.register(it, category, message);
            }
            if (newFactories) {
                FactoryRegistry.log("scanForPlugins", message);
            }
        }
        finally {
            this.scanningCategories.removeAndCheck(category);
        }
    }

    private synchronized void scanForPluginsIfNeeded(Class<?> category) {
        if (this.needScanForPlugins.remove(category)) {
            this.scanForPlugins(this.getClassLoaders(), category);
        }
    }

    public void registerFactories(Iterator<?> factories) {
        Utilities.ensureArgumentNonNull("factories", factories);
        factories.forEachRemaining(this::registerFactory);
    }

    public void registerFactories(Iterable<?> factories) {
        Utilities.ensureArgumentNonNull("factories", factories);
        factories.forEach(this::registerFactory);
    }

    public void registerFactory(Object factory) {
        this.registry.registerInstance(factory);
    }

    public <T> boolean registerFactory(T factory, Class<T> category) {
        if (!category.isAssignableFrom(factory.getClass())) {
            throw new ClassCastException();
        }
        return this.registry.registerInstance(factory, category);
    }

    private <T> boolean register(Iterator<T> factories, Class<T> category, StringBuilder message) {
        boolean newFactories = false;
        String lineSeparator = System.getProperty("line.separator", "\n");
        while (factories.hasNext()) {
            T factory;
            try {
                factory = factories.next();
            }
            catch (OutOfMemoryError error) {
                throw error;
            }
            catch (NoClassDefFoundError error) {
                FactoryRegistry.loadingFailure(category, error, false);
                continue;
            }
            catch (ExceptionInInitializerError error) {
                Throwable cause = error.getCause();
                if (cause != null) {
                    FactoryRegistry.loadingFailure(category, cause, true);
                }
                throw error;
            }
            catch (Error error) {
                if (!Classes.getShortClassName(error).equals("ServiceConfigurationError")) {
                    throw error;
                }
                FactoryRegistry.loadingFailure(category, error, true);
                continue;
            }
            if (!category.isAssignableFrom(factory.getClass())) continue;
            Class<T> factoryClass = factory.getClass().asSubclass(category);
            T replacement = this.getFactoryByClass(factoryClass);
            if (replacement != null) {
                factory = replacement;
            }
            if (!this.registerFactory(factory, category)) continue;
            message.append(lineSeparator);
            message.append("  ");
            message.append(factoryClass.getName());
            newFactories = true;
        }
        return newFactories;
    }

    private <T> boolean registerFromSystemProperty(ClassLoader loader, Class<T> category, StringBuilder message) {
        boolean newFactories;
        block9: {
            newFactories = false;
            try {
                String classname = System.getProperty(category.getName());
                if (classname == null) break block9;
                try {
                    Class<?> candidate = loader.loadClass(classname);
                    if (!category.isAssignableFrom(candidate)) break block9;
                    Class<T> factoryClass = candidate.asSubclass(category);
                    T factory = this.getFactoryByClass(factoryClass);
                    if (factory == null) {
                        try {
                            factory = factoryClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                            if (this.registerFactory(factory, category)) {
                                message.append(System.getProperty("line.separator", "\n"));
                                message.append("  ");
                                message.append(factoryClass.getName());
                                newFactories = true;
                            }
                        }
                        catch (Exception exception) {
                            throw new FactoryRegistryException(Errors.format(23, classname), exception);
                        }
                    }
                    Iterable factories = this.getFactories(category, false)::iterator;
                    for (Object other : factories) {
                        if (other == factory) continue;
                        this.setOrdering(category, factory, other);
                    }
                }
                catch (ClassNotFoundException classNotFoundException) {
                }
            }
            catch (SecurityException securityException) {
                // empty catch block
            }
        }
        return newFactories;
    }

    private static void loadingFailure(Class<?> category, Throwable error, boolean showStackTrace) {
        String name = Classes.getShortName(category);
        StringBuilder cause = new StringBuilder(Classes.getShortClassName(error));
        String message = error.getLocalizedMessage();
        if (message != null) {
            cause.append(": ");
            cause.append(message);
        }
        LogRecord record = Loggings.format(Level.WARNING, 8, name, cause.toString());
        if (showStackTrace) {
            record.setThrown(error);
        }
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName("scanForPlugins");
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    private static StringBuilder getLogHeader(Class<?> category) {
        return new StringBuilder(Loggings.getResources(null).getString(21, category));
    }

    private static void log(String method, StringBuilder message) {
        LogRecord record = new LogRecord(Level.CONFIG, message.toString());
        record.setSourceClassName(FactoryRegistry.class.getName());
        record.setSourceMethodName(method);
        record.setLoggerName(LOGGER.getName());
        LOGGER.log(record);
    }

    private void synchronizeIteratorProviders() {
        FactoryIteratorProvider[] newProviders = this.globalConfiguration.synchronizeIteratorProviders();
        if (newProviders == null) {
            return;
        }
        this.registry.streamCategories().filter(category -> !this.needScanForPlugins.contains(category)).forEach(category -> {
            for (FactoryIteratorProvider newProvider : newProviders) {
                this.register(newProvider, (Class)category);
            }
        });
    }

    private <T> void register(FactoryIteratorProvider provider, Class<T> category) {
        StringBuilder message;
        Iterator<T> it = provider.iterator(category);
        if (it != null && this.register(it, category, message = FactoryRegistry.getLogHeader(category))) {
            FactoryRegistry.log("synchronizeIteratorProviders", message);
        }
    }

    public void deregisterAll() {
        this.registry.deregisterInstances();
    }

    public void deregisterAll(Class<?> category) {
        this.registry.deregisterInstances(category);
    }

    public void deregisterFactories(Iterator<?> factories) {
        Utilities.ensureArgumentNonNull("factories", factories);
        factories.forEachRemaining(this::deregisterFactory);
    }

    public void deregisterFactories(Iterable<?> factories) {
        Utilities.ensureArgumentNonNull("factories", factories);
        factories.forEach(this::deregisterFactory);
    }

    public void deregisterFactory(Object factory) {
        this.registry.deregisterInstance(factory);
    }

    public <T> boolean deregisterFactory(T factory, Class<T> category) {
        Utilities.ensureArgumentNonNull("factory", factory);
        Utilities.ensureArgumentNonNull("category", category);
        if (!category.isAssignableFrom(factory.getClass())) {
            throw new ClassCastException();
        }
        return this.registry.deregisterInstance(factory, category);
    }

    public <T> boolean setOrdering(Class<T> category, T firstFactory, T secondFactory) {
        if (firstFactory == secondFactory) {
            throw new IllegalArgumentException("Factories must not be the same instance.");
        }
        return this.registry.setOrder(category, firstFactory, secondFactory);
    }

    public <T> boolean setOrdering(Class<T> category, Comparator<T> comparator) {
        boolean set = false;
        ArrayList previous = new ArrayList();
        Iterable factories = this.getFactories(category, false)::iterator;
        for (Object f1 : factories) {
            int i = previous.size();
            while (--i >= 0) {
                int c;
                Object f2 = previous.get(i);
                try {
                    c = comparator.compare(f1, f2);
                }
                catch (ClassCastException exception) {
                    continue;
                }
                if (c > 0) {
                    set |= this.setOrdering(category, f1, f2);
                    continue;
                }
                if (c >= 0) continue;
                set |= this.setOrdering(category, f2, f1);
            }
            previous.add(f1);
        }
        return set;
    }

    public <T> boolean setOrdering(Class<T> base, boolean set, Predicate<? super T> filter1, Predicate<? super T> filter2) {
        Utilities.ensureArgumentNonNull("filter1", filter1);
        Utilities.ensureArgumentNonNull("filter2", filter2);
        return this.registry.streamCategories().flatMap(category -> Utilities.streamIfSubtype(category, base)).map(category -> this.setOrUnsetOrdering((Class)category, set, filter1, filter2)).reduce((done1, done2) -> done1 != false || done2 != false).orElse(false);
    }

    private <T> boolean setOrUnsetOrdering(Class<T> category, boolean set, Predicate<? super T> filter1, Predicate<? super T> filter2) {
        boolean done = false;
        T impl1 = null;
        T impl2 = null;
        Iterable factories = this.getFactories(category, false)::iterator;
        for (Object factory : factories) {
            if (filter1.test(factory)) {
                impl1 = factory;
            }
            if (filter2.test(factory)) {
                impl2 = factory;
            }
            if (impl1 == null || impl2 == null || impl1 == impl2) continue;
            if (set) {
                done |= this.setOrdering(category, impl1, impl2);
                continue;
            }
            done |= this.unsetOrdering(category, impl1, impl2);
        }
        return done;
    }

    public <T> boolean unsetOrdering(Class<T> category, T firstFactory, T secondFactory) {
        if (firstFactory == secondFactory) {
            throw new IllegalArgumentException("Factories must not be the same instance.");
        }
        return this.registry.clearOrder(category, firstFactory, secondFactory);
    }
}

