/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.fileutils.charsets;

import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.nio.charset.CoderResult;

public class FixedWin1252Charset
extends Charset {
    public static final String CHARSET = "cp1252fix";
    public static final char[][] CHARS_UNICODE_SORT = new char[][]{{'\u009d', '\u009d'}, {'\u008f', '\u008f'}, {'\u008d', '\u008d'}, {'\u0090', '\u0090'}, {'\u0081', '\u0081'}, {'\u20ac', '\u0080'}, {'\u0160', '\u008a'}, {'\u0161', '\u009a'}, {'\u017d', '\u008e'}, {'\u017e', '\u009e'}, {'\u0152', '\u008c'}, {'\u0153', '\u009c'}, {'\u0178', '\u009f'}};

    protected FixedWin1252Charset() {
        super(CHARSET, new String[]{"cp1252"});
    }

    @Override
    public boolean contains(Charset cs) {
        return cs.name().equals("windows-1252");
    }

    @Override
    public CharsetDecoder newDecoder() {
        return new PrivCharsetDecoder(this, 1.0f, 1.0f);
    }

    @Override
    public CharsetEncoder newEncoder() {
        return new PrivCharsetEncoder(this, 1.0f, 1.0f);
    }

    public class PrivCharsetDecoder
    extends CharsetDecoder {
        public PrivCharsetDecoder(Charset cs, float averageCharsPerByte, float maxCharsPerByte) {
            super(cs, averageCharsPerByte, maxCharsPerByte);
        }

        @Override
        protected CoderResult decodeLoop(ByteBuffer in, CharBuffer out) {
            while (in.hasRemaining()) {
                char inputChar = (char)(in.get() & 0xFF);
                int i = 0;
                while (i < CHARS_UNICODE_SORT.length) {
                    if (inputChar == CHARS_UNICODE_SORT[i][1]) {
                        inputChar = CHARS_UNICODE_SORT[i][0];
                        break;
                    }
                    ++i;
                }
                out.put(inputChar);
            }
            return CoderResult.UNDERFLOW;
        }
    }

    public class PrivCharsetEncoder
    extends CharsetEncoder {
        public PrivCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar, byte[] replacement) {
            super(cs, averageBytesPerChar, maxBytesPerChar, replacement);
        }

        public PrivCharsetEncoder(Charset cs, float averageBytesPerChar, float maxBytesPerChar) {
            super(cs, averageBytesPerChar, maxBytesPerChar);
        }

        @Override
        protected CoderResult encodeLoop(CharBuffer in, ByteBuffer out) {
            while (in.hasRemaining()) {
                char inputChar = in.get();
                int i = 0;
                while (i < CHARS_UNICODE_SORT.length) {
                    if (inputChar == CHARS_UNICODE_SORT[i][0]) {
                        inputChar = CHARS_UNICODE_SORT[i][1];
                        break;
                    }
                    ++i;
                }
                out.put((byte)(inputChar & 0xFF));
            }
            return CoderResult.UNDERFLOW;
        }
    }
}

