/*
 * Decompiled with CFR 0.152.
 */
package schemacrawler.crawl;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.logging.Logger;
import schemacrawler.crawl.AbstractRetriever;
import schemacrawler.crawl.MetadataResultSet;
import schemacrawler.crawl.MutableCatalog;
import schemacrawler.crawl.RetrieverConnection;
import schemacrawler.filter.InclusionRuleFilter;
import schemacrawler.inclusionrule.InclusionRule;
import schemacrawler.schemacrawler.InformationSchemaKey;
import schemacrawler.schemacrawler.InformationSchemaViews;
import schemacrawler.schemacrawler.Query;
import schemacrawler.schemacrawler.SchemaCrawlerOptions;
import schemacrawler.schemacrawler.SchemaReference;
import us.fatehi.utility.database.DatabaseUtility;
import us.fatehi.utility.string.StringFormat;

final class SchemaRetriever
extends AbstractRetriever {
    private static final Logger LOGGER = Logger.getLogger(SchemaRetriever.class.getName());
    private final boolean supportsCatalogs;
    private final boolean supportsSchemas;

    SchemaRetriever(RetrieverConnection retrieverConnection, MutableCatalog catalog, SchemaCrawlerOptions options) throws SQLException {
        super(retrieverConnection, catalog, options);
        this.supportsCatalogs = retrieverConnection.isSupportsCatalogs();
        this.supportsSchemas = retrieverConnection.isSupportsSchemas();
    }

    void retrieveSchemas(InclusionRule schemaInclusionRule) throws SQLException {
        InclusionRuleFilter<SchemaReference> schemaFilter = new InclusionRuleFilter<SchemaReference>(schemaInclusionRule, true);
        if (schemaFilter.isExcludeAll()) {
            return;
        }
        Set<SchemaReference> schemaRefs = this.retrieveAllSchemasFromInformationSchemaViews();
        if (schemaRefs.isEmpty()) {
            schemaRefs.addAll(this.retrieveAllSchemas());
        }
        Iterator<SchemaReference> iterator = schemaRefs.iterator();
        while (iterator.hasNext()) {
            SchemaReference schemaRef = iterator.next();
            if (schemaFilter.test(schemaRef)) continue;
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Excluding schema <%s>", new Object[]{schemaRef}));
            iterator.remove();
        }
        for (SchemaReference schemaRef : schemaRefs) {
            this.catalog.addSchema(schemaRef);
        }
        if (!this.supportsCatalogs && !this.supportsSchemas) {
            this.catalog.addSchema(new SchemaReference(null, null));
        }
    }

    private Set<String> retrieveAllCatalogs() {
        LOGGER.log(Level.INFO, "Retrieving all catalogs");
        HashSet<String> catalogNames = new HashSet<String>();
        if (this.supportsCatalogs) {
            try (ResultSet catalogsResults = this.getMetaData().getCatalogs();){
                int numCatalogs = 0;
                List metaDataCatalogNames = DatabaseUtility.readResultsVector((ResultSet)catalogsResults);
                for (String catalogName : metaDataCatalogNames) {
                    ++numCatalogs;
                    catalogNames.add(catalogName);
                }
                LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d catalogs", new Object[]{numCatalogs}));
            }
            catch (SQLException e) {
                LOGGER.log(Level.WARNING, e.getMessage(), e);
            }
            LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieved catalogs <%s>", new Object[]{catalogNames}));
        }
        return catalogNames;
    }

    /*
     * Unable to fully structure code
     */
    private Set<SchemaReference> retrieveAllSchemas() throws SQLException {
        block19: {
            block17: {
                SchemaRetriever.LOGGER.log(Level.INFO, "Retrieving all schemas");
                schemaRefs = new HashSet<SchemaReference>();
                allCatalogNames = this.retrieveAllCatalogs();
                if (!this.supportsSchemas) break block17;
                numSchemas = 0;
                results = new MetadataResultSet(this.getMetaData().getSchemas(), "DatabaseMetaData::getSchemas");
                var5_7 = null;
lbl8:
                // 2 sources

                try {
                    while (results.next()) {
                        block18: {
                            ++numSchemas;
                            catalogName = this.normalizeCatalogName(results.getString("TABLE_CATALOG"));
                            schemaName = results.getString("TABLE_SCHEM");
                            SchemaRetriever.LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving schema: %s --> %s", new Object[]{catalogName, schemaName}));
                            if (catalogName != null) break block18;
                            if (allCatalogNames.isEmpty()) {
                                schemaRefs.add(new SchemaReference(null, schemaName));
                                continue;
                            }
                            for (String expectedCatalogName : allCatalogNames) {
                                schemaRefs.add(new SchemaReference(expectedCatalogName, schemaName));
                            }
                            ** GOTO lbl8
                        }
                        schemaRefs.add(new SchemaReference(catalogName, schemaName));
                    }
                }
                catch (Throwable var6_10) {
                    var5_7 = var6_10;
                    throw var6_10;
                }
                finally {
                    if (results != null) {
                        if (var5_7 != null) {
                            try {
                                results.close();
                            }
                            catch (Throwable var6_9) {
                                var5_7.addSuppressed(var6_9);
                            }
                        } else {
                            results.close();
                        }
                    }
                }
                SchemaRetriever.LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d schemas", new Object[]{numSchemas}));
                break block19;
            }
            for (String catalogName : allCatalogNames) {
                SchemaRetriever.LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving schema: %s --> %s", new Object[]{catalogName, null}));
                schemaRefs.add(new SchemaReference(catalogName, null));
            }
        }
        return schemaRefs;
    }

    private Set<SchemaReference> retrieveAllSchemasFromInformationSchemaViews() throws SQLException {
        HashSet<SchemaReference> schemaRefs = new HashSet<SchemaReference>();
        InformationSchemaViews informationSchemaViews = this.getRetrieverConnection().getInformationSchemaViews();
        if (!informationSchemaViews.hasQuery(InformationSchemaKey.SCHEMATA)) {
            LOGGER.log(Level.FINE, "Schemata SQL statement was not provided");
            return schemaRefs;
        }
        Query schemataSql = informationSchemaViews.getQuery(InformationSchemaKey.SCHEMATA);
        try (Statement statement = this.createStatement();
             MetadataResultSet results = new MetadataResultSet(schemataSql, statement, this.getSchemaInclusionRule());){
            int numSchemas = 0;
            while (results.next()) {
                ++numSchemas;
                String catalogName = results.getString("CATALOG_NAME");
                String schemaName = results.getString("SCHEMA_NAME");
                LOGGER.log(Level.FINER, (Supplier<String>)new StringFormat("Retrieving schema: %s --> %s", new Object[]{catalogName, schemaName}));
                schemaRefs.add(new SchemaReference(catalogName, schemaName));
            }
            LOGGER.log(Level.INFO, (Supplier<String>)new StringFormat("Processed %d schemas", new Object[]{numSchemas}));
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Could not retrieve schemas", e);
        }
        return schemaRefs;
    }
}

