/*
 * Decompiled with CFR 0.152.
 */
package com.codepoetics.protonpack.stateful;

import com.codepoetics.protonpack.stateful.ComposedStateMachine;
import com.codepoetics.protonpack.stateful.StateMachineRunner;
import com.codepoetics.protonpack.stateful.Transition;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Stream;

public interface StateMachine<S, I, O> {
    public static <S, I, O> StateMachine<S, I, O> create(Supplier<S> initialState, BiFunction<S, I, Transition<S, O>> transitionFunction) {
        return StateMachine.create(initialState, transitionFunction, s -> false);
    }

    public static <S, I, O> StateMachine<S, I, O> create(Supplier<S> initialState, BiFunction<S, I, Transition<S, O>> transitionFunction, Predicate<S> isTerminal) {
        return StateMachine.create(initialState, transitionFunction, isTerminal, s -> Stream.empty());
    }

    public static <S, I, O> StateMachine<S, I, O> create(Supplier<S> initialState, BiFunction<S, I, Transition<S, O>> transitionFunction, Predicate<S> isTerminal, Function<S, Stream<O>> finisher) {
        return new ComposedStateMachine<S, I, O>(initialState, transitionFunction, isTerminal, finisher);
    }

    public Transition<S, O> apply(S var1, I var2);

    default public boolean isTerminal(S state) {
        return false;
    }

    default public Stream<O> finish(S finalState) {
        return Stream.empty();
    }

    public S getInitialState();

    default public StateMachineRunner<S, I, O> runner() {
        return this.runnerWith(this.getInitialState());
    }

    default public StateMachineRunner<S, I, O> runnerWith(S initialState) {
        return StateMachineRunner.create(initialState, this);
    }
}

