/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.view.tabs.ITabSaver;
import com.sigge.filerunner.view.tabs.TabContent;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.Component;
import java.io.File;
import javax.swing.JFileChooser;
import javax.swing.JOptionPane;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileNameExtensionFilter;

@Singleton
public class TabManagerSaver
implements ITabSaver {
    private final DnDTabbedPane pane;

    @Inject
    public TabManagerSaver(@Named(value="mainTab") DnDTabbedPane pane) {
        this.pane = pane;
    }

    @Override
    public File save(TabContent tc) {
        return this.getFile(tc, false);
    }

    @Override
    public File saveAs(TabContent tc) {
        return this.getFile(tc, true);
    }

    private File getFile(TabContent tc, boolean saveAs) {
        File fileToSave = null;
        if (!tc.isAFile() || saveAs) {
            JFileChooser fc = new JFileChooser();
            FileNameExtensionFilter fs = new FileNameExtensionFilter("SQL-files (*.sql)", "sql");
            FileFilter ff = fc.getAcceptAllFileFilter();
            fc.setAcceptAllFileFilterUsed(false);
            fc.setFileSelectionMode(0);
            fc.addChoosableFileFilter(fs);
            fc.addChoosableFileFilter(ff);
            fc.setMultiSelectionEnabled(false);
            File dir = new File(ConfigHandler.getConfig().getLastDirectory());
            if (dir.exists() && dir.isDirectory()) {
                fc.setCurrentDirectory(dir);
            }
            fc.setSelectedFile(tc.isAFile() ? new File(tc.getFileName()) : new File(String.valueOf(tc.getTitle()) + ".sql"));
            int result = fc.showSaveDialog((Component)this.pane);
            if (result == 0) {
                File f = fc.getSelectedFile();
                if (!fc.getFileFilter().accept(f) && FileUtils.hasNoExtension(f)) {
                    f = new File(String.valueOf(f.getAbsolutePath()) + ".sql");
                }
                if (!f.exists() || tc.isAFile() && f.equals(new File(tc.getFileName())) || JOptionPane.showConfirmDialog((Component)this.pane, "Do you want to overwrite file?" + f.getName(), "Are you sure?", 0) == 0) {
                    fileToSave = f;
                }
            }
        } else {
            fileToSave = new File(tc.getFileName());
        }
        return fileToSave;
    }
}

