/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.ActionUtils;
import com.sigge.filerunner.commands.TabCommands;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.CardHolder;
import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.core.Encoding;
import com.sigge.filerunner.core.FileTransferable;
import com.sigge.filerunner.core.FileUtils;
import com.sigge.filerunner.core.IFeedback;
import com.sigge.filerunner.core.ProcessUtils;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.ButtonTabComponent;
import com.sigge.filerunner.view.core.ComponentUtils;
import com.sigge.filerunner.view.menu.RecentMenuHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.DefaultLineDetectionChangeTracker;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.tabs.ITabEditor;
import com.sigge.filerunner.view.tabs.ITabSaver;
import com.sigge.filerunner.view.tabs.TabActionUtils;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tabs.TabContentDocumentListener;
import com.sigge.filerunner.view.tabs.TabContentEditorListener;
import com.sigge.filerunner.view.tabs.TabUtils;
import com.sigge.filerunner.view.tabs.TextEditor;
import com.sigge.fileutils.FileWatcher;
import com.sigge.fileutils.FileWatcherListener;
import com.siggemannen.core.Tuple;
import com.siggemannen.view.DnDTabbedPane;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTabbedPane;
import javax.swing.SwingUtilities;
import javax.swing.event.DocumentListener;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.text.Element;
import org.fife.ui.rsyntaxtextarea.ErrorStrip;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextScrollPane;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class TabManager
implements FileWatcherListener,
Provider<Consumer<File>> {
    private final DnDTabbedPane tab;
    private final CardHolder<TabContent> holder;
    private final AtomicInteger counter = new AtomicInteger(0);
    private boolean suspend = false;
    private final List<TabContentEditorListener> tabContentListeners = new ArrayList<TabContentEditorListener>();
    private final Map<Integer, TabContent> tabmap = new HashMap<Integer, TabContent>();
    private final Map<Integer, ITabEditor> rmap = new HashMap<Integer, ITabEditor>();
    private final Map<Integer, JPanel> panelmap = new HashMap<Integer, JPanel>();
    private FileWatcher fw;
    private final List<File> changeQueue = Collections.synchronizedList(new ArrayList());
    private final List<File> ownChangeQueue = Collections.synchronizedList(new ArrayList());
    private final Map<Integer, TabContentDocumentListener> tabContentDocumentListeners = new HashMap<Integer, TabContentDocumentListener>();
    private static final ScheduledExecutorService SCHEDULER = Executors.newSingleThreadScheduledExecutor();
    private static final ExecutorService EXECUTOR = Executors.newWorkStealingPool();
    private final RecentMenuHandler recentMenuHandler;
    private final Icon loader = IconUtils.getSmallAnimatedIcon("loader_small.gif");
    private final ITabSaver saver;
    private final IFeedback feedback;
    private static final String STATE_ACTIVE = "STATE_ACTIVE";
    private static final Logger LOGGER = LoggerFactory.getLogger(TabManager.class);

    @Inject
    public TabManager(@Named(value="mainTab") DnDTabbedPane jt, RecentMenuHandler handler, final CardHolder<TabContent> holder, ITabSaver saver, IFeedback feedback) {
        LOGGER.debug("Create tab manager");
        this.tab = jt;
        this.recentMenuHandler = handler;
        this.saver = saver;
        this.feedback = feedback;
        this.recentMenuHandler.initializeList();
        this.holder = holder;
        try {
            this.fw = new FileWatcher();
            this.fw.addFileChangeListener((FileWatcherListener)this);
        }
        catch (Exception e1) {
            LOGGER.error("Couldn't create file watcher", (Throwable)e1);
        }
        this.tab.addChangeListener(e -> {
            if (!this.suspend && this.tab.getSelectedIndex() != holder.currentIndex()) {
                holder.current(this.tab.getSelectedIndex());
            }
        });
        this.tab.addTabMoveListener((event, from, to) -> {
            Object e = holder.move(from, to);
        });
        holder.addListener(new CardHolder.CardHolderListener<TabContent>(){

            @Override
            public boolean previewDeleted(TabContent element, int index) {
                int i = 0;
                while (i < TabManager.this.tabContentListeners.size()) {
                    if (!((TabContentEditorListener)TabManager.this.tabContentListeners.get(i)).previewEditorRemoval(element, (ITabEditor)TabManager.this.rmap.get(index))) {
                        return false;
                    }
                    ++i;
                }
                return true;
            }

            @Override
            public TabContent resyncElementBeforeDelete(TabContent element) {
                if (element.isAFile()) {
                    TabManager.this.tabContentListeners.forEach(l -> l.editorRemoved(element, (ITabEditor)TabManager.this.rmap.get(element.getId())));
                }
                return element;
            }

            @Override
            public void deleted(TabContent element, int index) {
                TabManager.this.suspend = true;
                TabManager.this.tab.remove(index);
                ActionMap am = TabManager.this.tab.getActionMap();
                Action action = am.get("scrollTabsBackwardAction");
                if (action != null) {
                    action.actionPerformed(new ActionEvent(TabManager.this.tab, 1001, ""));
                }
                TabManager.this.tabContentListeners.forEach(l -> l.editorRemoved(element, (ITabEditor)TabManager.this.rmap.get(element.getId())));
                Integer id = element.getId();
                TabManager.this.rmap.remove(id);
                TabManager.this.tabmap.remove(id);
                TabManager.this.panelmap.remove(id);
                TabManager.this.tabContentDocumentListeners.remove(id);
                if (element.isAFile()) {
                    TabManager.this.fw.removeFileToWatch(new File(element.getFileName()));
                }
                TabManager.this.suspend = false;
                if (TabManager.this.tabmap.size() == 0) {
                    SwingUtilities.invokeLater(() -> {
                        TabContent tabContent = TabManager.this.add();
                    });
                }
            }

            @Override
            public synchronized void added(TabContent tc, int index) {
                String title = tc.getTitle();
                JPanel jp2 = new JPanel();
                jp2.setBorder(BorderFactory.createEmptyBorder());
                jp2.setLayout(new BorderLayout());
                JPanel jp = new JPanel();
                jp.setBorder(BorderFactory.createEmptyBorder());
                jp2.add((Component)jp, "Center");
                TabManager.this.tab.addTab(title, null, (Component)jp2, tc.getFileName() != null && tc.getFileName().length() > 0 ? tc.getFileName() : null);
                JLabel tabLabel = new JLabel("<html>&nbsp;&nbsp;" + title + "&nbsp;&nbsp;");
                TabManager.this.tab.setTabComponentAt(index, (Component)new ButtonTabComponent((JTabbedPane)TabManager.this.tab, tabLabel, e -> holder.removeAndChangeToPrevious((int)e)));
                RSQLSyntaxTextArea rx = new RSQLSyntaxTextArea(tc.getContent(), tc.getContentType());
                rx.discardAllEdits();
                boolean lateload = false;
                TabContentDocumentListener listener = new TabContentDocumentListener(holder, (JTabbedPane)TabManager.this.tab, tc, rx, tc.getContent());
                rx.getDocument().addDocumentListener((DocumentListener)((Object)listener));
                rx.setName(tc.getTitle());
                ComponentUtils.removeTravelsalForComponent((JComponent)((Object)rx), true);
                RTextScrollPane rtxp = new RTextScrollPane((RTextArea)rx);
                ComponentUtils.removeTravelsalForComponent((JComponent)rtxp, true);
                rtxp.setViewportView((Component)((Object)rx));
                rtxp.setPreferredSize(new Dimension(200, 300));
                TabManager.this.tabmap.put(tc.getId(), tc);
                TabManager.this.rmap.put(tc.getId(), new TextEditor(rx));
                TabManager.this.panelmap.put(tc.getId(), jp);
                TabManager.this.tabContentDocumentListeners.put(tc.getId(), listener);
                TabManager.this.tabContentListeners.forEach(l -> l.editorAdded(tc, rx));
                jp.setLayout(new BorderLayout());
                jp.add((Component)rtxp, "Center");
                ErrorStrip es = new ErrorStrip(rx);
                jp.add((Component)es, "After");
                if (lateload) {
                    SwingUtilities.invokeLater(() -> {
                        rx.setText(tc.getContent());
                        rx.discardAllEdits();
                        rx.setEditable(true);
                        rx.requestFocusInWindow();
                        rx.setCaretPosition(0);
                    });
                } else {
                    SwingUtilities.invokeLater(() -> {
                        rx.requestFocusInWindow();
                        rx.setCaretPosition(0);
                    });
                }
                if (tc.isAFile()) {
                    try {
                        TabManager.this.fw.addFileToWatch(new File(tc.getFileName()));
                    }
                    catch (IOException e2) {
                        e2.printStackTrace();
                    }
                }
            }

            @Override
            public void replaced(TabContent newElement, TabContent oldElement, int index) {
                Integer id = newElement.getId();
                TabManager.this.tabmap.put(id, newElement);
                RSyntaxTextArea rSyntaxTextArea = (RSyntaxTextArea)((ITabEditor)TabManager.this.rmap.get(id)).getEditorComponent();
                rSyntaxTextArea.getDocument().removeDocumentListener((DocumentListener)TabManager.this.tabContentDocumentListeners.get(id));
                TabContentDocumentListener listener = new TabContentDocumentListener(holder, (JTabbedPane)TabManager.this.tab, newElement, rSyntaxTextArea, rSyntaxTextArea.getText());
                rSyntaxTextArea.getDocument().addDocumentListener((DocumentListener)((Object)listener));
                TabManager.this.tabContentDocumentListeners.put(id, listener);
                TabManager.this.tab.setTabComponentAt(index, (Component)new ButtonTabComponent((JTabbedPane)TabManager.this.tab, new JLabel("<html>&nbsp;&nbsp;" + newElement.getTitle() + "&nbsp;&nbsp;"), e -> holder.removeAndChangeToPrevious((int)e)));
                if (oldElement.isAFile() && !newElement.getFileName().equals(newElement.getFileName())) {
                    TabManager.this.fw.removeFileToWatch(new File(oldElement.getFileName()));
                }
                if (newElement.isAFile()) {
                    TabManager.this.tab.setToolTipTextAt(index, newElement.getFileName());
                    try {
                        if (!newElement.getFileName().equals(oldElement.getFileName())) {
                            TabManager.this.fw.addFileToWatch(new File(newElement.getFileName()));
                        }
                    }
                    catch (IOException iOException) {}
                } else {
                    TabManager.this.tab.setToolTipTextAt(index, null);
                }
            }

            @Override
            public void newCurrent(TabContent element, int index) {
                if (TabManager.this.suspend) {
                    return;
                }
                element.setStateValue(TabManager.STATE_ACTIVE, null);
                TabManager.this.tab.setSelectedIndex(index);
                ButtonTabComponent tabComponent = (ButtonTabComponent)TabManager.this.tab.getTabComponentAt(holder.getIndex(element));
                tabComponent.setLabelFont(tabComponent.getFont().deriveFont(0));
                TabManager.this.tabContentListeners.forEach(l -> l.newActive(element, (ITabEditor)TabManager.this.rmap.get(element.getId())));
            }
        });
        ComponentUtils.removeTravelsalForComponent((JComponent)this.tab, true);
    }

    @Inject
    private void setupTabContext(final TabCommands.CloseCurrentTab closeTab, final TabCommands.RemoveOthers removeOthers, final TabCommands.RemoveLeft removeLeft, final TabCommands.RemoveRight removeRight, final TabCommands.RemoveAll removeAll, final TabCommands.FreezeTab freezeTab) {
        this.tab.addMouseListener((MouseListener)new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent me) {
                int tabNr = TabUtils.getTabForMouseEvent((JTabbedPane)TabManager.this.tab, me);
                if (tabNr == -1) {
                    return;
                }
                if (ButtonUtils.isRightClick(me)) {
                    JPopupMenu pp = new JPopupMenu("Close tab");
                    TabContent tc = (TabContent)TabManager.this.holder.getValueAt(tabNr);
                    if (tc.isAFile()) {
                        pp.add(ActionUtils.createMenuAction("Browse to...", IconUtils.getSmallIcon("folder_into.png"), e -> ProcessUtils.browseToFile(new File(tc.getFileName()))));
                        pp.addSeparator();
                        pp.add(ActionUtils.createMenuAction("Copy file", IconUtils.getSmallIcon("copy.png"), e -> {
                            File f = new File(tc.getFileName());
                            FileTransferable ft = new FileTransferable(Arrays.asList(f));
                            Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ft, ft);
                        }));
                        pp.addSeparator();
                        pp.add(ActionUtils.createMenuAction("Copy file name", IconUtils.getSmallIcon("copy.png"), e -> {
                            File f = new File(tc.getFileName());
                            ClipboardUtils.setStringDataToClipboard(f.getName());
                        }));
                        pp.add(ActionUtils.createMenuAction("Copy full path", IconUtils.getSmallIcon("clipboard_next.png"), e -> ClipboardUtils.setStringDataToClipboard(tc.getFileName())));
                        pp.addSeparator();
                        pp.add(ActionUtils.createMenuAction("Rename file", null, e -> TabManager.this.renameFile(tc)));
                        pp.addSeparator();
                    } else {
                        pp.add(ActionUtils.createMenuAction("Rename tab", null, e -> TabManager.this.renameTab(tc)));
                    }
                    pp.add(ActionUtils.createMenuAction("Freeze tab", null, freezeTab));
                    pp.addSeparator();
                    pp.add(ActionUtils.createMenuAction("Close tab", IconUtils.getSmallIcon("close.png"), closeTab));
                    pp.add(ActionUtils.createMenuAction("Close others", null, removeOthers));
                    pp.add(ActionUtils.createMenuAction("Close left", null, removeLeft));
                    pp.add(ActionUtils.createMenuAction("Close right", null, removeRight));
                    pp.addSeparator();
                    pp.add(ActionUtils.createMenuAction("Close all", null, removeAll));
                    pp.show((Component)TabManager.this.tab, me.getX(), me.getY());
                } else if (me.getButton() == 2) {
                    TabManager.this.holder.removeAndChangeToPrevious(tabNr);
                }
            }
        });
    }

    private void renameTab(TabContent tc) {
        String name = JOptionPane.showInputDialog("Rename file to", (Object)tc.getTitle());
        if (name == null) {
            return;
        }
        String originalName = tc.getTitle();
        TabContent newElement = new TabContent(name, null, tc.getContent(), tc.getContentType(), tc.getEncoding());
        newElement.assignId(tc.getId());
        newElement.setStateValue("ORIGINALTITLE", originalName);
        this.holder.replaceCurrent(newElement);
    }

    public void replaceTab(TabContent tc) {
        this.holder.replaceCurrent(tc);
    }

    private void renameFile(TabContent tc) {
        block8: {
            File f = new File(tc.getFileName());
            String name = JOptionPane.showInputDialog("Rename file to", (Object)f.getName());
            if (name == null || f.getName().equals(name)) {
                return;
            }
            File newFile = Paths.get(f.getParent(), name).toFile();
            if (newFile.exists()) {
                this.feedback.showMessage(null, "File " + name + " already exists");
                return;
            }
            this.ownChangeQueue.add(f);
            this.ownChangeQueue.add(newFile);
            try {
                try {
                    if (f.renameTo(newFile)) {
                        TabContent newElement = new TabContent(newFile.getName(), newFile.getAbsolutePath(), tc.getContent(), tc.getEncoding());
                        newElement.assignId(tc.getId());
                        this.holder.replaceCurrent(newElement);
                    }
                }
                catch (Exception e) {
                    this.feedback.showMessage((JComponent)this.tab, "Couldn't save file due to:" + e.getMessage());
                    SCHEDULER.schedule(() -> this.ownChangeQueue.remove(f), 2L, TimeUnit.SECONDS);
                    SCHEDULER.schedule(() -> this.ownChangeQueue.remove(newFile), 2L, TimeUnit.SECONDS);
                    break block8;
                }
            }
            catch (Throwable throwable) {
                SCHEDULER.schedule(() -> this.ownChangeQueue.remove(f), 2L, TimeUnit.SECONDS);
                SCHEDULER.schedule(() -> this.ownChangeQueue.remove(newFile), 2L, TimeUnit.SECONDS);
                throw throwable;
            }
            SCHEDULER.schedule(() -> this.ownChangeQueue.remove(f), 2L, TimeUnit.SECONDS);
            SCHEDULER.schedule(() -> this.ownChangeQueue.remove(newFile), 2L, TimeUnit.SECONDS);
        }
    }

    @Inject
    public void setActions(TabCommands.NewTabAction newTab, TabCommands.OpenTabAction openTab, TabCommands.SaveFileAction saveFile, TabCommands.RestoreTabAction restoreTab, TabCommands.CloseCurrentTab closeTab) {
        TabActionUtils.addAction((JComponent)this.tab, newTab);
        TabActionUtils.addAction((JComponent)this.tab, openTab);
        TabActionUtils.addAction((JComponent)this.tab, saveFile);
        TabActionUtils.addAction((JComponent)this.tab, restoreTab);
        TabActionUtils.addAction((JComponent)this.tab, closeTab);
    }

    public void saveFile(String encoding) {
        this.saveFile(false, encoding);
    }

    public void saveFile() {
        this.saveFile(false);
    }

    public void saveFile(boolean saveAs) {
        this.saveFile(saveAs, null);
    }

    public void saveFile(boolean saveAs, String encoding) {
        block23: {
            TabContent tc = this.holder.current();
            if (tc != null) {
                File fsss;
                File file = fsss = saveAs ? this.saver.saveAs(tc) : this.saver.save(tc);
                if (fsss == null) {
                    return;
                }
                this.ownChangeQueue.add(fsss);
                try {
                    try {
                        Throwable throwable = null;
                        Object var6_8 = null;
                        try (FileOutputStream fw = new FileOutputStream(fsss);){
                            String charsetName = encoding != null ? encoding : (tc.getEncoding() != null ? tc.getEncoding() : Charset.defaultCharset().name());
                            Encoding e = Encoding.get(charsetName);
                            if (e != null && e.getBom() != Encoding.BOM.NONE) {
                                if (e.getBom() == Encoding.BOM.LE) {
                                    ((OutputStream)fw).write(new byte[]{-1, -2});
                                    if (e == Encoding.UTF32) {
                                        ((OutputStream)fw).write(new byte[2]);
                                    }
                                } else if (e.getBom() == Encoding.BOM.BE) {
                                    ((OutputStream)fw).write(new byte[]{-2, -1});
                                }
                            }
                            ((OutputStream)fw).write(this.rmap.get(tc.getId()).getData().getBytes(charsetName));
                            if (!tc.isAFile() || saveAs) {
                                TabContent newElement = new TabContent(fsss.getName(), fsss.getAbsolutePath(), tc.getContent(), charsetName);
                                newElement.assignId(tc.getId());
                                this.holder.replaceCurrent(newElement);
                                this.recentMenuHandler.openFile(fsss);
                                ConfigHandler.getConfig().setLastDirectory(fsss.getParent());
                            } else {
                                this.tabContentDocumentListeners.get(tc.getId()).saved();
                            }
                        }
                        catch (Throwable throwable2) {
                            if (throwable == null) {
                                throwable = throwable2;
                            } else if (throwable != throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                            throw throwable;
                        }
                    }
                    catch (IOException e) {
                        this.feedback.showMessage((JComponent)this.tab, "Couldn't save file due to:" + e.getMessage());
                        SCHEDULER.schedule(() -> this.ownChangeQueue.remove(fsss), 2L, TimeUnit.SECONDS);
                        break block23;
                    }
                }
                catch (Throwable throwable) {
                    SCHEDULER.schedule(() -> this.ownChangeQueue.remove(fsss), 2L, TimeUnit.SECONDS);
                    throw throwable;
                }
                SCHEDULER.schedule(() -> this.ownChangeQueue.remove(fsss), 2L, TimeUnit.SECONDS);
            }
        }
    }

    public List<Tuple<File, String>> openFile() {
        File dir = new File(ConfigHandler.getConfig().getLastDirectory());
        return this.openFile(dir);
    }

    public List<Tuple<File, String>> openFile(File preferredDir) {
        FileNameExtensionFilter fs = new FileNameExtensionFilter("SQL-files (*.sql)", "sql");
        List<File> files = FileUtils.openFiles((Component)this.tab, preferredDir, fs);
        if (files == null) {
            return Collections.EMPTY_LIST;
        }
        return this.openFiles(files);
    }

    public List<Tuple<File, String>> openFiles(List<File> files) {
        return this.openFiles(files, false);
    }

    public List<Tuple<File, String>> openFiles(List<File> files, boolean alwaysReplace) {
        boolean activated = false;
        ArrayList<Tuple<File, String>> errorMessages = new ArrayList<Tuple<File, String>>();
        for (File file : files) {
            String absolutePath = file.getAbsolutePath();
            TabContent tab = this.findContentByFile(absolutePath);
            if (tab != null && !alwaysReplace) {
                if (!activated) {
                    this.holder.current(tab);
                    activated = true;
                }
                this.recentMenuHandler.openFile(file);
                continue;
            }
            try {
                Tuple<Integer, Tuple<char[], String>> content = FileUtils.fileContents(file);
                String contentValue = new String((char[])((Tuple)content.second()).first(), 0, (int)((Integer)content.first()));
                if (tab != null) {
                    block18: {
                        RSyntaxTextArea rx = (RSyntaxTextArea)this.rmap.get(tab.getId()).getEditorComponent();
                        rx.getDocument().removeDocumentListener((DocumentListener)((Object)this.tabContentDocumentListeners.get(tab.getId())));
                        int dot = rx.getCaretLineNumber();
                        int dot2 = rx.getCaretOffsetFromLineStart();
                        Tuple position = new Tuple((Object)dot, (Object)dot2);
                        if (dot != 0 && dot < rx.getLineCount() && ((char[])((Tuple)content.second()).first()).length < 100000) {
                            try {
                                DefaultLineDetectionChangeTracker tracker = new DefaultLineDetectionChangeTracker();
                                position = this.firstNonNull(tracker.getPositionAfterChange(rx.getText().toCharArray(), (char[])((Tuple)content.second()).first(), (Tuple<Integer, Integer>)new Tuple((Object)dot, (Object)dot2)), position);
                            }
                            catch (Exception e) {
                                LOGGER.error("Error while detecting changes", (Throwable)e);
                            }
                        }
                        rx.beginAtomicEdit();
                        rx.setText(contentValue);
                        TabContentDocumentListener listener = new TabContentDocumentListener(this.holder, (JTabbedPane)this.tab, tab, rx, contentValue);
                        this.tabContentDocumentListeners.put(tab.getId(), listener);
                        rx.getDocument().addDocumentListener((DocumentListener)((Object)listener));
                        try {
                            try {
                                Element element = rx.getDocument().getDefaultRootElement().getElement((Integer)position.first());
                                if (element != null) {
                                    rx.setCaretPosition(element.getStartOffset() + (Integer)position.second());
                                } else if ((Integer)position.first() > 0 && rx.getDocument().getLength() > 0) {
                                    rx.setCaretPosition(rx.getDocument().getLength() - 1);
                                }
                            }
                            catch (Exception e) {
                                LOGGER.error("Setting caret position failed, position was: {}, exception was: {}", (Object)position, (Object)e);
                                rx.setCaretPosition(0);
                                rx.endAtomicEdit();
                                break block18;
                            }
                        }
                        catch (Throwable throwable) {
                            rx.endAtomicEdit();
                            throw throwable;
                        }
                        rx.endAtomicEdit();
                    }
                    this.holder.current(tab);
                } else {
                    TabContent tc = new TabContent(file.getName(), absolutePath, contentValue, (String)((Tuple)content.second()).second());
                    this.addToHolder(tc);
                }
                this.recentMenuHandler.openFile(file);
            }
            catch (IOException | RuntimeException e) {
                errorMessages.add((Tuple<File, String>)Tuple.of((Object)file, (Object)e.getMessage()));
            }
        }
        return errorMessages;
    }

    public void setCurrent(int index) {
        this.holder.current(index);
    }

    private <E> E firstNonNull(E ... objects) {
        E[] EArray = objects;
        int n = objects.length;
        int n2 = 0;
        while (n2 < n) {
            E o = EArray[n2];
            if (o != null) {
                return o;
            }
            ++n2;
        }
        return null;
    }

    private TabContent findContentByFile(String path) {
        for (TabContent content : this.holder.view()) {
            try {
                if (!content.isAFile() || !path.equals(content.getFileName()) && !Files.isSameFile(Paths.get(path, new String[0]), Paths.get(content.getFileName(), new String[0]))) continue;
                return content;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public int create(List<TabContent> contents, int currentIndex) {
        void var6_10;
        Object content;
        void var6_7;
        this.suspend = true;
        int index = 0;
        ArrayList<TabContent> tabs = new ArrayList<TabContent>(contents);
        ArrayList<Future<TabContent>> futures = new ArrayList<Future<TabContent>>();
        boolean bl = false;
        while (var6_7 < contents.size()) {
            content = contents.get((int)var6_7);
            if (((TabContent)content).isAFile()) {
                void s = var6_7;
                futures.add(EXECUTOR.submit(() -> this.lambda$5(tabs, (int)s, (TabContent)content)));
            }
            ++var6_7;
        }
        for (Future future : futures) {
            try {
                future.get();
            }
            catch (InterruptedException | ExecutionException exception) {
                // empty catch block
            }
        }
        boolean bl2 = false;
        while (var6_10 < tabs.size()) {
            tabs.size();
            content = (TabContent)tabs.get((int)var6_10);
            if (content == null) {
                if (var6_10 < currentIndex) {
                    --index;
                }
            } else {
                this.addToHolder((TabContent)content, true);
            }
            ++var6_10;
        }
        this.suspend = false;
        return currentIndex + index;
    }

    private TabContent createContentFromFileContent(TabContent content) {
        try {
            File file = new File(content.getFileName());
            if (file.exists()) {
                Tuple<String, String> fileAndEncoding = FileUtils.fileContent(file);
                TabContent tc = new TabContent(content.getTitle(), content.getFileName(), (String)fileAndEncoding.first(), (String)fileAndEncoding.second());
                content.copyStateTo(tc);
                return tc;
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Error occured while getting file content, file: {}, error: {}", (Object)content.getFileName(), (Object)e);
            return null;
        }
    }

    public TabContent add() {
        return this.add(null, "");
    }

    public TabContent add(String title, String content) {
        return this.add(title, content, null, null);
    }

    public TabContent add(String title, String content, String contentType) {
        return this.add(title, content, null, contentType);
    }

    public TabContent add(String title, String content, Map<String, Object> contextValue) {
        return this.add(title, content, contextValue, null);
    }

    private TabContent add(String title, String content, Map<String, Object> contextValue, String contentType) {
        TabContent tc = new TabContent(title != null ? title : "New file(" + this.counter + ")", content, contentType);
        if (contextValue != null) {
            contextValue.entrySet().stream().forEach(e -> tc.setStateValue((String)e.getKey(), e.getValue()));
        }
        return this.addToHolder(tc);
    }

    public void close() {
        this.holder.remove();
    }

    public List<TabContent> dumpContents() {
        ArrayList<TabContent> contents = new ArrayList<TabContent>();
        for (TabContent tc : this.holder.view()) {
            TabContent newContent = new TabContent(tc.getTitle(), tc.getFileName(), tc.isAFile() ? "" : this.rmap.get(tc.getId()).getData(), tc.getEncoding(), tc.getContentType());
            newContent.assignId(tc.getId());
            contents.add(newContent);
        }
        return contents;
    }

    public TabContent currentTab() {
        return this.holder.current();
    }

    public RSyntaxTextArea currentTextArea() {
        return (RSyntaxTextArea)this.rmap.get(this.holder.current().getId()).getEditorComponent();
    }

    public RSyntaxTextArea getAreaForContent(TabContent tc) {
        return (RSyntaxTextArea)this.rmap.get(tc.getId()).getEditorComponent();
    }

    public JPanel getContent() {
        return this.panelmap.get(this.holder.current().getId());
    }

    public JPanel getContent(TabContent tc) {
        return this.panelmap.get(tc.getId());
    }

    public void addContentEditorListener(TabContentEditorListener listener) {
        this.tabContentListeners.add(listener);
    }

    public void removeContentEditorListener(TabContentEditorListener listener) {
        this.tabContentListeners.remove(listener);
    }

    private boolean addFile(TabContent content, File file) {
        if (file.exists()) {
            try {
                Tuple<String, String> fileAndEncoding = FileUtils.fileContent(file);
                TabContent tc = new TabContent(content.getTitle(), content.getFileName(), (String)fileAndEncoding.first(), (String)fileAndEncoding.second());
                this.addToHolder(tc);
                return true;
            }
            catch (Exception e) {
                LOGGER.error("Error occured while getting file content, file: {}, error: {}", (Object)file, (Object)e);
            }
        } else {
            this.feedback.showMessage((JComponent)this.tab, "File " + file.getAbsolutePath() + " no longer exists, and will be closed");
        }
        return false;
    }

    private TabContent addToHolder(TabContent tc) {
        return this.addToHolder(tc, false);
    }

    private TabContent addToHolder(TabContent tc, boolean dontSetCurrent) {
        tc.assignId(this.counter.incrementAndGet());
        return this.holder.add(tc);
    }

    public void fileChanged(File f) {
        if (this.changeQueue.contains(f) || this.ownChangeQueue.contains(f)) {
            return;
        }
        this.changeQueue.add(f);
        TabContent tc = this.findFile(f);
        if (tc != null && JOptionPane.showConfirmDialog((Component)this.tab, String.format("File %s seems to have been changed recently, do you want to reload it?", tc.getFileName()), "Are you sure?", 0) == 0) {
            SwingUtilities.invokeLater(() -> {
                List<Tuple<File, String>> list = this.openFiles(Arrays.asList(f), true);
            });
        }
        SCHEDULER.schedule(() -> this.changeQueue.remove(f), 2L, TimeUnit.SECONDS);
    }

    public void fileDeleted(File f) {
        if (this.ownChangeQueue.contains(f)) {
            return;
        }
        TabContent tc = this.findFile(f);
        if (tc != null && !f.exists() && JOptionPane.showConfirmDialog((Component)this.tab, String.format("File %s seems to have been deleted recently, do you want to remove it?", tc.getFileName()), "Are you sure?", 0) == 0) {
            this.holder.remove(tc);
        }
    }

    public TabContent getContentFromArea(RSyntaxTextArea sta) {
        for (Integer i : this.rmap.keySet()) {
            if (!this.rmap.get(i).equals(sta)) continue;
            return this.tabmap.get(i);
        }
        return null;
    }

    private TabContent findFile(File f) {
        for (Integer key : this.tabmap.keySet()) {
            TabContent x = this.tabmap.get(key);
            if (x == null || !x.isAFile() || !new File(x.getFileName()).equals(f)) continue;
            return x;
        }
        return null;
    }

    public void setRunning(TabContent tabContent, boolean running) {
        ButtonTabComponent tabComponent = (ButtonTabComponent)this.tab.getTabComponentAt(this.holder.getIndex(tabContent));
        if (running) {
            tabComponent.setIcon(this.loader);
        } else {
            if (!this.holder.current().equals(tabContent) && tabContent.getStateValue("Finished") != null) {
                tabComponent.setLabelFont(tabComponent.getFont().deriveFont(1));
                tabContent.setStateValue("Finished", null);
            }
            tabComponent.setIcon(null);
        }
    }

    public Consumer<File> get() {
        return f -> FileUtils.displayFileMessages(this.openFiles(Arrays.asList(f)));
    }

    public boolean isDirty(TabContent tc) {
        TabContentDocumentListener l = this.tabContentDocumentListeners.get(tc.getId());
        return l != null && l.isDirty();
    }

    public List<TabContent> getDirtyTabContents() {
        ArrayList<TabContent> contents = new ArrayList<TabContent>();
        for (TabContent tc : this.tabmap.values()) {
            TabContentDocumentListener l = this.tabContentDocumentListeners.get(tc.getId());
            if (!l.isDirty()) continue;
            contents.add(tc);
        }
        return contents;
    }

    public int currentTabIndex() {
        return this.holder.currentIndex();
    }

    private /* synthetic */ TabContent lambda$5(List list, int n, TabContent tabContent) throws Exception {
        return list.set(n, this.createContentFromFileContent(tabContent));
    }
}

