/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.tabs;

import com.alluretechnology.noheapdb.DataStore;
import com.alluretechnology.noheapdb.NoHeapDB;
import com.sigge.filerunner.core.MiscUtils;
import com.sigge.filerunner.core.ResurrectionDecorator;
import com.sigge.filerunner.view.tabs.TabContent;
import java.nio.charset.StandardCharsets;

public class TabContentOffloader
implements ResurrectionDecorator<TabContent> {
    private static final String TABCONTENTS = "TabContents";
    private static final NoHeapDB h = new NoHeapDB("db");
    private boolean storeInited = false;

    public TabContentOffloader() {
        try {
            h.createStore(TABCONTENTS, DataStore.Storage.IN_MEMORY, 20);
            this.storeInited = false;
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    public TabContent decorateFromRestore(TabContent el) {
        if (this.storeInited) {
            MiscUtils.printNow("Restoring " + el);
            byte[] smile2 = h.getStore(TABCONTENTS).getBytes(this.getIdFromContent(el));
            try {
                if (smile2 != null) {
                    String b = new String(smile2, StandardCharsets.UTF_8);
                    el.setContent(b);
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            this.clear(el);
        }
        return el;
    }

    @Override
    public TabContent decorateToRestore(TabContent el) {
        if (this.storeInited && el.getContent().length() > 0) {
            MiscUtils.printNow("To restore " + el);
            try {
                byte[] smileData = el.getContent().getBytes(StandardCharsets.UTF_8);
                h.getStore(TABCONTENTS).putBytes(this.getIdFromContent(el), smileData);
                el.setContent("");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return el;
    }

    @Override
    public void clear(TabContent el) {
        if (this.storeInited) {
            MiscUtils.printNow("Removin' " + el);
            try {
                MiscUtils.printNow("" + h.getStore(TABCONTENTS).remove(this.getIdFromContent(el)));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private String getIdFromContent(TabContent el) {
        return "TabContent" + el.getId();
    }
}

