/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.search;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.FileRunnerAction;
import com.sigge.filerunner.view.EditorManager;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.siggemannen.core.Tuple;
import java.awt.event.ActionEvent;
import javax.swing.JFrame;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import org.fife.rsta.ui.search.FindDialog;
import org.fife.rsta.ui.search.ReplaceDialog;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;

@Singleton
public class ShowFindDialogAction
implements FileRunnerAction {
    private final JFrame mainFrame;
    private final IStatusUpdater updater;
    private final FindDialog findDialog;
    private final ReplaceDialog replaceDialog;
    private final EditorManager manager;

    @Inject
    public ShowFindDialogAction(@Named(value="mainFrame") JFrame mainFrame, IStatusUpdater updater, Tuple<FindDialog, ReplaceDialog> dialogs, EditorManager manager) {
        this.mainFrame = mainFrame;
        this.updater = updater;
        this.manager = manager;
        this.findDialog = (FindDialog)dialogs.first();
        this.replaceDialog = (ReplaceDialog)dialogs.second();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.updater.removeMessage("searches");
        if (this.replaceDialog.isVisible()) {
            this.replaceDialog.setVisible(false);
        }
        SwingUtilities.invokeLater(() -> {
            RSyntaxTextArea tab = this.manager.getCurrentTab();
            if (tab != null && tab instanceof RSQLSyntaxTextArea) {
                ((RSQLSyntaxTextArea)tab).closeToolTip();
            }
            this.findDialog.setVisible(true);
        });
    }

    @Override
    public String id() {
        return "find";
    }

    @Override
    public KeyStroke getDefaultKeyStroke() {
        return KeyStroke.getKeyStroke(70, this.mainFrame.getToolkit().getMenuShortcutKeyMask());
    }
}

