/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv.transformers;

import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.ICSVTransformer;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.Optional;

public class InTransformer
implements ICSVTransformer {
    @Override
    public String transform(String csv, Optional<IResultSetTable> table, TransformContext context) {
        LinkedHashSet<String> s;
        boolean hasString = false;
        if (!table.isPresent()) {
            s = new LinkedHashSet<String>(Arrays.asList(csv.split("[\n\r]")));
        } else {
            IResultSetTable model = table.get();
            s = new LinkedHashSet();
            int i = 0;
            while (i < model.getRowCount()) {
                s.add(this.stringify(model.getValueForDisplay(i, 0)));
                ++i;
            }
        }
        for (String str : s) {
            if (!this.isString(str)) continue;
            hasString = true;
            break;
        }
        StringBuilder sb = new StringBuilder("(");
        boolean newLines = false;
        if (s.size() > 20 || csv != null && csv.length() > 100) {
            newLines = true;
        }
        if (newLines) {
            sb.append("\n\t");
        }
        int cnt = 0;
        for (String str : s) {
            if (str.length() == 0) continue;
            if (cnt > 0) {
                sb.append(",");
                sb.append(newLines ? "\t" : " ");
            }
            ++cnt;
            if (hasString) {
                sb.append("'");
            }
            sb.append(str.replace("'", "''"));
            if (hasString) {
                sb.append("'");
            }
            if (!newLines) continue;
            sb.append("\n");
        }
        sb.append(")");
        return sb.toString();
    }

    private String stringify(Object x) {
        if (x == null) {
            return "NULL";
        }
        return x.toString();
    }

    @Override
    public int supports(String csv, Optional<IResultSetTable> table, int lines, int cols) {
        boolean columnLookingString;
        if (table.isPresent()) {
            return table.get().getColumnCount() == 1 ? 1 : 0;
        }
        if (csv == null || csv.length() == 0) {
            return 0;
        }
        boolean bl = columnLookingString = lines > 0 && cols == 0;
        if (columnLookingString && lines == 1 && !csv.substring(csv.length() - 1).matches(".+\n\\S")) {
            columnLookingString = false;
        }
        return columnLookingString ? 1 : 0;
    }

    @Override
    public String getLabel() {
        return "In";
    }
}

