/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.csv;

import com.sigge.filerunner.sql.DatabaseContext;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.rsyntaxtextarea.csv.TransformContext;
import com.siggemannen.core.ListUtils;
import java.util.Optional;
import java.util.regex.Pattern;

public interface ICSVTransformer
extends ILabel {
    public static final Pattern ZERO_STRING = Pattern.compile("[-+]?0\\d+");
    public static final Pattern NUMBER_MATCH = Pattern.compile("^-?\\d*\\.?\\d*$");

    public String transform(String var1, Optional<IResultSetTable> var2, TransformContext var3);

    public int supports(String var1, Optional<IResultSetTable> var2, int var3, int var4);

    default public String getSafeColumnName(String name, Optional<DatabaseContext> currentContext) {
        if (currentContext.isPresent()) {
            return currentContext.get().getQuotedIdentifier(name);
        }
        return name;
    }

    default public boolean isString(IResultSetTable model, int column) {
        return ListUtils.in((Object)((Object)model.getFieldType(column)), (Object[])new FieldType[]{FieldType.SQLDATE, FieldType.SQLDATEWITHZONE, FieldType.SQLSTRING, FieldType.SQLXMLSTRING});
    }

    default public boolean isString(String value) {
        return ZERO_STRING.matcher(value).matches() || "-".equals(value) || !NUMBER_MATCH.matcher(value).matches() && !value.equalsIgnoreCase("NULL");
    }
}

