/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea.completion;

import com.google.inject.Inject;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.ClipboardUtils;
import com.sigge.filerunner.sql.ISQLManager;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.view.EditorManager;
import com.sigge.filerunner.view.editors.TableEditor;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupAction;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupHandler;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.PopupAction;
import com.sigge.filerunner.view.runners.IRunningState;
import com.sigge.filerunner.view.runners.SQLScriptState;
import com.sigge.filerunner.view.tabs.TabContent;
import com.sigge.filerunner.view.tools.SQLTool;
import com.siggemannen.core.MapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.swing.JOptionPane;

public class DefaultPopupHandler
implements IPopupHandler {
    private final SQLManager manager;
    private final EditorManager editorManager;
    private final ISQLManager runner;
    private final IRunningState scriptReporter;
    private final TableEditor editor;

    @Inject
    DefaultPopupHandler(SQLManager manager, EditorManager editorManager, ISQLManager runner, IRunningState scriptReporter, TableEditor editor) {
        this.manager = manager;
        this.editorManager = editorManager;
        this.runner = runner;
        this.scriptReporter = scriptReporter;
        this.editor = editor;
    }

    @Override
    public List<IPopupAction> getActionsForIdentifier(String token, TokenFinder finder, List<SQLObject> declareTables) {
        List<SQLObject> objects = this.manager.getByName(token, SQLObjectType.TABLE, SQLObjectType.INLINE_TABLE_FUNCTION, SQLObjectType.SCALAR_FUNCTION, SQLObjectType.STORED_PROCEDURE, SQLObjectType.TABLE_FUNCTION, SQLObjectType.VIEW);
        for (SQLObject declares : declareTables) {
            if (declares.getFullName() != null && declares.getFullName().equalsIgnoreCase(token)) {
                objects.add(declares);
                continue;
            }
            if (declares.getName() == null || this.manager.needsSchema(declares) || !declares.getName().equalsIgnoreCase(token)) continue;
            objects.add(declares);
        }
        if (objects.size() == 0) {
            return new ArrayList<IPopupAction>();
        }
        ArrayList<IPopupAction> actions = new ArrayList<IPopupAction>();
        this.populateActions(objects, actions);
        return actions;
    }

    private void populateActions(List<SQLObject> objects, List<IPopupAction> actions) {
        List<SQLTool> tools = ConfigHandler.getConfig().getSqlTools();
        int i = 0;
        while (i < objects.size()) {
            SQLObject ob = objects.get(i);
            switch (ob.getSQLType()) {
                case TABLE: {
                    actions.add(this.selectData(ob, i == 0));
                    actions.add(this.countData(ob, false));
                    actions.add(this.openDefinitionAction(ob, false));
                    actions.add(this.copyColumns(ob, false));
                    actions.add(this.copyColumnsWithAlias(ob, false));
                    actions.add(this.copyColumnsWithSet(ob, false));
                    actions.add(this.editTable(ob, false));
                    break;
                }
                case VIEW: {
                    actions.add(this.selectData(ob, i == 0));
                    actions.add(this.countData(ob, false));
                    actions.add(this.openDefinitionAction(ob, false));
                    actions.add(this.copyColumns(ob, false));
                    actions.add(this.copyColumnsWithAlias(ob, false));
                    break;
                }
                case INLINE_TABLE_FUNCTION: 
                case TABLE_FUNCTION: 
                case SCALAR_FUNCTION: 
                case STORED_PROCEDURE: {
                    actions.add(this.openDefinitionAction(ob, i == 0));
                    break;
                }
            }
            actions.addAll(tools.stream().filter(f -> f.getTypes().contains((Object)ob.getSQLType())).map(ff -> this.toolCommand((SQLTool)ff, ob)).collect(Collectors.toList()));
            ++i;
        }
    }

    private IPopupAction editTable(SQLObject ob, boolean def) {
        return new PopupAction("Edit table", () -> this.editor.editTable(ob, Optional.empty()), def);
    }

    private IPopupAction toolCommand(SQLTool tool, SQLObject ob) {
        return new PopupAction(tool.getTitle(), () -> this.runner.runSQL(tool.getCommand().replace("${selected}", ob.getContext().getQuotedName(ob)).replace("${alltext}", ob.getContext().getQuotedName(ob))));
    }

    private IPopupAction copyColumns(SQLObject ob, boolean defaultAction) {
        return new PopupAction("Copy columns", () -> ClipboardUtils.setStringDataToClipboard("\t" + ob.getColumns().stream().map(l -> "\t" + this.manager.getCurrentContext().getQuotedIdentifier(l.getName())).collect(Collectors.joining("\n\t,"))), defaultAction);
    }

    private IPopupAction copyColumnsWithAlias(SQLObject ob, boolean defaultAction) {
        return new PopupAction("Copy columns with alias", () -> ClipboardUtils.setStringDataToClipboard("\t" + ob.getColumns().stream().map(l -> "\t" + this.manager.getCurrentContext().getQuotedIdentifier(ob.getName().substring(0, Math.min(ob.getName().length(), 2))) + "." + this.manager.getCurrentContext().getQuotedIdentifier(l.getName())).collect(Collectors.joining("\n\t,"))), defaultAction);
    }

    private IPopupAction copyColumnsWithSet(SQLObject ob, boolean defaultAction) {
        return new PopupAction("Copy set column values", () -> ClipboardUtils.setStringDataToClipboard("\t" + ob.getColumns().stream().map(l -> "\t" + this.manager.getCurrentContext().getQuotedIdentifier(l.getName()) + " = " + this.manager.getCurrentContext().getQuotedIdentifier(ob.getName().substring(0, Math.min(ob.getName().length(), 2))) + "." + this.manager.getCurrentContext().getQuotedIdentifier(l.getName())).collect(Collectors.joining("\n\t,"))), defaultAction);
    }

    private IPopupAction countData(SQLObject ob, boolean defaultAction) {
        return new PopupAction("Count rows", () -> this.runner.runSQL(this.manager.getCountRowsSQL(ob)), defaultAction);
    }

    private IPopupAction selectData(SQLObject ob, boolean defaultAction) {
        return new PopupAction("View data", () -> this.runner.runSQL(this.manager.getSelectRowsSQL(ob, 500)), defaultAction);
    }

    private IPopupAction openDefinitionAction(SQLObject ob, boolean defaultAction) {
        Optional<SQLScriptState> state = this.scriptReporter.getCurrentState();
        Consumer<String> definitionConsumer = !this.editorManager.currentTab().isAFile() && this.editorManager.getCurrentText().length() <= ob.getFullName().length() + 3 && state.map(SQLScriptState::getLastRunResultsSets).orElse(0) == 0 && state.map(SQLScriptState::isRunning).orElse(false) == false ? s -> {
            this.editorManager.getCurrentTab().setText(s);
            this.editorManager.replaceCurrent(ob.getName(), (String)s);
            this.manager.setCurrent(ob.getContext().getDatabase());
        } : d -> {
            TabContent tabContent = this.editorManager.newFile(ob.getName(), (String)d, new MapBuilder((Object)"db", (Object)ob.getContext().getDatabase()).build());
        };
        return new PopupAction("Open definition", () -> this.manager.getObjectDefinition(ob, definitionConsumer, e -> JOptionPane.showMessageDialog(null, "Cannot open object definition of: " + ob.getFullName() + ". Error was: " + e.getMessage(), "Opening definition failed", 1)), defaultAction);
    }
}

