/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.completion.ITokenProvider;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import com.sigge.parsql.sql.transform.ISQLToken;
import com.sigge.parsql.sql.transform.TokenType;
import com.siggemannen.core.Tuple;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.List;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.Element;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RecordableTextAction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SingleLineCommentToggleAction
extends RecordableTextAction {
    private final String patternFrom = "(?m)^(.*)$";
    private final String patternTo = "--$1";
    Pattern addComment = Pattern.compile("(?m)^(.*)$");
    private final String patternFromRemove = "(?m)^(\\s*)--(.*)$";
    private final String patternToRemove = "$1$2";
    Pattern removeComment = Pattern.compile("(?m)^(\\s*)--(.*)$");
    private final ITokenProvider tokenizer;
    private static final Logger LOGGER = LoggerFactory.getLogger(SingleLineCommentToggleAction.class);

    public SingleLineCommentToggleAction(String text, Icon icon, String desc, Integer mnemonic, KeyStroke accelerator, ITokenProvider tokenizer) {
        super(text, icon, desc, mnemonic, accelerator);
        this.tokenizer = tokenizer;
    }

    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        if (!textArea.isEditable() || !textArea.isEnabled()) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
            return;
        }
        Tuple<Integer, Integer> dotMark = TextPaneUtil.dotMark(textArea);
        Document doc = textArea.getDocument();
        Element map = doc.getDefaultRootElement();
        int minLineNum = map.getElementIndex((Integer)dotMark.first());
        int maxLineNum = map.getElementIndex((Integer)dotMark.second());
        boolean addComment = false;
        int i = minLineNum;
        while (i <= maxLineNum) {
            ISQLToken t = this.firstRealToken(this.tokenizer.getTokensOnLine(i));
            if (t == null && i != maxLineNum && maxLineNum > minLineNum + 1 || t != null && !t.in(new TokenType[]{TokenType.COMMENT})) {
                addComment = true;
                break;
            }
            ++i;
        }
        textArea.beginAtomicEdit();
        int start = map.getElement(minLineNum).getStartOffset();
        int end = map.getElement(maxLineNum).getEndOffset();
        if (end > doc.getLength()) {
            --end;
        }
        try {
            String docText = doc.getText(start, end - start);
            if (addComment) {
                textArea.replaceRange(this.addComment.matcher(docText).replaceAll("--$1"), start, end);
            } else {
                textArea.replaceRange(this.removeComment.matcher(docText).replaceAll("$1$2"), start, end);
            }
        }
        catch (BadLocationException e1) {
            LOGGER.error("Error while toggling comments", (Throwable)e1);
        }
        textArea.endAtomicEdit();
    }

    private ISQLToken firstRealToken(List<ISQLToken> tokens) {
        ISQLToken t = null;
        for (ISQLToken token : tokens) {
            if (token.in(new TokenType[]{TokenType.NEWLINE, TokenType.WHITESPACE, TokenType.TAB})) continue;
            t = token;
            break;
        }
        return t;
    }

    public String getMacroID() {
        return "singleLineToggleAction";
    }
}

