/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.JTextComponent;
import javax.swing.text.NavigationFilter;
import javax.swing.text.Position;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NextVisualPositionActionWithNewLines
extends RTextAreaEditorKit.NextVisualPositionAction {
    private final boolean select;
    private final int direction;
    private static final Logger LOGGER = LoggerFactory.getLogger(NextVisualPositionActionWithNewLines.class);

    public NextVisualPositionActionWithNewLines(String nm, boolean select, int dir) {
        super(nm, select, dir);
        this.select = select;
        this.direction = dir;
    }

    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        Caret caret = textArea.getCaret();
        int dot = caret.getDot();
        int mark = caret.getMark();
        if (this.direction == 3) {
            if (TextPaneUtil.isDotOnR(dot, textArea.getDocument())) {
                if (dot == mark) {
                    caret.setDot(++dot);
                } else {
                    caret.moveDot(++dot);
                }
            }
        } else if (this.direction == 7 && dot > 0 && TextPaneUtil.isDotOnR(dot - 1, textArea.getDocument())) {
            if (dot == mark) {
                caret.setDot(--dot);
            } else {
                caret.moveDot(--dot);
            }
            System.out.println(String.format("Dotted west: dot: %d, mark: %d", dot, caret.getMark()));
        }
        mark = caret.getMark();
        if (!this.select) {
            switch (this.direction) {
                case 3: {
                    if (dot == mark) break;
                    caret.setDot(Math.max(dot, mark));
                    return;
                }
                case 7: {
                    mark = caret.getMark();
                    if (dot == mark) break;
                    caret.setDot(Math.min(dot, mark));
                    return;
                }
            }
        }
        Position.Bias[] bias = new Position.Bias[1];
        Point magicPosition = caret.getMagicCaretPosition();
        try {
            NavigationFilter filter;
            if (magicPosition == null && (this.direction == 1 || this.direction == 5)) {
                Rectangle r = textArea.modelToView(dot);
                magicPosition = new Point(r.x, r.y);
            }
            dot = (filter = textArea.getNavigationFilter()) != null ? filter.getNextVisualPositionFrom((JTextComponent)textArea, dot, Position.Bias.Forward, this.direction, bias) : textArea.getUI().getNextVisualPositionFrom((JTextComponent)textArea, dot, Position.Bias.Forward, this.direction, bias);
            if (this.select) {
                if (this.direction == 5 && dot == caret.getDot() && textArea.getCaretLineNumber() + 1 == textArea.getLineCount()) {
                    dot = textArea.getDocument().getLength();
                }
                caret.moveDot(dot);
            } else {
                caret.setDot(dot);
            }
            if (magicPosition != null && (this.direction == 1 || this.direction == 5)) {
                caret.setMagicCaretPosition(magicPosition);
            }
        }
        catch (BadLocationException ble) {
            LOGGER.error("Unexpected bad location", (Throwable)ble);
        }
    }
}

