/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.view.rsyntaxtextarea.RSQLSyntaxTextArea;
import com.sigge.filerunner.view.rsyntaxtextarea.TextPaneUtil;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.UIManager;
import javax.swing.text.BadLocationException;
import javax.swing.text.Caret;
import javax.swing.text.Document;
import org.fife.ui.rtextarea.RTextArea;
import org.fife.ui.rtextarea.RTextAreaEditorKit;

public class DeletePrevCharWithNewLines
extends RTextAreaEditorKit.DeletePrevCharAction {
    public void actionPerformedImpl(ActionEvent e, RTextArea textArea) {
        boolean beep = true;
        if (textArea != null && textArea.isEditable()) {
            try {
                int mark;
                Document doc = textArea.getDocument();
                Caret caret = textArea.getCaret();
                TextPaneUtil.fixDotAndMarks(textArea);
                if (textArea instanceof RSQLSyntaxTextArea && ((RSQLSyntaxTextArea)textArea).isColumnSelection()) {
                    TextPaneUtil.replaceColumnSelection((RSQLSyntaxTextArea)textArea, "", (Boolean)false);
                    return;
                }
                int dot = caret.getDot();
                if (dot != (mark = caret.getMark())) {
                    doc.remove(Math.min(dot, mark), Math.abs(dot - mark));
                    beep = false;
                } else if (dot > 0) {
                    int delChars = 1;
                    if (dot > 1) {
                        String dotChars = doc.getText(dot - 2, 2);
                        char c0 = dotChars.charAt(0);
                        char c1 = dotChars.charAt(1);
                        if (c0 >= '\ud800' && c0 <= '\udbff' && c1 >= '\udc00' && c1 <= '\udfff') {
                            delChars = 2;
                        } else if (c0 == '\r' && c1 == '\n') {
                            delChars = 2;
                        }
                    }
                    doc.remove(dot - delChars, delChars);
                    beep = false;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
        if (beep) {
            UIManager.getLookAndFeel().provideErrorFeedback((Component)textArea);
        }
    }
}

