/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.rsyntaxtextarea;

import com.sigge.filerunner.completion.CompletionUtils;
import com.sigge.filerunner.completion.DBCompletion;
import com.sigge.filerunner.completion.TokenFinder;
import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.sql.transform.SQLFile;
import com.sigge.filerunner.view.core.AggregatedMouseListener;
import com.sigge.filerunner.view.rsyntaxtextarea.GenericPopup;
import com.sigge.filerunner.view.rsyntaxtextarea.completion.IPopupAction;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.core.ThreadUtils;
import java.awt.Component;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.InputEvent;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.HyperlinkEvent;
import javax.swing.text.Document;
import org.antlr.v4.runtime.ParserRuleContext;
import org.fife.ui.rsyntaxtextarea.LinkGenerator;
import org.fife.ui.rsyntaxtextarea.LinkGeneratorResult;
import org.fife.ui.rsyntaxtextarea.RSyntaxDocument;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.RSyntaxUtilities;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rtextarea.RTextArea;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultLinkGenerator
extends KeyAdapter
implements LinkGenerator,
MouseMotionListener {
    private GenericPopup lastPopup;
    private Token triggeredToken = null;
    private RSyntaxTextArea rsta = null;
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultLinkGenerator.class);
    private final DBCompletion completions;
    private boolean isInTip;
    private AggregatedMouseListener lastListener;

    public DefaultLinkGenerator(DBCompletion completions) {
        this.completions = completions;
    }

    public LinkGeneratorResult isLinkAtOffset(RSyntaxTextArea textArea, int offs) {
        List<IPopupAction> actions;
        int line;
        String lexeme = null;
        Document document = textArea.getDocument();
        Token t = ((RSyntaxDocument)document).getTokenListForLine(line = document.getDefaultRootElement().getElementIndex(offs));
        if (t == null) {
            this.killPopup();
            return null;
        }
        Token curToken = RSyntaxUtilities.getTokenAtOffset((Token)t, (int)offs);
        if (curToken == null) {
            this.killPopup();
            return null;
        }
        if (this.triggeredToken != null && curToken != this.triggeredToken) {
            this.killPopup();
        }
        lexeme = curToken.getLexeme();
        SQLFile ctx = this.completions.getParseTree();
        TokenFinder f = null;
        if (ctx != null && (f = CompletionUtils.getTokenAtPosition(ctx.getContext(), offs)) != null && f.getNode() != null) {
            ParserRuleContext rx = f.getRule();
            String text = f.getNode().getText();
            if (CompletionUtils.isInExpression(rx, 651)) {
                text = rx.getParent().getText();
            }
            lexeme = text;
        }
        if ((actions = this.completions.getActionsForIdentifier(lexeme, f, new ArrayList<SQLObject>())).size() > 0) {
            ArrayList<IPopupAction> actions2 = new ArrayList<IPopupAction>();
            actions.forEach(l -> {
                boolean bl = actions2.add(new IPopupAction((IPopupAction)l){
                    private final /* synthetic */ IPopupAction val$l;
                    {
                        this.val$l = iPopupAction;
                    }

                    @Override
                    public String getName() {
                        return this.val$l.getName();
                    }

                    @Override
                    public Runnable getAction() {
                        return () -> {
                            try {
                                try {
                                    this.val$l.getAction().run();
                                }
                                catch (Exception ex) {
                                    ex.printStackTrace();
                                    DefaultLinkGenerator.this.killPopup();
                                }
                            }
                            finally {
                                DefaultLinkGenerator.this.killPopup();
                            }
                        };
                    }

                    @Override
                    public boolean isDefaultAction() {
                        return this.val$l.isDefaultAction();
                    }
                });
            });
            if (this.lastPopup == null || !this.lastPopup.isVisible()) {
                this.triggeredToken = curToken;
                this.rsta = textArea;
                this.lastPopup = this.createPopup(textArea, actions2);
            }
            IPopupAction action = actions2.stream().filter(IPopupAction::isDefaultAction).findFirst().orElse((IPopupAction)actions2.get(0));
            return new LinkResult(action.getAction(), curToken.getOffset());
        }
        return null;
    }

    private boolean killPopup() {
        this.triggeredToken = null;
        this.rsta = null;
        if (this.lastPopup != null) {
            if (this.lastListener != null) {
                AggregatedMouseListener v = this.lastListener;
                new BackgroundRunner(() -> {
                    ThreadUtils.sleep((int)500);
                    v.unwrapListener();
                }).execute();
                this.lastListener = null;
            }
            this.lastPopup.dispose();
            this.lastPopup = null;
            return true;
        }
        return false;
    }

    private GenericPopup createPopup(RSyntaxTextArea textArea, List<IPopupAction> actions) {
        Window owner = SwingUtilities.getWindowAncestor((Component)textArea);
        GenericPopup popup = new GenericPopup(owner, (RTextArea)textArea, "Actions:", () -> {});
        popup.addKeyboardReleaseListener(this);
        PopupMouseListenerWrapper wrapper = new PopupMouseListenerWrapper((JComponent)textArea);
        textArea.addMouseListener((MouseListener)wrapper);
        textArea.addMouseMotionListener((MouseMotionListener)wrapper);
        this.lastListener = new AggregatedMouseListener((Component)textArea);
        popup.setContents(actions);
        popup.setVisible(true);
        return popup;
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        if (this.lastPopup != null) {
            this.isInTip = this.hasLeftTheTipBuilding(e.getPoint());
            if (this.isInTip) {
                return;
            }
            if (this.commandKeyReleased(e)) {
                this.killPopup();
            } else if (this.rsta != null) {
                try {
                    Token t = this.rsta.viewToToken(new Point(e.getX(), e.getY()));
                    if (t == null || t != this.triggeredToken) {
                        this.killPopup();
                    }
                }
                catch (Exception ex) {
                    LOGGER.error("Error occured while processing token", (Throwable)ex);
                }
            }
        } else {
            this.isInTip = false;
        }
    }

    private boolean hasLeftTheTipBuilding(Point p) {
        return this.lastPopup.getTipVisibleBounds() != null && this.lastPopup.getTipVisibleBounds().contains(p);
    }

    private boolean commandKeyReleased(InputEvent ie) {
        return (ie.getModifiers() & Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()) == 0;
    }

    @Override
    public void keyReleased(KeyEvent e) {
        if (this.commandKeyReleased(e)) {
            if (this.isInTip) {
                return;
            }
            boolean r = this.killPopup();
            if (r) {
                e.consume();
            }
        }
    }

    class LinkResult
    implements LinkGeneratorResult {
        private final Runnable runnable;
        private final int offset;

        LinkResult(Runnable runnable, int offset) {
            this.runnable = runnable;
            this.offset = offset;
        }

        public HyperlinkEvent execute() {
            SwingUtilities.invokeLater(this.runnable);
            return null;
        }

        public int getSourceOffset() {
            return this.offset;
        }
    }

    private final class PopupMouseListenerWrapper
    extends MouseAdapter {
        private final JComponent comp;

        PopupMouseListenerWrapper(JComponent comp) {
            this.comp = comp;
        }

        @Override
        public void mouseClicked(MouseEvent e) {
        }

        @Override
        public void mouseDragged(MouseEvent e) {
            e.consume();
            this.comp.removeMouseMotionListener(this);
        }

        @Override
        public void mouseMoved(MouseEvent e) {
            this.comp.removeMouseMotionListener(this);
        }

        @Override
        public void mouseExited(MouseEvent e) {
            this.comp.removeMouseListener(this);
        }

        @Override
        public void mouseWheelMoved(MouseWheelEvent e) {
            this.comp.removeMouseListener(this);
        }

        @Override
        public void mouseReleased(MouseEvent e) {
            e.consume();
            this.comp.removeMouseListener(this);
        }
    }
}

