/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo.options;

import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.results.graph.geo.GeoWaypoint;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import com.siggemannen.core.ListUtils;
import com.siggemannen.core.MapBuilder;
import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import java.net.URL;
import java.util.Collection;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import javax.imageio.ImageIO;
import javax.swing.Icon;
import org.geotools.factory.CommonFactoryFinder;
import org.geotools.filter.LiteralExpressionImpl;
import org.geotools.geometry.jts.JTS;
import org.geotools.geometry.jts.ReferencedEnvelope;
import org.geotools.map.Layer;
import org.geotools.map.MapContent;
import org.geotools.map.MapViewport;
import org.geotools.referencing.CRS;
import org.geotools.renderer.lite.StreamingRenderer;
import org.geotools.styling.Fill;
import org.geotools.styling.Font;
import org.geotools.styling.Graphic;
import org.geotools.styling.LabelPlacement;
import org.geotools.styling.LineSymbolizer;
import org.geotools.styling.Mark;
import org.geotools.styling.PointSymbolizer;
import org.geotools.styling.PolygonSymbolizer;
import org.geotools.styling.SLD;
import org.geotools.styling.Stroke;
import org.geotools.styling.Style;
import org.geotools.styling.StyleFactory;
import org.geotools.styling.Symbolizer;
import org.geotools.styling.TextSymbolizer;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.jxmapviewer.viewer.WaypointRenderer;
import org.locationtech.jts.geom.Coordinate;
import org.opengis.filter.FilterFactory;
import org.opengis.filter.expression.Expression;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.style.AnchorPoint;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AWaypointRenderer<T>
implements WaypointRenderer<T> {
    protected static final CoordinateReferenceSystem CRS_STANDARD = AWaypointRenderer.createCRS("EPSG:4326");
    protected static final CoordinateReferenceSystem CRS_MAP = AWaypointRenderer.createCRS("EPSG:3857");
    protected static final StyleFactory sf = CommonFactoryFinder.getStyleFactory(null);
    protected static final FilterFactory ff = CommonFactoryFinder.getFilterFactory(null);
    protected static final Logger LOGGER = LoggerFactory.getLogger(AWaypointRenderer.class);
    private static final ScheduledExecutorService ES = Executors.newScheduledThreadPool(1);

    private static CoordinateReferenceSystem createCRS(String epsg) {
        java.util.logging.Logger r = java.util.logging.Logger.getLogger("");
        try {
            CoordinateReferenceSystem coordinateReferenceSystem = CRS.decode((String)epsg, (boolean)true);
            return coordinateReferenceSystem;
        }
        catch (Exception ex) {
            LOGGER.error("Error resolving crs: " + epsg, (Throwable)ex);
            return null;
        }
        finally {
            if (r.getLevel() != null && r.getLevel().equals(Level.ALL)) {
                r.setLevel(Level.INFO);
            }
        }
    }

    public void paintWaypoint(Graphics2D g, JXMapViewer viewer, T w) {
    }

    public void paintLayers(JXMapViewer viewer, Collection<Layer> layers, Graphics g) {
        StreamingRenderer draw = new StreamingRenderer();
        draw.setRendererHints(new MapBuilder((Object)"continuousMapWrapping", (Object)true).append((Object)"advancedProjectionHandling", (Object)true).build());
        MapContent mp = this.createContent(viewer);
        Graphics2D gg = (Graphics2D)g.create();
        for (Layer c : layers) {
            mp.addLayer(c);
        }
        draw.setMapContent(mp);
        ScheduledFuture<?> xx = ES.schedule(() -> draw.stopRendering(), 1L, TimeUnit.MINUTES);
        draw.paint(gg, mp.getViewport().getScreenArea(), mp.getViewport().getBounds(), mp.getViewport().getWorldToScreen());
        xx.cancel(true);
        mp.dispose();
    }

    public MapContent createContent(JXMapViewer viewer) {
        MapContent mp = new MapContent();
        Rectangle b = viewer.getViewportBounds();
        TileFactory tileFactory = viewer.getTileFactory();
        int zoom = viewer.getZoom();
        GeoPosition x1 = tileFactory.pixelToGeo((Point2D)new Point2D.Double(b.getMinX(), b.getMinY()), zoom);
        GeoPosition x2 = tileFactory.pixelToGeo((Point2D)new Point2D.Double(b.getMaxX(), b.getMaxY()), zoom);
        Coordinate cn1 = this.setupConverter(x1.getLongitude(), x1.getLatitude());
        Coordinate cn2 = this.setupConverter(x2.getLongitude(), x2.getLatitude());
        mp.setViewport(new MapViewport(new ReferencedEnvelope(cn1.x, cn2.x, cn1.y, cn2.y, CRS_MAP), true));
        mp.getViewport().setScreenArea(viewer.getViewportBounds());
        return mp;
    }

    public static BufferedImage readIcon(String image) {
        URL resource = GeoWaypoint.class.getResource(image);
        try {
            return ImageIO.read(resource);
        }
        catch (Exception ex) {
            LOGGER.error("Error while reading icon: " + image, (Throwable)ex);
            return null;
        }
    }

    public static Style createPointStyle(PointVisualizer icon, int zoom, String colorField, String labelField, String font, Integer size2, Color fontColor) {
        PointSymbolizer pointSym = null;
        if (ListUtils.in((Object)icon, (Object[])new PointVisualizer[]{PointVisualizer.DOT, PointVisualizer.SMALL_DOT, PointVisualizer.SMALLER_DOT})) {
            Stroke stroke = null;
            Fill fill = Fill.NULL;
            fill = sf.createFill((Expression)ff.property(colorField), (Expression)ff.literal(1.0f));
            String mark = null;
            float size = 0.0f;
            switch (icon) {
                case SMALLER_DOT: {
                    stroke = sf.createStroke((Expression)ff.property(colorField), (Expression)ff.literal(1.0f));
                    mark = "Circle";
                    size = 2.0f;
                    break;
                }
                case SMALL_DOT: {
                    stroke = sf.createStroke((Expression)ff.property(colorField), (Expression)ff.literal(1.0f));
                    mark = "Circle";
                    size = 3.0f;
                    break;
                }
                case DOT: {
                    stroke = sf.createStroke((Expression)ff.literal((Object)Color.GRAY), (Expression)ff.literal(1.0f));
                    mark = "Square";
                    size = 5.0f;
                    break;
                }
            }
            Mark markV = sf.createMark((Expression)ff.literal(mark), stroke, fill, (Expression)ff.literal(size), (Expression)ff.literal(0));
            Graphic graphic = sf.createDefaultGraphic();
            graphic.graphicalSymbols().clear();
            graphic.graphicalSymbols().add(markV);
            graphic.setSize((Expression)ff.literal(size));
            pointSym = sf.createPointSymbolizer(graphic, null);
        } else if (icon == PointVisualizer.WAYPOINT) {
            Graphic graphic = sf.createDefaultGraphic();
            graphic.graphicalSymbols().clear();
            graphic.graphicalSymbols().add(sf.createExternalGraphic((Icon)IconUtils.getSmallIcon("waypoint_white.png"), "png"));
            graphic.setAnchorPoint((AnchorPoint)sf.createAnchorPoint((Expression)ff.literal(0.5), (Expression)ff.literal(0.0)));
            pointSym = sf.createPointSymbolizer(graphic, null);
        }
        if (labelField != null) {
            return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{pointSym, AWaypointRenderer.createLabelStyle(zoom, labelField, font, size2, fontColor)});
        }
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{pointSym});
    }

    public static Style createPolygonStyle(int zoom, Color outlineColor, String fillColor, float opacity, String labelField, String font, Integer size, Color fontColor) {
        Stroke stroke = sf.createStroke((Expression)ff.literal((Object)outlineColor), (Expression)ff.literal(1.5f));
        Fill fill = Fill.NULL;
        if (fillColor != null) {
            fill = sf.createFill((Expression)ff.property(fillColor), (Expression)ff.literal(opacity));
        }
        PolygonSymbolizer polySym = sf.createPolygonSymbolizer(stroke, fill, null);
        if (labelField == null) {
            return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{polySym});
        }
        TextSymbolizer textSym = AWaypointRenderer.createLabelStyle(zoom, labelField, font, size, fontColor);
        textSym.getOptions().put("goodnessOfFit", "0");
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{polySym, textSym});
    }

    public static Style createLineStyle(int zoom, String lineColor, float opacity, float width, String labelField, String font, Integer size, Color fontColor) {
        Stroke stroke = sf.createStroke((Expression)ff.property(lineColor), (Expression)ff.literal(width), (Expression)ff.literal(opacity));
        LineSymbolizer lineSym = sf.createLineSymbolizer(stroke, null);
        if (labelField == null) {
            return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{lineSym});
        }
        TextSymbolizer textSym = AWaypointRenderer.createLabelStyle(zoom, labelField, font, size, fontColor);
        return SLD.wrapSymbolizers((Symbolizer[])new Symbolizer[]{lineSym, textSym});
    }

    public static TextSymbolizer createLabelStyle(int zoom, String label, String font, Integer size, Color fontColor) {
        Font defaultFont = sf.getDefaultFont();
        if (font != null) {
            defaultFont = sf.createFont((Expression)new LiteralExpressionImpl((Object)font), defaultFont.getStyle(), defaultFont.getWeight(), defaultFont.getSize());
        }
        defaultFont.setSize((Expression)new LiteralExpressionImpl((Object)(size != null ? size : (zoom < 10 ? 19 : (zoom < 16 ? 15 : 12)))));
        return sf.createTextSymbolizer(sf.createFill((Expression)ff.literal((Object)(fontColor != null ? fontColor : Color.BLACK))), new Font[]{defaultFont}, null, (Expression)ff.property(label), (LabelPlacement)sf.createPointPlacement(sf.createAnchorPoint((Expression)ff.literal(0.5), (Expression)ff.literal(0.0)), sf.createDisplacement((Expression)ff.literal(0), (Expression)ff.literal(5)), (Expression)ff.literal(0)), null);
    }

    private Coordinate setupConverter(double x, double y) {
        try {
            if (y > 85.051129) {
                y = 85.051128;
            }
            if (y < -85.051129) {
                y = -85.051128;
            }
            Coordinate coordinate = new Coordinate(x, y);
            Coordinate coordinate2 = new Coordinate(x, y);
            MathTransform transform = CRS.findMathTransform((CoordinateReferenceSystem)CRS_STANDARD, (CoordinateReferenceSystem)CRS_MAP, (boolean)false);
            JTS.transform((Coordinate)coordinate, (Coordinate)coordinate2, (MathTransform)transform);
            return coordinate2;
        }
        catch (Exception ex) {
            LOGGER.error("Error while creating map bounds", (Throwable)ex);
            return null;
        }
    }

    private class PaintingState {
        int zoom;
        Rectangle bounds;
        BufferedImage cache;
        Future cancel;
        Future drawing;

        private PaintingState() {
        }
    }
}

