/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.view.ColorUtils;
import com.sigge.filerunner.view.results.graph.geo.GeoWaypoint;
import com.sigge.filerunner.view.results.graph.geo.GeometryCollection;
import com.sigge.filerunner.view.results.graph.geo.GraphWaypoint;
import com.sigge.filerunner.view.results.graph.geo.IMultipointRenderer;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.sigge.filerunner.view.results.graph.geo.options.AWaypointRenderer;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import java.awt.Graphics2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Set;
import java.util.stream.Collectors;
import org.jxmapviewer.JXMapViewer;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.MultiLineString;
import org.locationtech.jts.geom.Point;

public class IdentityWaypointRenderer2
extends AWaypointRenderer<GraphWaypoint>
implements IMultipointRenderer<GraphWaypoint> {
    private final PointVisualizer icon;

    public IdentityWaypointRenderer2(PointVisualizer icon) {
        this.icon = icon;
    }

    @Override
    public void paintWaypoints(Graphics2D g, JXMapViewer viewer, WaypointHolder<GraphWaypoint> holder) {
        Set<GraphWaypoint> waypoints = holder.getWaypoints();
        int srid = 0;
        Iterator<GraphWaypoint> iterator = waypoints.iterator();
        if (iterator.hasNext()) {
            GraphWaypoint wp = iterator.next();
            Geometry geometry = ((GeoWaypoint)wp).getGeometry();
            srid = geometry.getSRID();
        }
        int zoom = viewer.getZoom();
        HashMap<String, GeometryCollection> MAP = new HashMap<String, GeometryCollection>();
        int sridFinal = srid;
        for (GraphWaypoint point : waypoints) {
            GeoWaypoint geoWaypoint = (GeoWaypoint)point;
            Geometry geometryOuter = geoWaypoint.getGeometry();
            int i = 0;
            while (i < geometryOuter.getNumGeometries()) {
                Geometry geometry = geometryOuter.getGeometryN(i);
                String pointClass = geometry instanceof Point ? "Point" : (geometry instanceof LineString || geometry instanceof MultiLineString ? "LineString" : "Polygon");
                GeometryCollection coll = MAP.computeIfAbsent(pointClass, f -> new GeometryCollection(pointClass, sridFinal, zoom, this.icon, holder.getFont(), holder.getFontSize(), holder.getFontColor()));
                coll.featureBuilder.add((Object)geometry);
                coll.featureBuilder.add((Object)point.getLabel());
                coll.featureBuilder.add((Object)ColorUtils.hexOfColor(point.getColor()));
                coll.features.add(coll.featureBuilder.buildFeature(null));
                ++i;
            }
        }
        this.paintLayers(viewer, MAP.values().stream().map(f -> f.shpLayer).collect(Collectors.toList()), g);
    }
}

