/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph.geo;

import com.sigge.filerunner.view.ColorUtils;
import com.sigge.filerunner.view.results.graph.geo.FromToWaypoint;
import com.sigge.filerunner.view.results.graph.geo.GeoWaypoint;
import com.sigge.filerunner.view.results.graph.geo.GeometryCollection;
import com.sigge.filerunner.view.results.graph.geo.IMultipointRenderer;
import com.sigge.filerunner.view.results.graph.geo.WaypointHolder;
import com.sigge.filerunner.view.results.graph.geo.options.AWaypointRenderer;
import com.sigge.filerunner.view.results.graph.geo.options.PointVisualizer;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Polygon;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.util.HashMap;
import java.util.Iterator;
import java.util.stream.Collectors;
import org.jxmapviewer.JXMapViewer;
import org.jxmapviewer.viewer.GeoPosition;
import org.jxmapviewer.viewer.TileFactory;
import org.locationtech.jts.geom.Geometry;
import org.locationtech.jts.geom.LineString;
import org.locationtech.jts.geom.Point;

public class FromToWaypointRenderer2
extends AWaypointRenderer<FromToWaypoint>
implements IMultipointRenderer<FromToWaypoint> {
    private static final BasicStroke DEFAULT_LINE_STROKE = new BasicStroke(2.0f);
    private static final Color GRID_COLOR = new Color(0, 0, 255, 90);
    private static final int ARROW_SIZE_SMALL = 100;
    private static final Polygon ARROWHEAD = FromToWaypointRenderer2.createArrow();
    private static final Polygon ARROWHEAD_LARGE = FromToWaypointRenderer2.createLargeArrow();
    private final PointVisualizer icon;
    private final PointVisualizer iconTo;

    public FromToWaypointRenderer2(PointVisualizer icon, PointVisualizer iconTo) {
        this.icon = icon;
        this.iconTo = iconTo;
    }

    @Override
    public void paintWaypoint(Graphics2D g, JXMapViewer viewer, FromToWaypoint f) {
    }

    void drawArrow(Graphics2D gax, double x1, double y1, double x2, double y2) {
        Graphics2D ga = (Graphics2D)gax.create();
        ga.setColor(GRID_COLOR);
        ga.setStroke(DEFAULT_LINE_STROKE);
        ga.drawLine((int)x1, (int)y1, (int)x2, (int)y2);
        double l = Math.sqrt(Math.pow(x2 - x1, 2.0) + Math.pow(y2 - y1, 2.0));
        Polygon arrow = l > 100.0 ? ARROWHEAD_LARGE : ARROWHEAD;
        double d = l / (double)(l > 100.0 ? 50 : 10);
        double newX = x2 + (x1 - x2) / l * d;
        double newY = y2 + (y1 - y2) / l * d;
        double dx = x2 - x1;
        double dy = y2 - y1;
        double angle = Math.atan2(dy, dx);
        angle = -1.0 * Math.toDegrees(angle);
        if (angle < 0.0) {
            angle += 360.0;
        }
        angle *= -1.0;
        angle = Math.toRadians(angle);
        AffineTransform at = new AffineTransform();
        at.translate(newX, newY);
        at.rotate(angle);
        ga.transform(at);
        ga.fill(arrow);
        ga.drawPolygon(arrow);
        ga.dispose();
    }

    private static Polygon createArrow() {
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(2, 0);
        arrowHead.addPoint(-2, 2);
        arrowHead.addPoint(-1, 0);
        arrowHead.addPoint(-2, -2);
        return arrowHead;
    }

    private static Polygon createLargeArrow() {
        Polygon arrowHead = new Polygon();
        arrowHead.addPoint(5, 0);
        arrowHead.addPoint(-5, 5);
        arrowHead.addPoint(-2, 0);
        arrowHead.addPoint(-5, -5);
        return arrowHead;
    }

    @Override
    public void paintWaypoints(Graphics2D g, JXMapViewer viewer, WaypointHolder<FromToWaypoint> waypoints) {
        int srid = 0;
        Iterator<FromToWaypoint> iterator = waypoints.getWaypoints().iterator();
        if (iterator.hasNext()) {
            FromToWaypoint wp = iterator.next();
            Geometry geometry = ((GeoWaypoint)wp.getFrom()).getGeometry();
            srid = geometry.getSRID();
        }
        int zoom = viewer.getZoom();
        HashMap<String, GeometryCollection> MAP = new HashMap<String, GeometryCollection>();
        int sridFinal = srid;
        GeoWaypoint prev = null;
        GeoWaypoint geoWaypoint = null;
        TileFactory factory = viewer.getTileFactory();
        for (FromToWaypoint point : waypoints.getWaypoints()) {
            int i = 0;
            while (i <= 1) {
                if (i == 0) {
                    geoWaypoint = (GeoWaypoint)point.getFrom();
                } else {
                    prev = geoWaypoint;
                    geoWaypoint = (GeoWaypoint)point.getTo();
                }
                Geometry geometry = geoWaypoint.getGeometry();
                String pointClass = geometry instanceof Point ? "Point" : (geometry instanceof LineString ? "LineString" : "Polygon");
                int x = i;
                GeometryCollection coll = MAP.computeIfAbsent(String.valueOf(i == 0 ? "FR" : "TO") + pointClass, f -> new GeometryCollection(pointClass, sridFinal, zoom, x == 0 ? this.icon : this.iconTo, waypoints.getFont(), waypoints.getFontSize(), waypoints.getFontColor()));
                coll.featureBuilder.add((Object)geometry);
                coll.featureBuilder.add((Object)geoWaypoint.getLabel());
                coll.featureBuilder.add((Object)ColorUtils.hexOfColor(geoWaypoint.getColor()));
                coll.features.add(coll.featureBuilder.buildFeature(null));
                ++i;
            }
            Point centroid = prev.getGeometry().getCentroid();
            Point centroidTo = geoWaypoint.getGeometry().getCentroid();
            Point2D from = factory.geoToPixel(new GeoPosition(centroid.getY(), centroid.getX()), zoom);
            Point2D to = factory.geoToPixel(new GeoPosition(centroidTo.getY(), centroidTo.getX()), zoom);
            this.drawArrow(g, from.getX(), from.getY(), to.getX(), to.getY());
        }
        this.paintLayers(viewer, MAP.values().stream().map(f -> f.shpLayer).collect(Collectors.toList()), g);
    }
}

