/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results.graph;

import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.TextListItem;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.graph.GraphResult;
import com.sigge.filerunner.view.results.graph.GraphType;
import com.sigge.filerunner.view.results.graph.GraphView;
import java.awt.Component;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;

public interface IGraphHandler
extends Closeable {
    default public boolean canHandle(GraphResult graphResultSet) {
        return true;
    }

    default public void displayError(JPanel panel, String message) {
        panel.removeAll();
        panel.add((Component)new JLabel(message, IconUtils.getSmallIcon("error.png"), 2), "North");
        panel.revalidate();
        panel.repaint();
    }

    default public boolean okToGraph(GraphResult resultSetChosen) {
        return resultSetChosen.getResultSet().getRowCount() < 10000 || JOptionPane.showOptionDialog(null, "Do you really want to graph " + resultSetChosen.getResultSet().getRowCount() + " rows?", "Confirm graph", 0, 3, null, new String[]{"Generate graph", "Cancel"}, "Generate graph") == 0;
    }

    public void present(GraphView var1, GraphType var2, List<GraphResult> var3, GraphResult var4, boolean var5);

    default public List<TextListItem<Integer>> getColumns(IResultSetTable m) {
        ArrayList<TextListItem<Integer>> cols = new ArrayList<TextListItem<Integer>>();
        int i = 0;
        while (i < m.getColumnCount()) {
            cols.add(new TextListItem<Integer>(i, m.getColumnName(i)));
            ++i;
        }
        return cols;
    }
}

