/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import com.google.inject.name.Named;
import com.sigge.filerunner.action.MenuAction;
import com.sigge.filerunner.core.ButtonUtils;
import com.sigge.filerunner.core.FileTransferable;
import com.sigge.filerunner.core.ProcessUtils;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.export.ExportAction;
import com.sigge.filerunner.export.ExportResult;
import com.sigge.filerunner.export.excel.ExcelAction;
import com.sigge.filerunner.export.raw.RawExportAction;
import com.sigge.filerunner.sql.Server;
import com.sigge.filerunner.view.IEditorManager;
import com.sigge.filerunner.view.IStatusUpdater;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.core.TableRowUtilities;
import com.sigge.filerunner.view.results.CompactConverter;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.MarkdownConverter;
import com.sigge.filerunner.view.results.MathBuilder;
import com.sigge.filerunner.view.results.MultiResultPane;
import com.sigge.filerunner.view.results.ResultBasicTransferable;
import com.sigge.filerunner.view.results.ResultSetTableModel;
import com.sigge.filerunner.view.results.TextResultSetConverter;
import com.sigge.filerunner.view.results.XmlFormatter;
import com.sigge.filerunner.view.results.export.ChooseDialog;
import com.sigge.filerunner.view.results.export.FileResult;
import com.sigge.filerunner.view.results.export.ResultSetTableModelExport;
import com.sigge.filerunner.view.results.export.ResultSetTableModelExportModel;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenterListHolder;
import com.siggemannen.binding.Binder;
import com.siggemannen.binding.IListProperty;
import com.siggemannen.core.Tuple;
import com.siggemannen.functional.throwing.ThrowingConsumer;
import java.awt.Desktop;
import java.awt.Toolkit;
import java.awt.datatransfer.Clipboard;
import java.awt.datatransfer.Transferable;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.io.IOException;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.logging.Level;
import java.util.stream.Collectors;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.TableModel;
import org.jdesktop.swingx.JXErrorPane;
import org.jdesktop.swingx.error.ErrorInfo;
import org.jdesktop.swingx.plaf.basic.core.BasicTransferable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Singleton
public class ResultTableHandler {
    private static ExportAction exportAction;
    private final IStatusUpdater statusUpdater;
    private final IEditorManager editorManager;
    private final Set<ExportAction> actions;
    private static final Logger LOGGER;
    private static final ImageIcon EXPORT_ICON;
    private final JFrame mainFrame;

    static {
        LOGGER = LoggerFactory.getLogger(ResultTableHandler.class);
        EXPORT_ICON = IconUtils.getSmallIcon("export2.png");
    }

    @Inject
    public ResultTableHandler(@Named(value="mainFrame") JFrame mainFrame, IStatusUpdater statusUpdater, IEditorManager editorManager, Set<ExportAction> actions) {
        this.mainFrame = mainFrame;
        for (ExportAction action : actions) {
            if (!(action instanceof ExcelAction)) continue;
            exportAction = action;
        }
        this.statusUpdater = statusUpdater;
        this.editorManager = editorManager;
        this.actions = actions;
    }

    public void handle(final JTable jt, final MultiResultPane pane, final Server server) {
        jt.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                if (ButtonUtils.isRightClick(e)) {
                    ResultTableHandler.this.createMenu(jt, pane, server).show(jt, e.getX(), e.getY());
                }
            }
        });
        ListSelectionListener listener = this.listener(jt);
        jt.getSelectionModel().addListSelectionListener(listener);
        jt.getColumnModel().getSelectionModel().addListSelectionListener(listener);
    }

    private ListSelectionListener listener(JTable jt) {
        return e -> {
            try {
                if (e.getValueIsAdjusting()) {
                    return;
                }
                this.statusUpdater.removeMessage(this.getClass().getName());
                ResultSetTableModel rstd = (ResultSetTableModel)jt.getModel();
                List<Integer> cols = ResultTableHandler.getSelectedColumns(rstd);
                int columnCount = cols.size();
                if (columnCount == 0) {
                    return;
                }
                StringBuilder sb = new StringBuilder();
                HashSet colTypes = new HashSet();
                cols.forEach(l -> {
                    boolean bl = colTypes.add(rstd.getFieldType((int)l));
                });
                List<Integer> rows = ResultTableHandler.getSelectedRows(rstd);
                if (rows.size() == 0) {
                    return;
                }
                sb.append("Rows: ").append(rows.size()).append(", cols: ").append(columnCount).append("&nbsp;");
                if (!colTypes.retainAll(Arrays.asList(FieldType.SQLFLOAT, FieldType.SQLINTEGER, FieldType.SQLLONG, FieldType.SQLBOOLEAN))) {
                    MathBuilder mb = new MathBuilder();
                    int row = 0;
                    while (row < rows.size()) {
                        int col = 0;
                        while (col < cols.size()) {
                            mb.accept((Number)rstd.getValueAt(rows.get(row), cols.get(col)));
                            ++col;
                        }
                        ++row;
                    }
                    Double max = mb.max();
                    Double min = mb.min();
                    if (max != null && (rows.size() > 1 || cols.size() > 1)) {
                        sb.append("Sum: ").append(this.getDecimalString(mb.sum())).append(", ");
                        sb.append("Average: ").append(this.getDecimalString(mb.average())).append(", ");
                        sb.append("Max: ").append(this.getDecimalString(max)).append(", ");
                        sb.append("Min: ").append(this.getDecimalString(min));
                        sb.append("&nbsp;&nbsp;&nbsp;&nbsp;&nbsp;");
                    }
                }
                this.statusUpdater.addMessage(sb.toString(), this.getClass().getName());
            }
            catch (Exception ex) {
                LOGGER.error("Error while generating data", (Throwable)ex);
            }
        };
    }

    private String getDecimalString(Double d) {
        return BigDecimal.valueOf(d).setScale(5, RoundingMode.HALF_UP).stripTrailingZeros().toPlainString();
    }

    private int getRounding(IResultSetTable rstd, List<Integer> cols) {
        return 5;
    }

    JPopupMenu createMenu(JTable table, MultiResultPane pane, Server server) {
        boolean xmlCellSelected;
        IResultSetTable rstm = (IResultSetTable)((Object)table.getModel());
        JPopupMenu popup = new JPopupMenu();
        boolean selectionExist = table.getSelectedRowCount() > 0 || table.getSelectedColumnCount() > 0;
        boolean isSingleCellSelected = table.getSelectedRowCount() == 1 && table.getSelectedColumnCount() == 1;
        ArrayList<Object> menuList = new ArrayList<Object>();
        boolean bl = xmlCellSelected = isSingleCellSelected && rstm.getFieldType(TableRowUtilities.convertColumnIndexToModel(table.getColumnModel(), table.getSelectedColumn())) == FieldType.SQLXMLSTRING;
        if (xmlCellSelected) {
            menuList.add(this.item(-100, new MenuAction("Open XML data in new window", IconUtils.getSmallIcon("xml.png"), null, () -> this.editorManager.newFile(rstm.getColumnName(TableRowUtilities.convertColumnIndexToModel(table.getColumnModel(), table.getSelectedColumn())), ResultTableHandler.getSingleXMLFieldValue(table), "text/xml"))));
        }
        JMenuItem copyAsText = new JMenuItem(new MenuAction("Copy selected data as space padded text", null, null, () -> this.copyAsText(rstm, true)));
        JMenuItem copyAsTextAll = new JMenuItem(new MenuAction("Copy all data as space padded text", null, null, () -> this.copyAsText(rstm, false)));
        JMenuItem copySelectedAsMarkdownTable = new JMenuItem(new MenuAction("Copy selected data as markdown table", null, null, () -> this.copyAsMarkDown(rstm, true)));
        JMenuItem copyAsMarkdownTable = new JMenuItem(new MenuAction("Copy all data as markdown table", null, null, () -> this.copyAsMarkDown(rstm, false)));
        JMenuItem copySelectedAsMarkdownOldTable = new JMenuItem(new MenuAction("Copy selected data as compact table", null, null, () -> this.copyAsCompact(rstm, true)));
        JMenuItem copyAllAsMarkdownOldTable = new JMenuItem(new MenuAction("Copy all data as compact table", null, null, () -> this.copyAsCompact(rstm, false)));
        if (selectionExist) {
            menuList.add(this.item(-50, new MenuAction("Copy selected data with columns", IconUtils.getSmallIcon("table_selection_all.png"), null, () -> this.putDataToClipboard(ResultTableHandler.getTableRowData(table, true, true)))));
            menuList.add(this.item(-40, new MenuAction("Copy selected data", IconUtils.getSmallIcon("table_selection_block.png"), null, () -> {
                if (xmlCellSelected) {
                    this.putDataToClipboard(ResultTableHandler.getSingleXMLField(table));
                } else {
                    this.putDataToClipboard(ResultTableHandler.getTableRowData(table, true, false));
                }
            })));
            menuList.add(this.item(-35, new MenuAction("Copy selected column names", IconUtils.getSmallIcon("table_selection_header.png"), null, () -> this.putDataToClipboard(ResultTableHandler.getHeaderRowData(table, true)))));
            JMenu copyAs = new JMenu("Copy as...");
            menuList.add(Tuple.of((Object)-33, (Object)copyAs));
            copyAs.add(copyAsText);
            copyAs.add(copyAsTextAll);
            copyAs.addSeparator();
            copyAs.add(copySelectedAsMarkdownTable);
            copyAs.add(copyAsMarkdownTable);
            copyAs.addSeparator();
            copyAs.add(copySelectedAsMarkdownOldTable);
            copyAs.add(copyAllAsMarkdownOldTable);
            menuList.add(this.separator(-30));
            menuList.add(this.item(-20, new MenuAction("Export selected data", IconUtils.getSmallIcon("export2.png"), null, () -> this.exportToPane(server, pane, Arrays.asList(rstm), true, true))));
        } else {
            menuList.add(this.item(-35, new MenuAction("Copy all column names", IconUtils.getSmallIcon("table_selection_header.png"), null, () -> this.putDataToClipboard(ResultTableHandler.getHeaderRowData(table, false)))));
            JMenu copyAs = new JMenu("Copy as...");
            menuList.add(Tuple.of((Object)-33, (Object)copyAs));
            copyAs.add(copyAsTextAll);
            copyAs.add(copyAsMarkdownTable);
            menuList.add(this.separator(-30));
        }
        menuList.add(this.item(-10, new MenuAction("Export whole table", IconUtils.getSmallIcon("document_up.png"), null, () -> this.exportToPane(server, pane, Arrays.asList(rstm), false, true))));
        menuList.stream().sorted(Comparator.comparingInt(Tuple::first)).map(Tuple::second).forEachOrdered(item -> {
            if (item != null) {
                popup.add((JMenuItem)item);
            } else {
                popup.addSeparator();
            }
        });
        return popup;
    }

    private void exportToPane(Server server, MultiResultPane pane, List<IResultSetTable> table, boolean selected, boolean options) {
        Optional<ExportResult> res = this.exportDataWithOptions(table, selected, options);
        if (res.isPresent() && pane != null) {
            for (File f : res.get().filesExported()) {
                pane.addFilePane(new FileResult(null, "", f, server));
            }
        }
    }

    private void copyAsMarkDown(IResultSetTable rstm, boolean b) {
        String s = new MarkdownConverter().convert(b ? rstm.getSelectedSnapshot() : rstm).toString();
        this.putDataToClipboard((Transferable)((Object)new ResultBasicTransferable(s, null, b ? rstm.getSelectedSnapshot() : null)));
    }

    private void copyAsCompact(IResultSetTable rstm, boolean b) {
        String s = new CompactConverter().convert(b ? rstm.getSelectedSnapshot() : rstm).toString();
        this.putDataToClipboard((Transferable)((Object)new ResultBasicTransferable(s, null, b ? rstm.getSelectedSnapshot() : null)));
    }

    private Tuple<Integer, JMenuItem> separator(Integer sort) {
        return Tuple.of((Object)sort, null);
    }

    private Tuple<Integer, JMenuItem> item(Integer sort, MenuAction action) {
        return Tuple.of((Object)sort, (Object)new JMenuItem(action));
    }

    private void copyAsText(IResultSetTable rem, boolean selected) {
        String s = new TextResultSetConverter().convert(selected ? rem.getSelectedSnapshot() : rem).toString();
        this.putDataToClipboard((Transferable)((Object)new ResultBasicTransferable(s, null, selected ? rem.getSelectedSnapshot() : null)));
    }

    public static String getSingleXMLFieldValue(JTable table) {
        XmlFormatter xs = new XmlFormatter((String)table.getValueAt(table.getSelectedRow(), table.getSelectedColumn()));
        return xs.format();
    }

    public static Transferable getSingleXMLField(JTable table) {
        XmlFormatter xs = new XmlFormatter((String)table.getValueAt(table.getSelectedRow(), table.getSelectedColumn()));
        return new BasicTransferable(xs.format(), null);
    }

    public Optional<ExportResult> exportDataWithOptions(List<IResultSetTable> models, boolean selected, boolean options) {
        List<IResultSetTable> tableModels;
        ChooseDialog cr = new ChooseDialog(null, true);
        cr.setTitle("Export data");
        cr.getChooseLabel().setText("Choose resultsets");
        cr.getOkButton().setText("Export");
        cr.getExportTypeCombo().setVisible(options);
        Binder.Presenter presenter = Binder.bindToCombo(cr.getExportTypeCombo(), this.actions.stream().collect(Collectors.toList()));
        cr.getExportTypeCombo().setRenderer(new LabelledCellRenderer(false));
        cr.getExportTypeCombo().setSelectedItem(exportAction);
        cr.getOkButton().setIcon(EXPORT_ICON);
        List rste = models.stream().map(ResultSetTableModelExport::new).collect(Collectors.toList());
        APresenterListHolder holder = new APresenterListHolder(rste);
        AModel<APresenterListHolder> ap = new AModel<APresenterListHolder>(){

            protected void copyObject(APresenterListHolder object) {
            }
        };
        ap.setObject((Object)holder);
        ResultSetTableModelExportModel rm = new ResultSetTableModelExportModel((IListProperty<ResultSetTableModelExport>)ap.getListProperty("list"));
        cr.getResultsTable().setModel((TableModel)((Object)rm));
        cr.getResultsTable().setColumnModel(rm.getTableColumnModel());
        cr.getResultsTable().packAll();
        cr.centerOnCorrectScreen(this.mainFrame);
        cr.setVisible(true);
        if (cr.getReturnStatus() == 1 && (tableModels = rste.stream().filter(ResultSetTableModelExport::isChecked).map(ResultSetTableModelExport::getModel).collect(Collectors.toList())).size() > 0) {
            return ResultTableHandler.exportData(tableModels, selected, this.actions.stream().filter(f -> f.equals(((com.siggemannen.binding.ValueHolder)presenter.getModel().getObject()).getValue())).findFirst().get());
        }
        return Optional.empty();
    }

    public Optional<ExportResult> exportData(List<IResultSetTable> models, boolean selected) {
        return ResultTableHandler.exportData(models, selected, exportAction);
    }

    public static <T> Optional<ExportResult> exportData(List<IResultSetTable> models, boolean selected, ExportAction<T> action) {
        ValueHolder vh = new ValueHolder();
        if (models.size() == 0) {
            return Optional.empty();
        }
        action.export(models, selected, (ThrowingConsumer<ExportResult>)((ThrowingConsumer)er -> {
            vh.accept(er);
            if (er.isSuccessful() && er.filesExported().size() > 0) {
                int ret;
                if (!(action instanceof RawExportAction)) {
                    exportAction = action;
                }
                if ((ret = JOptionPane.showOptionDialog(null, "File(s) were successfully exported. Do you want to open file?", "File exported", 1, -1, null, new String[]{"Open file", "Browse to file", "Copy file(s) to clipboard", "Do nothing"}, null)) == 0) {
                    try {
                        Desktop.getDesktop().open(er.filesExported().get(0));
                    }
                    catch (IOException iOException) {}
                } else if (ret == 1) {
                    ProcessUtils.browseToFile(er.filesExported().get(0));
                } else if (ret == 2) {
                    FileTransferable ft = new FileTransferable(er.filesExported());
                    Toolkit.getDefaultToolkit().getSystemClipboard().setContents(ft, ft);
                }
            } else if (er.getException() != null) {
                JXErrorPane.showDialog(null, (ErrorInfo)new ErrorInfo("Export failed", "Export failed due to: " + er.getFailureReason(), null, null, (Throwable)er.getException(), Level.SEVERE, null));
            } else if (StringUtils.isNotEmpty(er.getFailureReason())) {
                JOptionPane.showMessageDialog(null, "Export failed: " + er.getFailureReason(), "Failure", 0);
            }
        }));
        return vh.getOptionalValue();
    }

    private void putDataToClipboard(Transferable data) {
        if (data != null) {
            Clipboard cb = Toolkit.getDefaultToolkit().getSystemClipboard();
            cb.setContents(data, (a, b) -> {});
        }
    }

    private static Transferable getHeaderRowData(JTable table, boolean selectedHeadersOnly) {
        int[] cols;
        if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed() && selectedHeadersOnly) {
            return null;
        }
        if (!selectedHeadersOnly || !table.getColumnSelectionAllowed()) {
            int colCount = table.getColumnCount();
            cols = new int[colCount];
            int counter = 0;
            while (counter < colCount) {
                cols[counter] = counter;
                ++counter;
            }
        } else {
            cols = table.getSelectedColumns();
        }
        StringBuilder plainBuf = new StringBuilder();
        int col = 0;
        while (col < cols.length) {
            String val;
            Object obj = table.getTableHeader().getColumnModel().getColumn(cols[col]).getHeaderValue();
            String string = val = obj == null ? "" : obj.toString().trim();
            if (col > 0) {
                plainBuf.append(", ");
            }
            plainBuf.append(val);
            ++col;
        }
        return new BasicTransferable(plainBuf.toString(), plainBuf.toString());
    }

    private static Transferable getTableRowData(JTable table, boolean selectionOnly, boolean includeHeaders) {
        int[] cols;
        int counter;
        int[] rows;
        if (!table.getRowSelectionAllowed() && !table.getColumnSelectionAllowed() && selectionOnly) {
            return null;
        }
        if (!selectionOnly || !table.getRowSelectionAllowed()) {
            int rowCount = table.getRowCount();
            rows = new int[rowCount];
            counter = 0;
            while (counter < rowCount) {
                rows[counter] = counter;
                ++counter;
            }
        } else {
            rows = table.getSelectedRows();
        }
        if (!selectionOnly || !table.getColumnSelectionAllowed()) {
            int colCount = table.getColumnCount();
            cols = new int[colCount];
            counter = 0;
            while (counter < colCount) {
                cols[counter] = counter;
                ++counter;
            }
        } else {
            cols = table.getSelectedColumns();
        }
        if (rows == null || cols == null || rows.length == 0 || cols.length == 0) {
            return null;
        }
        StringBuilder plainBuf = new StringBuilder(rows.length * 10);
        StringBuilder htmlBuf = new StringBuilder(rows.length * 15);
        htmlBuf.append("<html>\n<body>\n<table>\n");
        htmlBuf.append("<tr>\n");
        if (includeHeaders) {
            int col = 0;
            while (col < cols.length) {
                Object obj = table.getTableHeader().getColumnModel().getColumn(cols[col]).getHeaderValue();
                String val = obj == null ? "" : obj.toString();
                plainBuf.append(val.trim());
                if (col + 1 != cols.length) {
                    plainBuf.append("\t");
                }
                htmlBuf.append("  <th>" + val + "</th>\n");
                ++col;
            }
            htmlBuf.append("</tr>\n");
            plainBuf.append("\n");
        }
        int row = 0;
        while (row < rows.length) {
            htmlBuf.append("<tr>\n");
            int col = 0;
            while (col < cols.length) {
                Object obj = table.getValueAt(rows[row], cols[col]);
                String val = obj == null ? "" : obj.toString();
                plainBuf.append(val);
                if (col + 1 != cols.length) {
                    plainBuf.append("\t");
                }
                htmlBuf.append("  <td>").append(val).append("</td>\n");
                ++col;
            }
            if (row + 1 != rows.length) {
                plainBuf.append("\n");
            }
            htmlBuf.append("</tr>\n");
            ++row;
        }
        htmlBuf.append("</table>\n</body>\n</html>");
        IResultSetTable rst = table.getModel() instanceof ResultSetTableModel && selectionOnly ? ((ResultSetTableModel)table.getModel()).getSelectedSnapshot() : null;
        return new ResultBasicTransferable(plainBuf.toString(), rows.length > 1 || cols.length > 1 ? htmlBuf.toString() : plainBuf.toString(), rst);
    }

    public static List<Integer> getSelectedRows(ResultSetTableModel rstm) {
        ListSelectionModel selectionModel = rstm.getTableRowSelectionModel();
        int iMin = selectionModel.getMinSelectionIndex();
        int iMax = selectionModel.getMaxSelectionIndex();
        ArrayList<Integer> rows = new ArrayList<Integer>();
        if (iMin == -1 || iMax == -1) {
            return rows;
        }
        int i = iMin;
        while (i <= iMax) {
            if (selectionModel.isSelectedIndex(i)) {
                rows.add(ResultTableHandler.convertRowIndexToModel(rstm, i));
            }
            ++i;
        }
        return rows;
    }

    private static Integer convertRowIndexToModel(ResultSetTableModel rstm, int i) {
        return rstm.getSorter() == null ? i : rstm.getSorter().convertRowIndexToModel(i);
    }

    public static List<Integer> getSelectedColumns(ResultSetTableModel rstm) {
        return Arrays.stream(rstm.getTableColumnModel().getSelectedColumns()).mapToObj(value -> TableRowUtilities.convertColumnIndexToModel(rstm.getTableColumnModel(), value)).collect(Collectors.toList());
    }

    public void removeMessages() {
        this.statusUpdater.removeMessage(this.getClass().getName());
    }
}

