/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.core.VTableCellRenderer;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.TimeStampWrapperHandler;
import java.awt.Color;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Arrays;
import java.util.Locale;
import javax.swing.JLabel;
import javax.swing.JTable;

public class ResultSetTableRenderer
extends VTableCellRenderer {
    private final IResultSetTable model;
    private final DecimalFormat DOUBLE_FORMATTER = this.createDecimalFormat(16);

    public ResultSetTableRenderer(IResultSetTable model) {
        this.model = model;
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, null, isSelected, hasFocus, row, column);
        this.setBorder(this.DEFAULT_BORDER);
        if (value == null) {
            this.setText("NULL");
            if (!isSelected) {
                this.setBackground(new Color(250, 255, 214));
            }
            return this;
        }
        int modelColumn = table.convertColumnIndexToModel(column);
        int modelRow = row;
        FieldType type = null;
        if (modelColumn >= 0) {
            type = this.model.getFieldType(modelColumn);
            if (row >= 0) {
                modelRow = table.convertRowIndexToModel(row);
            } else {
                modelColumn = -1;
            }
        } else {
            type = value instanceof Timestamp ? FieldType.SQLDATE : (value instanceof Double ? FieldType.SQLFLOAT : (value instanceof Integer ? FieldType.SQLINTEGER : (value instanceof Long ? FieldType.SQLLONG : FieldType.SQLSTRING)));
        }
        switch (type) {
            case SQLDATE: {
                if (modelColumn >= 0) {
                    this.setText(this.model.getValueForDisplay(modelRow, modelColumn));
                    break;
                }
                this.setText(TimeStampWrapperHandler.getValue(value));
                break;
            }
            case SQLFLOAT: {
                if (modelColumn >= 0) {
                    this.setText(this.model.getValueForDisplay(modelRow, modelColumn));
                    break;
                }
                if (value instanceof String) {
                    this.setText((String)value);
                    break;
                }
                if ((Double)value % 1.0 == 0.0 || modelColumn >= 0 && Integer.valueOf(0).equals(this.model.getScale(modelColumn))) {
                    this.setText(String.format("%.0f", value));
                    break;
                }
                if (modelColumn >= 0 && this.model.getScale(modelColumn) != null) {
                    this.setText(this.model.getFormatForColumn(modelColumn).format(value));
                    break;
                }
                this.setText(this.DOUBLE_FORMATTER.format(value));
                break;
            }
            case SQLINTEGER: 
            case SQLLONG: 
            case SQLBOOLEAN: {
                this.setText(value.toString());
                break;
            }
            case SQLGEOMETRY: 
            case SQLGEOGRAPHY: {
                this.setForeground(Color.BLUE);
                if (value instanceof String && ((String)value).length() > 100000) {
                    this.setText(((String)value).substring(0, 99997));
                    break;
                }
                this.setText(value.toString());
                break;
            }
            case SQLXMLSTRING: {
                this.setForeground(Color.BLUE);
            }
            default: {
                if (value instanceof String && ((String)value).length() > 100000) {
                    this.setText(((String)value).substring(0, 99997).replaceAll("\\s+", " "));
                    break;
                }
                this.setText(value.toString().replaceAll("\\s+", " "));
            }
        }
        return this;
    }

    private DecimalFormat createDecimalFormat(int scale) {
        char[] x = new char[scale];
        Arrays.fill(x, '#');
        return new DecimalFormat("#." + new String(x), new DecimalFormatSymbols(Locale.US));
    }
}

