/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.microsoft.sqlserver.jdbc.Geography;
import com.microsoft.sqlserver.jdbc.Geometry;
import com.microsoft.sqlserver.jdbc.SQLServerException;
import com.microsoft.sqlserver.jdbc.SQLServerResultSet;
import com.sigge.dbrunner.SQLOptions;
import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.results.AColumnHandler;
import com.sigge.filerunner.view.results.DateTimeOffsetColumnHandler;
import com.sigge.filerunner.view.results.DoubleColumnHandler;
import com.sigge.filerunner.view.results.FieldType;
import com.sigge.filerunner.view.results.IResultSetTable;
import com.sigge.filerunner.view.results.IntColumnHandler;
import com.sigge.filerunner.view.results.LongColumnHandler;
import com.sigge.filerunner.view.results.ObjectColumnHandler;
import com.sigge.filerunner.view.results.ResultSetTableRenderer;
import com.sigge.filerunner.view.results.SelectedResultSetTable;
import com.sigge.filerunner.view.results.StringColumnHandler;
import com.sigge.filerunner.view.results.TimeStampColumnHandler;
import com.sigge.filerunner.view.results.TimeStampWrapperHandler;
import com.siggemannen.core.ListUtils;
import java.io.IOException;
import java.io.Serializable;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.UUID;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Consumer;
import javax.swing.DefaultListSelectionModel;
import javax.swing.ListSelectionModel;
import javax.swing.RowSorter;
import javax.swing.SortOrder;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import microsoft.sql.DateTimeOffset;
import org.apache.poi.ss.formula.eval.NotImplementedException;
import org.jdesktop.swingx.table.DefaultTableColumnModelExt;
import org.jdesktop.swingx.table.TableColumnExt;

public class ResultSetTableModel
extends AbstractTableModel
implements IResultSetTable,
Serializable {
    private final String UUID = java.util.UUID.randomUUID().toString();
    private final List<FieldType> columnClass = new ArrayList<FieldType>();
    private final List<String> columnNativeType = new ArrayList<String>();
    private final List<Integer> scales = new ArrayList<Integer>();
    private final List<Integer> sizes = new ArrayList<Integer>();
    private final Map<Integer, Boolean> nullable = new HashMap<Integer, Boolean>();
    private transient RowSorter sorter;
    private final transient DefaultTableColumnModelExt tcl = new DefaultTableColumnModelExt();
    private final transient ListSelectionModel lsm = new DefaultListSelectionModel();
    private final transient List<DecimalFormat> formats = new ArrayList<DecimalFormat>();
    private final transient Map<String, String> stringMap = new WeakHashMap<String, String>();
    private transient double size = 0.0;
    protected final List<AColumnHandler> DATA = new ArrayList<AColumnHandler>();
    private List<String> columns;
    private final AtomicInteger m_ref = new AtomicInteger(0);
    private boolean closed;
    private final List<RowSorter.SortKey> keys = new ArrayList<RowSorter.SortKey>();
    private final DecimalFormat DOUBLE_FORMATTER = this.createDecimalFormat(16);
    private final Map<Integer, DecimalFormat> FORMATTER_CACHE = new HashMap<Integer, DecimalFormat>();
    private final Map<Integer, Map<Integer, Object>> GEO_CACHE = new HashMap<Integer, Map<Integer, Object>>();

    public ResultSetTableModel(ResultSet rs, SQLOptions sqlOptions) throws SQLException {
        this(rs, sqlOptions, e -> {});
    }

    /*
     * Enabled aggressive block sorting
     */
    public ResultSetTableModel(ResultSet rs, SQLOptions sqlOptions, Consumer<Long> rowConsumer) throws SQLException {
        if (rs == null) {
            throw new IllegalArgumentException("Resultset cannot be null");
        }
        ResultSetMetaData md = rs.getMetaData();
        int cols = md.getColumnCount();
        if (cols == 0) {
            return;
        }
        ResultSetTableRenderer renderer = new ResultSetTableRenderer(this);
        this.columns = new ArrayList<String>(cols);
        int i = 0;
        while (i < cols) {
            String name = md.getColumnLabel(i + 1);
            if (name.length() == 0) {
                name = "(column " + (i + 1) + ")";
            }
            this.columns.add(name);
            TableColumnExt tableColumn = new TableColumnExt(i);
            tableColumn.setHeaderValue((Object)("  " + name + "  "));
            tableColumn.setCellRenderer((TableCellRenderer)renderer);
            tableColumn.setIdentifier((Object)name);
            this.tcl.addColumn((TableColumn)tableColumn);
            int nullable = md.isNullable(i + 1);
            this.nullable.put(i, nullable == 0 ? Boolean.FALSE : (nullable == 1 ? Boolean.TRUE : null));
            this.sizes.add(md.getPrecision(i + 1));
            int columnType = md.getColumnType(i + 1);
            String nativeDatatype = md.getColumnTypeName(i + 1).toUpperCase();
            if (nativeDatatype.equalsIgnoreCase("xml")) {
                columnType = 2009;
            }
            this.columnNativeType.add(nativeDatatype);
            switch (columnType) {
                case -5: {
                    this.columnClass.add(FieldType.SQLLONG);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new LongColumnHandler());
                    break;
                }
                case -7: 
                case 16: {
                    this.columnClass.add(FieldType.SQLBOOLEAN);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new IntColumnHandler());
                    break;
                }
                case -6: 
                case 4: 
                case 5: {
                    this.columnClass.add(FieldType.SQLINTEGER);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new IntColumnHandler());
                    break;
                }
                case 2: 
                case 3: {
                    this.columnClass.add(FieldType.SQLFLOAT);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new DoubleColumnHandler());
                    break;
                }
                case -148: 
                case -146: 
                case 6: 
                case 7: 
                case 8: {
                    this.columnClass.add(FieldType.SQLFLOAT);
                    this.scales.add(null);
                    this.DATA.add(new DoubleColumnHandler());
                    break;
                }
                case 91: 
                case 92: 
                case 93: 
                case 2013: 
                case 2014: {
                    this.columnClass.add(FieldType.SQLDATE);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new TimeStampColumnHandler());
                    break;
                }
                case -155: {
                    this.columnClass.add(FieldType.SQLDATEWITHZONE);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new DateTimeOffsetColumnHandler());
                    break;
                }
                case -156: 
                case -145: 
                case -16: 
                case -15: 
                case -9: 
                case -4: 
                case -3: 
                case -2: 
                case -1: 
                case 0: 
                case 1: 
                case 12: 
                case 1111: 
                case 2004: 
                case 2005: 
                case 2011: {
                    this.columnClass.add(FieldType.SQLSTRING);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new StringColumnHandler());
                    break;
                }
                case 2009: {
                    this.columnClass.add(FieldType.SQLXMLSTRING);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new StringColumnHandler());
                    break;
                }
                case -157: {
                    this.columnClass.add(FieldType.SQLGEOMETRY);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new ObjectColumnHandler<byte[]>(byte[].class));
                    break;
                }
                case -158: {
                    this.columnClass.add(FieldType.SQLGEOGRAPHY);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new ObjectColumnHandler<byte[]>(byte[].class));
                    break;
                }
                default: {
                    this.columnClass.add(FieldType.SQLSTRING);
                    this.scales.add(md.getScale(i + 1));
                    this.DATA.add(new StringColumnHandler());
                }
            }
            ++i;
        }
        this.scales.stream().forEachOrdered(l -> {
            DecimalFormat df = null;
            if (l != null && l > 0) {
                df = this.createDecimalFormat((int)l);
            }
            this.formats.add(df);
        });
        long counter = 0L;
        while (rs.next()) {
            if (counter++ % 100L == 99L && sqlOptions.isCancelled()) break;
            if (counter % 10000L == 0L) {
                rowConsumer.accept(counter);
            }
            int i2 = 1;
            while (i2 <= cols) {
                switch (this.columnClass.get(i2 - 1)) {
                    case SQLBOOLEAN: {
                        ((IntColumnHandler)this.DATA.get(i2 - 1)).addRow(rs.getBoolean(i2) ? 1 : 0, rs.wasNull());
                        break;
                    }
                    case SQLINTEGER: {
                        ((IntColumnHandler)this.DATA.get(i2 - 1)).addRow(rs.getInt(i2), rs.wasNull());
                        break;
                    }
                    case SQLLONG: {
                        ((LongColumnHandler)this.DATA.get(i2 - 1)).addRow(rs.getLong(i2), rs.wasNull());
                        break;
                    }
                    case SQLFLOAT: {
                        ((DoubleColumnHandler)this.DATA.get(i2 - 1)).addRow(rs.getDouble(i2), rs.wasNull());
                        break;
                    }
                    case SQLSTRING: 
                    case SQLXMLSTRING: {
                        String s = rs.getString(i2);
                        ((StringColumnHandler)this.DATA.get(i2 - 1)).addRow(s == null || s.length() > 30 ? s : this.stringMap.computeIfAbsent(s, ResultSetTableModel::T));
                        break;
                    }
                    case SQLDATE: {
                        ((TimeStampColumnHandler)this.DATA.get(i2 - 1)).addTimeRow(TimeStampWrapperHandler.get(rs, i2));
                        break;
                    }
                    case SQLGEOMETRY: 
                    case SQLGEOGRAPHY: {
                        ((ObjectColumnHandler)this.DATA.get(i2 - 1)).addRow(rs.getBytes(i2));
                        break;
                    }
                    case SQLDATEWITHZONE: {
                        ((DateTimeOffsetColumnHandler)this.DATA.get(i2 - 1)).addRow(((SQLServerResultSet)rs).getDateTimeOffset(i2));
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unknown SQL-type " + (Object)((Object)this.columnClass.get(i2)) + " detected while fetching column value");
                    }
                }
                ++i2;
            }
        }
        this.postProcessResultSet(rs);
        this.stringMap.clear();
        for (AColumnHandler handler : this.DATA) {
            handler.trimToSize();
            this.size += (double)handler.getByteSize();
        }
        int i3 = 0;
        while (i3 < this.tcl.getColumnCount()) {
            int maxValueI = 0;
            long maxValueL = 0L;
            double maxValueF = 0.0;
            String maxValueS = "";
            String timestampValue = "";
            String geo = "";
            Timestamp maxValueTs = new Timestamp(1L);
            FieldType ft = this.columnClass.get(i3);
            if (ft == FieldType.SQLBOOLEAN) {
                this.columnClass.set(i3, FieldType.SQLINTEGER);
                ft = FieldType.SQLINTEGER;
            }
            int j = 0;
            block44: while (j < Math.min(this.DATA.get(0).getRowCount(), 20)) {
                switch (ft) {
                    case SQLSTRING: 
                    case SQLXMLSTRING: {
                        String val = ((StringColumnHandler)this.DATA.get(i3)).getRowValue(j);
                        if (val == null) break;
                        int newLength = val.length();
                        if (maxValueS.length() >= val.length()) break;
                        if (newLength > 65) {
                            maxValueS = val.substring(0, 65);
                            break block44;
                        }
                        maxValueS = val;
                        break;
                    }
                    case SQLFLOAT: {
                        Double f = ((DoubleColumnHandler)this.DATA.get(i3)).getRowValue(j);
                        if (f == null || String.valueOf(maxValueF).length() >= String.valueOf(f).length()) break;
                        maxValueF = f;
                        break;
                    }
                    case SQLLONG: {
                        Long lValue = ((LongColumnHandler)this.DATA.get(i3)).getRowValue(j);
                        if (lValue == null || String.valueOf(maxValueI).length() >= String.valueOf(lValue).length()) break;
                        maxValueL = lValue;
                        break;
                    }
                    case SQLINTEGER: 
                    case SQLBOOLEAN: {
                        Integer iValue = ((IntColumnHandler)this.DATA.get(i3)).getRowValue(j);
                        if (iValue == null || String.valueOf(maxValueI).length() >= String.valueOf(iValue).length()) break;
                        maxValueI = iValue;
                        break;
                    }
                    case SQLDATE: 
                    case SQLDATEWITHZONE: {
                        if (ft == FieldType.SQLDATEWITHZONE) {
                            Timestamp ts;
                            DateTimeOffset ds = ((DateTimeOffsetColumnHandler)this.DATA.get(i3)).getRowValue(j);
                            if (ds == null || !ResultSetTableModel.containsTimeInfo(ts = ds.getTimestamp())) break;
                            maxValueTs = ts;
                            break block44;
                        }
                        Object o = ((TimeStampColumnHandler)this.DATA.get(i3)).getRowValue(j);
                        if (o == null || !TimeStampWrapperHandler.containsTimeInfo(o)) break;
                        timestampValue = TimeStampWrapperHandler.getValue(o);
                        break block44;
                    }
                    case SQLGEOMETRY: 
                    case SQLGEOGRAPHY: {
                        byte[] ixValue = (byte[])((ObjectColumnHandler)this.DATA.get(i3)).getValue(j);
                        if (ixValue == null) break;
                        String geoX = StringUtils.bytesToHex(ixValue);
                        int newLengthGeo = geoX.length();
                        if (geo.length() >= geoX.length()) break;
                        if (newLengthGeo > 65) {
                            geoX = geoX.substring(0, 65);
                            break block44;
                        }
                        geo = geoX;
                    }
                }
                ++j;
            }
            TableColumnExt tc = this.tcl.getColumnExt(i3);
            switch (ft) {
                case SQLDATE: {
                    tc.setPrototypeValue((Object)timestampValue);
                }
                case SQLDATEWITHZONE: {
                    tc.setPrototypeValue((Object)maxValueTs);
                    break;
                }
                case SQLFLOAT: {
                    tc.setPrototypeValue((Object)maxValueF);
                    break;
                }
                case SQLLONG: {
                    tc.setPrototypeValue((Object)maxValueL);
                    break;
                }
                case SQLINTEGER: 
                case SQLBOOLEAN: {
                    tc.setPrototypeValue((Object)maxValueI);
                    break;
                }
                case SQLGEOMETRY: 
                case SQLGEOGRAPHY: {
                    tc.setPrototypeValue((Object)geo);
                    break;
                }
                default: {
                    tc.setPrototypeValue((Object)maxValueS);
                }
            }
            tc.setToolTipText(this.getColumnType(i3));
            ++i3;
        }
    }

    public Boolean isNullable(int column) {
        return this.nullable.get(column);
    }

    protected void postProcessResultSet(ResultSet rs) throws SQLException {
        rs.close();
    }

    private static <T> T T(T T) {
        return T;
    }

    @Override
    public IResultSetTable getSelectedSnapshot() {
        return new SelectedResultSetTable(this);
    }

    private DecimalFormat createDecimalFormat(int scale) {
        char[] x = new char[scale];
        Arrays.fill(x, '#');
        return new DecimalFormat("#." + new String(x), new DecimalFormatSymbols(Locale.US));
    }

    @Override
    public DecimalFormat getFormatForColumn(int column) {
        return this.formats.get(column);
    }

    private static boolean containsTimeInfo(Timestamp ts) {
        return ts.getNanos() != 0 || ts.getSeconds() != 0 && ts.getMinutes() != 0 && ts.getHours() != 0;
    }

    public TableColumnModel getTableColumnModel() {
        return this.tcl;
    }

    public ListSelectionModel getTableRowSelectionModel() {
        return this.lsm;
    }

    @Override
    public FieldType getFieldType(int column) {
        return this.columnClass.get(column);
    }

    @Override
    public Integer getScale(int column) {
        return this.scales.get(column);
    }

    void setSorting(List<? extends RowSorter.SortKey> sortKeys) {
        int col;
        if (sortKeys == null) {
            sortKeys = new ArrayList<RowSorter.SortKey>();
        }
        if (this.keys.equals(sortKeys)) {
            return;
        }
        ArrayList<Integer> keys = new ArrayList<Integer>();
        for (RowSorter.SortKey sortKey : sortKeys) {
            col = sortKey.getColumn();
            this.DATA.get(col).setSorting(sortKey.getSortOrder() != SortOrder.UNSORTED);
            keys.add(col);
        }
        for (RowSorter.SortKey sortKey : this.keys) {
            col = sortKey.getColumn();
            if (keys.contains(col)) continue;
            this.DATA.get(col).setSorting(false);
        }
        this.keys.clear();
        this.keys.addAll(sortKeys);
    }

    @Override
    public boolean isCellEditable(int row, int column) {
        return false;
    }

    @Override
    public Class<?> getColumnClass(int columnIndex) {
        return this.columnClass.get(columnIndex).getType();
    }

    @Override
    public int getSize(int column) {
        return this.sizes.get(column);
    }

    @Override
    public String getColumnName(int i) {
        return this.columns.get(i);
    }

    @Override
    public String getColumnType(int column) {
        String str = this.columnNativeType.get(column);
        if (str == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder(str);
        Integer sz = this.sizes.get(column);
        Integer scale = this.scales.get(column);
        FieldType fieldType = this.getFieldType(column);
        if (!(ListUtils.in((Object)((Object)fieldType), (Object[])new FieldType[]{FieldType.SQLBOOLEAN, FieldType.SQLINTEGER, FieldType.SQLLONG}) || sz == null || sz.equals(0) || str.equalsIgnoreCase("FLOAT") || str.equalsIgnoreCase("DATETIME"))) {
            if (fieldType == FieldType.SQLSTRING) {
                sb.append("(");
                if (sz >= 8000) {
                    sb.append("MAX");
                } else {
                    sb.append(sz);
                }
                sb.append(")");
            } else if (fieldType == FieldType.SQLFLOAT) {
                sb.append("(");
                sb.append(sz);
                if (scale != null && !scale.equals(0)) {
                    sb.append(",").append(scale);
                }
                sb.append(")");
            } else {
                sb.append(", column size = " + sz);
                if (scale != null && !scale.equals(0)) {
                    sb.append(", column scale = " + scale);
                }
            }
        }
        return sb.toString();
    }

    @Override
    public Object getValueAt(int row, int column) {
        switch (this.getFieldType(column)) {
            case SQLDATE: {
                return TimeStampWrapperHandler.getFromObject(this.DATA.get(column).getValue(row));
            }
            case SQLGEOMETRY: 
            case SQLGEOGRAPHY: {
                byte[] value = (byte[])this.DATA.get(column).getValue(row);
                if (value == null) {
                    return null;
                }
                Map cache = this.GEO_CACHE.computeIfAbsent(row, r -> new HashMap());
                Object g = cache.get(column);
                if (g == null) {
                    try {
                        g = this.getFieldType(column) == FieldType.SQLGEOMETRY ? Geometry.deserialize((byte[])value) : Geography.deserialize((byte[])value);
                        cache.put(column, g);
                    }
                    catch (SQLServerException e) {
                        g = StringUtils.bytesToHex(value);
                        cache.put(column, g);
                    }
                }
                return g;
            }
        }
        return this.DATA.get(column).getValue(row);
    }

    @Override
    public String getValueForDisplay(int row, int column) {
        Object v = this.getValueAt(row, column);
        if (v == null) {
            return null;
        }
        FieldType type = null;
        if (column >= 0) {
            type = this.getFieldType(column);
        }
        if (type == null) {
            return v.toString();
        }
        if (type == FieldType.SQLDATE) {
            return TimeStampWrapperHandler.getValue(v);
        }
        if (type != FieldType.SQLFLOAT || !(v instanceof Double)) {
            return v.toString();
        }
        double value = (Double)v;
        if (value % 1.0 == 0.0) {
            return String.format("%.0f", value);
        }
        if (this.getScale(column) != null && this.getScale(column) > 0) {
            if (this.formats.size() > 0) {
                return this.getFormatForColumn(column).format(value);
            }
            return this.FORMATTER_CACHE.computeIfAbsent(this.getScale(column), e -> this.createDecimalFormat((int)e)).format(value);
        }
        return this.DOUBLE_FORMATTER.format(value);
    }

    @Override
    public void setValueAt(Object aValue, int row, int column) {
        throw new NotImplementedException("Read only!");
    }

    public RowSorter getSorter() {
        return this.sorter;
    }

    public void setSorter(RowSorter sorter) {
        this.sorter = sorter;
    }

    @Override
    public String getIdentifier() {
        return this.UUID;
    }

    public double getSize() {
        return this.size;
    }

    @Override
    public int getColumnCount() {
        return this.columns.size();
    }

    @Override
    public int getRowCount() {
        return this.DATA.get(0).getRowCount();
    }

    private void closeColumns() throws IOException {
        for (AColumnHandler ch : this.DATA) {
            ch.close();
        }
    }

    @Override
    public void close() throws IOException {
        this.closed = true;
        if (this.m_ref.get() > 0) {
            return;
        }
        this.closeColumns();
    }

    @Override
    public synchronized void AddRef() {
        this.m_ref.incrementAndGet();
    }

    @Override
    public synchronized void Release() {
        if (this.m_ref.decrementAndGet() <= 0 && this.closed) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

