/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.results;

import com.sigge.filerunner.view.results.IResultSetConverter;
import com.sigge.filerunner.view.results.IResultSetTable;

public abstract class AResultSetConverter
implements IResultSetConverter<StringBuilder> {
    @Override
    public StringBuilder convert(IResultSetTable rstm) {
        StringBuilder sb = new StringBuilder();
        this.preHeader(sb, rstm.getColumnCount());
        this.preFirstColumn(sb);
        int col = 0;
        while (col < rstm.getColumnCount()) {
            String colName = rstm.getColumnName(col);
            this.columnHeader(sb, col, rstm.getColumnCount(), colName);
            ++col;
        }
        this.afterLastColumn(sb);
        this.postHeader(sb, rstm.getColumnCount());
        this.beforeFirstRow(sb);
        int row = 0;
        while (row < rstm.getRowCount()) {
            this.rowStart(sb);
            int col2 = 0;
            while (col2 < rstm.getColumnCount()) {
                String value = rstm.getValueForDisplay(row, col2);
                this.row(sb, row, col2, value);
                this.rowColumn(sb, col2 + 1 == rstm.getColumnCount());
                ++col2;
            }
            this.postRow(sb, row + 1 == rstm.getRowCount());
            ++row;
        }
        this.afterLastRow(sb);
        this.finish(sb);
        return sb;
    }

    protected void preHeader(StringBuilder sb, int colcount) {
    }

    protected void preFirstColumn(StringBuilder sb) {
    }

    protected abstract void columnHeader(StringBuilder var1, int var2, int var3, String var4);

    protected void afterLastColumn(StringBuilder sb) {
    }

    protected void postHeader(StringBuilder sb, int colcount) {
    }

    protected void beforeFirstRow(StringBuilder sb) {
    }

    protected abstract void rowStart(StringBuilder var1);

    protected abstract void row(StringBuilder var1, int var2, int var3, String var4);

    protected void rowColumn(StringBuilder sb, boolean last) {
    }

    protected abstract void postRow(StringBuilder var1, boolean var2);

    protected void afterLastRow(StringBuilder sb) {
    }

    protected void finish(StringBuilder sb) {
    }
}

