/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.gson.JsonArray;
import com.google.inject.Singleton;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.core.StoreItem;
import com.sigge.filerunner.recent.ItemStorer;
import com.sigge.filerunner.recent.RecentFilter;
import com.sigge.filerunner.recent.RecentItemManager;
import com.sigge.filerunner.recent.RecentItemStorer;
import com.sigge.filerunner.view.menu.IMenu;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;

@Singleton
public class RecentMenuHandler {
    private final RecentItemManager<File, RecentFilter> recentItems;
    private final List<IMenu.ChangeListener> listeners = new ArrayList<IMenu.ChangeListener>();
    private final ItemStorer<File, RecentFilter> storer = this.createStorer();

    RecentMenuHandler() {
        this.recentItems = new RecentItemManager<File, RecentFilter>(10, this.storer);
    }

    private ItemStorer<File, RecentFilter> createStorer() {
        RecentItemStorer storer = null;
        try {
            File f = new File("db");
            if (!f.exists()) {
                f.mkdir();
            }
            storer = new RecentItemStorer("db/recent.db");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return storer;
    }

    public void initializeList() {
        List<String> files = ConfigHandler.getConfig().getListValues("recentMenu.files");
        Collections.reverse(files);
        this.recentItems.setItems(files.stream().map(l -> new File((String)l)).collect(Collectors.toList()));
        this.createMenu();
    }

    public void openFile(File file) {
        boolean result = this.recentItems.newItem(file);
        if (result) {
            this.createMenu();
        }
    }

    private void createMenu() {
        List<File> items = this.recentItems.items();
        JsonArray js = new JsonArray();
        items.stream().forEachOrdered(i -> js.add(i.getAbsolutePath()));
        ConfigHandler.getConfig().setConfigValue("recentMenu.files", js);
        this.listeners.forEach(l -> {
            if (l != null) {
                l.changed(null);
            }
        });
    }

    public List<StoreItem<File>> getHistoryItems() {
        return this.recentItems.recents();
    }

    public List<File> getItems() {
        return this.recentItems.items();
    }

    public void addListener(IMenu.ChangeListener item) {
        this.listeners.add(item);
        this.createMenu();
    }

    public ItemStorer<File, RecentFilter> getStorer() {
        return this.storer;
    }
}

