/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.name.Named;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.IMenuComponent;
import com.sigge.filerunner.view.menu.IMenuItem;
import com.sigge.filerunner.view.menu.IMenuItemGroup;
import com.sigge.filerunner.view.menu.IMenuRebuilder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import javax.swing.Action;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.KeyStroke;

public class MenuBuilder
implements IMenu.ChangeListener,
IMenuRebuilder {
    private final JMenuBar mb;
    private final List<IMenu> menus = new ArrayList<IMenu>();
    private final JFrame mainFrame;

    @Inject
    public MenuBuilder(@Named(value="mainFrame") JFrame mainFrame, Set<IMenu> menus) {
        this.mainFrame = mainFrame;
        this.mb = new JMenuBar();
        this.regenerate(menus, true);
        mainFrame.setJMenuBar(this.mb);
    }

    private void regenerate(Collection<IMenu> menuSet, boolean init) {
        this.mb.removeAll();
        this.clearCustomActions();
        for (IMenu menu : menuSet.stream().sorted(Comparator.comparing(k -> k.getType())).collect(Collectors.toList())) {
            this.mb.add(this.buildFromMenu(menu));
            if (!init) continue;
            this.menus.add(menu);
            menu.addChangeListener(this);
        }
        this.mainFrame.setJMenuBar(this.mb);
        this.mb.revalidate();
    }

    private void clearCustomActions() {
        InputMap im = this.mainFrame.getRootPane().getInputMap(1);
        ActionMap am = this.mainFrame.getRootPane().getActionMap();
        KeyStroke[] keys = im.keys();
        if (keys == null) {
            return;
        }
        int i = keys.length - 1;
        while (i >= 0) {
            KeyStroke key = keys[i];
            Object o = im.get(key);
            if (o != null && o instanceof String && ((String)o).startsWith("#hidden")) {
                am.put(key, null);
                im.put(key, null);
            }
            --i;
        }
    }

    private void addAction(Action a) {
        KeyStroke keyStroke = (KeyStroke)a.getValue("AcceleratorKey");
        if (keyStroke == null) {
            return;
        }
        InputMap im = this.mainFrame.getRootPane().getInputMap(1);
        ActionMap am = this.mainFrame.getRootPane().getActionMap();
        im.put(keyStroke, "#hidden" + a.getValue("Name"));
        am.put("#hidden" + a.getValue("Name"), a);
    }

    private JMenu buildFromMenu(IMenu menu) {
        JMenu jm = new JMenu(menu.getType().getCaption());
        AtomicInteger cnt = new AtomicInteger(0);
        AtomicBoolean prevIsAGroup = new AtomicBoolean(false);
        for (IMenuComponent comp : menu.getComponents()) {
            this.buildFromComponent(jm, comp, prevIsAGroup, cnt);
        }
        return jm;
    }

    private void buildFromComponent(JMenu jm, IMenuComponent component, AtomicBoolean prevIsAGroup, AtomicInteger cnt) {
        boolean previousWasGroup = prevIsAGroup.get();
        if (previousWasGroup) {
            if (cnt.get() != 0) {
                jm.addSeparator();
            }
            prevIsAGroup.set(false);
        }
        if (component instanceof IMenuItem) {
            IMenuItem comp = (IMenuItem)component;
            JMenuItem jMenuItem = comp.getItem();
            if (!jMenuItem.isVisible()) {
                this.addAction(jMenuItem.getAction());
                return;
            }
            jm.add(jMenuItem);
            cnt.addAndGet(1);
            AtomicInteger count = new AtomicInteger(0);
            AtomicBoolean prev = new AtomicBoolean(false);
            if (comp.subItems().size() > 0) {
                JMenu item = (JMenu)jMenuItem;
                item.removeAll();
                for (IMenuItemGroup group : comp.subItems()) {
                    this.buildFromComponent(item, group, prev, count);
                }
            }
        } else {
            IMenuItemGroup comp = (IMenuItemGroup)component;
            if (!previousWasGroup && cnt.get() > 0) {
                jm.addSeparator();
            }
            for (IMenuItem itemz : comp.getContents()) {
                this.buildFromComponent(jm, itemz, prevIsAGroup, cnt);
            }
            prevIsAGroup.set(true);
        }
    }

    @Override
    public void changed(IMenu menu) {
        this.mb.removeAll();
        this.regenerate(this.menus, false);
        this.mb.revalidate();
    }

    @Override
    public void rebuild() {
        this.regenerate(this.menus, false);
    }
}

