/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.menu;

import com.google.inject.Inject;
import com.google.inject.Provider;
import com.google.inject.Singleton;
import com.sigge.filerunner.action.MenuAction;
import com.sigge.filerunner.commands.AdvanceEditorCommands;
import com.sigge.filerunner.commands.EditorCommands;
import com.sigge.filerunner.commands.NextOccurancesAction;
import com.sigge.filerunner.commands.PreviousOccurancesAction;
import com.sigge.filerunner.commands.ShiftLeftElementAction;
import com.sigge.filerunner.commands.ShiftRightElementAction;
import com.sigge.filerunner.commands.TabCommands;
import com.sigge.filerunner.config.ConfigHandler;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.menu.IMenu;
import com.sigge.filerunner.view.menu.IMenuItem;
import com.sigge.filerunner.view.menu.IMenuItemGroup;
import com.sigge.filerunner.view.menu.Menu;
import com.sigge.filerunner.view.menu.MenuItem;
import com.sigge.filerunner.view.menu.MenuItemGroup;
import com.sigge.filerunner.view.menu.MenuType;
import com.sigge.filerunner.view.search.FindNextAction;
import com.sigge.filerunner.view.search.GoToLineAction;
import com.sigge.filerunner.view.search.ShowFindDialogAction;
import com.sigge.filerunner.view.search.ShowReplaceDialogAction;
import com.siggemannen.core.MapBuilder;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.swing.JMenu;

@Singleton
public class EditMenu
implements Provider<IMenu> {
    private final EditorCommands.CopyAction copyAction;
    private final EditorCommands.CutAction cutAction;
    private final EditorCommands.PasteAction pasteAction;
    private final EditorCommands.SpecialPasteAction specialPasteAction;
    private final EditorCommands.ChangeDatabaseAction cdbAction;
    private final EditorCommands.PasteHistoryAction pasteHistoryActon;
    private final EditorCommands.UndoAction undo;
    private final EditorCommands.RedoAction redo;
    private final GoToLineAction gotoAction;
    private final ShowFindDialogAction findDialogAction;
    private final ShowReplaceDialogAction replaceDialogAction;
    private final FindNextAction findNextAction;
    private final AdvanceEditorCommands.UppercaseSelectionAction uppercaseSelectionAction;
    private final AdvanceEditorCommands.LowercaseSelectionAction lowercaseSelectionAction;
    private final AdvanceEditorCommands.SwitchExpressionAction switchEqualsAction;
    private final AdvanceEditorCommands.ToggleCommentsAction toggleCommentsAction;
    private final AdvanceEditorCommands.MultilineCommentAction multilineCommentAction;
    private final AdvanceEditorCommands.KeywordsFormatterAction formatterAction;
    private final TabCommands.CloseCurrentTab closeTab;
    private final TabCommands.RemoveOthers removeOthers;
    private final TabCommands.RemoveLeft removeLeft;
    private final TabCommands.RemoveRight removeRight;
    private final TabCommands.RemoveAll removeAll;
    private final AdvanceEditorCommands.InsertSnippetAction insertSnippetAction;
    private final AdvanceEditorCommands.MarkSQLClauseAction markSQLAction;
    private final AdvanceEditorCommands.GotoDeclarationAction gotoDeclaration;
    private final PreviousOccurancesAction prevAction;
    private final NextOccurancesAction nextOccuranceAction;
    private final TabCommands.FreezeTab freezeTab;
    private ShiftLeftElementAction shiftLeftAction;
    private ShiftRightElementAction shiftRightAction;

    @Inject
    EditMenu(EditorCommands.CopyAction copyAction, EditorCommands.CutAction cutAction, EditorCommands.PasteAction pasteAction, EditorCommands.SpecialPasteAction specialPasteAction, EditorCommands.ChangeDatabaseAction cdbAction, EditorCommands.PasteHistoryAction pasteHistoryActon, EditorCommands.UndoAction undo, EditorCommands.RedoAction redo, GoToLineAction gotoAction, ShowFindDialogAction findDialogAction, ShowReplaceDialogAction replaceDialogAction, FindNextAction findNextAction, AdvanceEditorCommands.UppercaseSelectionAction uppercaseSelectionAction, AdvanceEditorCommands.LowercaseSelectionAction lowercaseSelectionAction, AdvanceEditorCommands.SwitchExpressionAction switchEqualsAction, AdvanceEditorCommands.ToggleCommentsAction toggleCommentsAction, AdvanceEditorCommands.MultilineCommentAction multilineCommentAction, AdvanceEditorCommands.KeywordsFormatterAction formatterAction, AdvanceEditorCommands.InsertSnippetAction insertSnippetAction, TabCommands.CloseCurrentTab closeTab, TabCommands.RemoveOthers removeOthers, TabCommands.RemoveLeft removeLeft, TabCommands.RemoveRight removeRight, TabCommands.RemoveAll removeAll, AdvanceEditorCommands.MarkSQLClauseAction markSQLAction, AdvanceEditorCommands.GotoDeclarationAction gotoDeclaration, PreviousOccurancesAction prevAction, NextOccurancesAction nextOccuranceAction, TabCommands.FreezeTab freezeTab, ShiftLeftElementAction shiftLeftAction, ShiftRightElementAction shiftRightAction) {
        this.copyAction = copyAction;
        this.cutAction = cutAction;
        this.pasteAction = pasteAction;
        this.specialPasteAction = specialPasteAction;
        this.cdbAction = cdbAction;
        this.pasteHistoryActon = pasteHistoryActon;
        this.undo = undo;
        this.redo = redo;
        this.gotoAction = gotoAction;
        this.findDialogAction = findDialogAction;
        this.replaceDialogAction = replaceDialogAction;
        this.findNextAction = findNextAction;
        this.uppercaseSelectionAction = uppercaseSelectionAction;
        this.lowercaseSelectionAction = lowercaseSelectionAction;
        this.switchEqualsAction = switchEqualsAction;
        this.toggleCommentsAction = toggleCommentsAction;
        this.multilineCommentAction = multilineCommentAction;
        this.formatterAction = formatterAction;
        this.insertSnippetAction = insertSnippetAction;
        this.closeTab = closeTab;
        this.removeOthers = removeOthers;
        this.removeLeft = removeLeft;
        this.removeRight = removeRight;
        this.removeAll = removeAll;
        this.markSQLAction = markSQLAction;
        this.gotoDeclaration = gotoDeclaration;
        this.prevAction = prevAction;
        this.nextOccuranceAction = nextOccuranceAction;
        this.freezeTab = freezeTab;
        this.shiftLeftAction = shiftLeftAction;
        this.shiftRightAction = shiftRightAction;
    }

    public IMenu get() {
        Menu menu = new Menu(MenuType.EDIT);
        ArrayList<Map> groups = new ArrayList<Map>();
        LinkedHashMap<String, MenuAction> copypasteActions = new LinkedHashMap<String, MenuAction>();
        copypasteActions.put(this.copyAction.id(), new MenuAction("Copy", IconUtils.getSmallIcon("copy.png"), (Integer)67, ConfigHandler.getForCommand(this.copyAction, null), this.copyAction::actionPerformed));
        copypasteActions.put(this.cutAction.id(), new MenuAction("Cut", IconUtils.getSmallIcon("cut.png"), (Integer)88, ConfigHandler.getForCommand(this.cutAction, null), this.cutAction::actionPerformed));
        copypasteActions.put(this.pasteAction.id(), new MenuAction("Paste", IconUtils.getSmallIcon("paste.png"), (Integer)86, ConfigHandler.getForCommand(this.pasteAction, null), this.pasteAction::actionPerformed));
        copypasteActions.put(this.specialPasteAction.id(), new MenuAction("Paste special", null, (Integer)80, ConfigHandler.getForCommand(this.specialPasteAction, null), this.specialPasteAction::actionPerformed));
        copypasteActions.put(this.pasteHistoryActon.id(), new MenuAction("Paste history", null, (Integer)72, ConfigHandler.getForCommand(this.pasteHistoryActon, null), this.pasteHistoryActon::actionPerformed));
        MenuAction undoAction = new MenuAction("Undo", IconUtils.getSmallIcon("undo.png"), null, ConfigHandler.getForCommand(this.undo, null), this.undo::actionPerformed);
        MenuAction redoAction = new MenuAction("Redo", IconUtils.getSmallIcon("redo.png"), null, ConfigHandler.getForCommand(this.redo, null), this.redo::actionPerformed);
        LinkedHashMap<String, MenuAction> doMap = new LinkedHashMap<String, MenuAction>();
        doMap.put(this.undo.id(), undoAction);
        doMap.put(this.redo.id(), redoAction);
        groups.add(doMap);
        groups.add(copypasteActions);
        LinkedHashMap<String, MenuAction> findMap = new LinkedHashMap<String, MenuAction>();
        findMap.put(this.gotoAction.id(), new MenuAction("Go To Line...", IconUtils.getSmallIcon("goto.png"), null, ConfigHandler.getForCommand(this.gotoAction, null), this.gotoAction::actionPerformed));
        findMap.put(this.findDialogAction.id(), new MenuAction("Find...", IconUtils.getSmallIcon("find.png"), null, ConfigHandler.getForCommand(this.findDialogAction, null), this.findDialogAction::actionPerformed));
        findMap.put(this.replaceDialogAction.id(), new MenuAction("Replace...", IconUtils.getSmallIcon("replace.png"), null, ConfigHandler.getForCommand(this.replaceDialogAction, null), this.replaceDialogAction::actionPerformed));
        findMap.put(this.findNextAction.id(), new MenuAction("Find next...", IconUtils.getSmallIcon("find_next.png"), null, ConfigHandler.getForCommand(this.findNextAction, null), this.findNextAction::actionPerformed));
        groups.add(findMap);
        LinkedHashMap<String, MenuAction> advancedCommands = new LinkedHashMap<String, MenuAction>();
        advancedCommands.put(this.uppercaseSelectionAction.id(), new MenuAction("Uppercase selection", IconUtils.getSmallIcon("arrow_up_green.png"), (Integer)85, ConfigHandler.getForCommand(this.uppercaseSelectionAction, null), this.uppercaseSelectionAction::actionPerformed));
        advancedCommands.put(this.lowercaseSelectionAction.id(), new MenuAction("Lowercase selection", IconUtils.getSmallIcon("arrow_down_green.png"), (Integer)76, ConfigHandler.getForCommand(this.lowercaseSelectionAction, null), this.lowercaseSelectionAction::actionPerformed));
        advancedCommands.put(this.toggleCommentsAction.id(), new MenuAction("Toggle comments", null, null, ConfigHandler.getForCommand(this.toggleCommentsAction, null), this.toggleCommentsAction::actionPerformed));
        advancedCommands.put(this.multilineCommentAction.id(), new MenuAction("Multiline comment", null, null, ConfigHandler.getForCommand(this.multilineCommentAction, null), this.multilineCommentAction::actionPerformed));
        advancedCommands.put(this.insertSnippetAction.id(), new MenuAction("Insert snippet...", IconUtils.getSmallIcon("star_yellow_add.png"), (Integer)70, ConfigHandler.getForCommand(this.insertSnippetAction, null), this.insertSnippetAction::actionPerformed));
        groups.add(advancedCommands);
        MenuAction changeDbAction = new MenuAction("Change database", IconUtils.getSmallIcon("data_next.png"), (Integer)71, ConfigHandler.getForCommand(this.cdbAction, null), this.cdbAction);
        groups.add(new MapBuilder().append((Object)this.cdbAction.id(), (Object)changeDbAction).build());
        this.cdbAction.addListener(() -> changeDbAction.setEnabled(this.cdbAction.isEnabled()));
        for (Map map : groups) {
            menu.addItemGroup(new MenuItemGroup(map.values().stream().map(MenuItem::new).collect(Collectors.toList())), 0);
        }
        LinkedHashMap<String, MenuAction> sqlCommands = new LinkedHashMap<String, MenuAction>();
        sqlCommands.put(this.formatterAction.id(), new MenuAction("Format keywords", null, (Integer)70, ConfigHandler.getForCommand(this.formatterAction, null), this.formatterAction::actionPerformed));
        sqlCommands.put(this.markSQLAction.id(), new MenuAction("Mark whole statement", null, null, ConfigHandler.getForCommand(this.markSQLAction, null), this.markSQLAction::actionPerformed));
        sqlCommands.put(this.gotoDeclaration.id(), new MenuAction("Goto variable declaration", null, null, ConfigHandler.getForCommand(this.gotoDeclaration, null), this.gotoDeclaration::actionPerformed));
        sqlCommands.put(this.prevAction.id(), new MenuAction("Previous variable occurance", null, null, ConfigHandler.getForCommand(this.prevAction, null), this.prevAction::actionPerformed));
        sqlCommands.put(this.nextOccuranceAction.id(), new MenuAction("Next variable occurance", null, null, ConfigHandler.getForCommand(this.nextOccuranceAction, null), this.nextOccuranceAction::actionPerformed));
        sqlCommands.put(this.switchEqualsAction.id(), new MenuAction("Switch expressions around =", IconUtils.getSmallIcon("replace2.png"), null, ConfigHandler.getForCommand(this.switchEqualsAction, null), this.switchEqualsAction::actionPerformed));
        sqlCommands.put(this.shiftLeftAction.id(), new MenuAction("Shift left", null, null, ConfigHandler.getForCommand(this.shiftLeftAction, null), this.shiftLeftAction::actionPerformed));
        sqlCommands.put(this.shiftRightAction.id(), new MenuAction("Shift right", null, null, ConfigHandler.getForCommand(this.shiftRightAction, null), this.shiftRightAction::actionPerformed));
        ArrayList<IMenuItemGroup> groupList = new ArrayList<IMenuItemGroup>();
        MenuItemGroup sqGroup = new MenuItemGroup(sqlCommands.values().stream().map(MenuItem::new).collect(Collectors.toList()));
        groupList.add(sqGroup);
        MenuItem sqlCommandMenu = new MenuItem(new JMenu("SQL Commands"), groupList);
        menu.addItem(sqlCommandMenu, 1);
        ArrayList<IMenuItemGroup> tabCommands = new ArrayList<IMenuItemGroup>();
        MenuItem mu = new MenuItem(new JMenu("Tab Commands"), tabCommands);
        ArrayList<IMenuItem> contents = new ArrayList<IMenuItem>();
        contents.add(new MenuItem(new MenuAction("Close current tab", null, null, ConfigHandler.getForCommand(this.closeTab, null), this.closeTab::actionPerformed)));
        contents.add(new MenuItem(new MenuAction("Remove others", null, null, ConfigHandler.getForCommand(this.removeOthers, null), this.removeOthers::actionPerformed)));
        contents.add(new MenuItem(new MenuAction("Remove left", null, null, ConfigHandler.getForCommand(this.removeLeft, null), this.removeLeft::actionPerformed)));
        contents.add(new MenuItem(new MenuAction("Remove right", null, null, ConfigHandler.getForCommand(this.removeRight, null), this.removeRight::actionPerformed)));
        contents.add(new MenuItem(new MenuAction("Remove all", null, null, ConfigHandler.getForCommand(this.removeAll, null), this.removeAll::actionPerformed)));
        MenuItemGroup mg = new MenuItemGroup(contents);
        tabCommands.add(mg);
        MenuItemGroup tabGroup = new MenuItemGroup(new MenuItem(new MenuAction("Freeze tab", null, null, ConfigHandler.getForCommand(this.freezeTab, null), this.freezeTab::actionPerformed)));
        tabCommands.add(tabGroup);
        menu.addItem(mu, 2);
        return menu;
    }
}

