/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.StringUtils;
import com.sigge.filerunner.view.ColorUtils;
import com.sigge.filerunner.view.IconUtils;
import com.sigge.filerunner.view.core.ILabel;
import com.sigge.filerunner.view.core.VTableCellRenderer;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.JobViewModel;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTable;

public class JobServerRenderer
extends VTableCellRenderer {
    private JobViewModel model;
    private ImageIcon defaultImage;
    private ImageIcon defaultDisabledImage;

    public JobServerRenderer(JobViewModel model) {
        this.model = model;
        this.defaultImage = IconUtils.getSmallIcon("schedule.png");
        this.defaultDisabledImage = IconUtils.getSmallIcon("schedule_disabled.png");
        this.putClientProperty("html.disable", Boolean.FALSE);
    }

    @Override
    public JLabel getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        ILabel job = null;
        try {
            job = (IJob)this.model.getValueAt(table.convertRowIndexToModel(row));
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (job != null) {
            this.setText(job.getLabel());
            if (StringUtils.isNotEmpty(job.getIcon())) {
                this.setIcon(IconUtils.getSmallIcon(job.getIcon()));
            } else {
                this.setIcon(job.isEnabled() ? this.defaultImage : this.defaultDisabledImage);
            }
            if (job.getColor() != null) {
                this.setText("<html>" + ColorUtils.getColorBlobFromColor(job.getColor()) + this.getText());
            }
        }
        return this;
    }
}

