/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.activity.ObjectMonitor;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.sigge.filerunner.view.jobs.JobServerAddView;
import com.sigge.filerunner.view.jobs.JobServerEditModel;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.Binder;
import java.awt.Component;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.table.TableModel;

public class JobServerEditor {
    private final JFrame mainFrame;

    public JobServerEditor(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void edit(List<IJobServerManager> managers, List<ObjectMonitor<IJobServer>> servers) {
        ArrayList deletedServers = new ArrayList();
        ArrayList addedServers = new ArrayList();
        JobServerAddView jv = new JobServerAddView();
        JMemoryDialog jd = new JMemoryDialog(this.mainFrame, "Job server editor", true, "job-server-editor");
        jd.getContentPane().add(jv);
        jd.pack();
        jd.setLocationRelativeTo(this.mainFrame == null ? new JFrame() : new JFrame(this.mainFrame.getGraphicsConfiguration()));
        JobServerEditModel jem = new JobServerEditModel();
        jem.setColumns(Arrays.asList("Monitor", "Job server name", "Refresh rate"));
        ArrayList serversForEdit = new ArrayList();
        servers.forEach(c -> {
            ObjectMonitor<IJobServer> monitor = new ObjectMonitor<IJobServer>((ObjectMonitor<IJobServer>)c, (IJobServer)((IJobServer)c.getObject()).createCopy());
            serversForEdit.add(monitor);
        });
        jem.setRows(serversForEdit);
        jv.jobServersTable.setModel((TableModel)((Object)jem));
        Binder.bindToCombo((JComboBox)jv.jobTypeCombo, managers);
        jv.jobTypeCombo.setRenderer(new LabelledCellRenderer(true));
        jv.addServerButton.setEnabled(managers.size() > 0);
        ValueHolder serverHolder = new ValueHolder();
        ArrayList<Component> components = new ArrayList<Component>();
        int i = 0;
        while (i < jv.getComponentCount()) {
            components.add(jv.getComponent(i));
            ++i;
        }
        jv.addServerButton.addActionListener(al -> {
            IJobServerManager manager = (IJobServerManager)jobServerAddView.jobTypeCombo.getSelectedItem();
            if (manager == null) {
                return;
            }
            int i = jv.getComponentCount() - 1;
            while (i >= 0) {
                Component c = jv.getComponent(i);
                if (!components.contains(c)) {
                    jv.remove(c);
                    break;
                }
                --i;
            }
            serverHolder.accept(manager.addJobServer(jv));
            jobServerAddView.saveServerButton.setEnabled(serverHolder.getValue() != null);
        });
        jv.saveServerButton.setEnabled(serverHolder.getValue() != null);
        jv.saveServerButton.addActionListener(al -> {
            IJobServer value = (IJobServer)serverHolder.getValue();
            ObjectMonitor<IJobServer> e = new ObjectMonitor<IJobServer>(value);
            jem.addRow(e);
            addedServers.add(e);
        });
        jv.deleteServerButton.addActionListener(al -> {
            if (JOptionPane.showConfirmDialog((Component)((Object)jd), "Do you want to delete selected job(s)?", "Confirm deletion", 0, 3) == 0) {
                ArrayList<ObjectMonitor> jobs = new ArrayList<ObjectMonitor>();
                int[] nArray = jobServerAddView.jobServersTable.getSelectedRows();
                int n = nArray.length;
                int n2 = 0;
                while (n2 < n) {
                    int i = nArray[n2];
                    int modelFromRow = jobServerAddView.jobServersTable.convertRowIndexToModel(i);
                    ObjectMonitor monitor = (ObjectMonitor)((JobServerEditModel)((Object)((Object)jobServerAddView.jobServersTable.getModel()))).getValueAt(modelFromRow);
                    if (monitor != null) {
                        jobs.add(monitor);
                    }
                    ++n2;
                }
                for (ObjectMonitor monitor : jobs) {
                    IJobServer server = (IJobServer)monitor.getObject();
                    try {
                        ((JobServerEditModel)((Object)((Object)jobServerAddView.jobServersTable.getModel()))).removeRow(monitor);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace();
                    }
                    if (addedServers.contains(monitor)) continue;
                    deletedServers.add(monitor);
                }
            }
        });
        jv.closeButton.addActionListener(al -> {
            jd.setReturnStatus(1);
            StringBuilder message = new StringBuilder("Do you want to ");
            if (deletedServers.size() > 0) {
                message.append(" delete ").append(deletedServers.size()).append("  job(s)");
            }
            if (addedServers.size() > 0) {
                message.append(deletedServers.size() > 0 ? " and " : "").append(" add ").append(addedServers.size()).append(" jobs");
            }
            if (deletedServers.size() == 0 && addedServers.size() == 0) {
                message.append("save changes");
            }
            message.append("?");
            if (JOptionPane.showConfirmDialog((Component)((Object)jd), message.toString(), "Confirm changes", 0) == 0) {
                new BackgroundRunner(() -> {
                    ObjectMonitor obj;
                    int failed = 0;
                    ArrayList<ObjectMonitor> finalList = new ArrayList<ObjectMonitor>();
                    int i = 0;
                    while (i < serversForEdit.size()) {
                        obj = (ObjectMonitor)serversForEdit.get(i);
                        if (((IJobServer)obj.getObject()).getJobServerManager().save((IJobServer)obj.getObject())) {
                            finalList.add(obj);
                        } else {
                            ++failed;
                        }
                        ++i;
                    }
                    i = 0;
                    while (i < deletedServers.size()) {
                        obj = (ObjectMonitor)deletedServers.get(i);
                        ((IJobServer)obj.getObject()).getJobServerManager().delete((IJobServer)obj.getObject());
                        ++i;
                    }
                    return finalList;
                }, list3 -> {
                    if (list3.size() != serversForEdit.size()) {
                        JOptionPane.showMessageDialog((Component)((Object)jd), serversForEdit.size() - list3.size() + "/" + list3.size() + " servers couldn't be saved");
                    }
                    servers.clear();
                    servers.addAll((Collection<ObjectMonitor<IJobServer>>)list3);
                }).execute();
            }
            jd.setVisible(false);
        });
        jv.cancelButton.addActionListener(a -> {
            jd.setReturnStatus(0);
            jd.setVisible(false);
        });
        jv.jobServersTable.getSelectionModel().addListSelectionListener(l -> this.enableSelectionControls(jv));
        this.enableSelectionControls(jv);
        jd.setVisible(true);
    }

    private void enableSelectionControls(JobServerAddView view) {
        int selected = view.jobServersTable.getSelectedRowCount();
        view.deleteServerButton.setEnabled(selected > 0);
    }
}

