/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.core.ValueHolder;
import com.sigge.filerunner.view.JMemoryDialog;
import com.sigge.filerunner.view.core.LabelledCellRenderer;
import com.sigge.filerunner.view.jobs.IJob;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.IJobServerManager;
import com.sigge.filerunner.view.jobs.JobServerView;
import com.sigge.filerunner.view.jobs.StandardJobCommand;
import com.siggemannen.backgroundrunner.BackgroundRunner;
import com.siggemannen.binding.Binder;
import java.awt.Dialog;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComboBox;
import javax.swing.JFrame;

public class JobEditor {
    private final JFrame mainFrame;

    public JobEditor(JFrame mainFrame) {
        this.mainFrame = mainFrame;
    }

    public void edit(List<IJobServerManager> managers, List<IJobServer> servers) {
        JobServerView jv = new JobServerView();
        JMemoryDialog jd = new JMemoryDialog(this.mainFrame, "Job editor", false, "job-editor");
        jd.setModalityType(Dialog.ModalityType.DOCUMENT_MODAL);
        jd.getContentPane().add(jv);
        jd.pack();
        jd.centerOnCorrectScreen(this.mainFrame);
        ArrayList<IJobServer> jobs = new ArrayList<IJobServer>(servers);
        jobs.add(0, null);
        Binder.bindToCombo(jv.serverList, jobs);
        jv.serverList.setRenderer(new LabelledCellRenderer(true));
        jv.serverList.addItemListener(il -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server != null) {
                new BackgroundRunner(() -> server.getJobs(xxx -> {
                    Binder.bindToCombo((JComboBox)jobServerView.jobListCombo, (List)xxx);
                    this.enableButtons(jv);
                })).execute();
            }
            jobServerView.newButton.setEnabled(server != null);
            jobServerView.duplicateButton.setEnabled(server != null);
        });
        jv.jobListCombo.setRenderer(new LabelledCellRenderer());
        jv.jobListCombo.addItemListener(il -> this.enableButtons(jv));
        this.enableButtons(jv);
        ValueHolder job = new ValueHolder();
        jv.newButton.addActionListener(al -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server == null) {
                return;
            }
            job.setValue(server.addJob(jobServerView.mainFramePanel));
        });
        jv.saveButton.addActionListener(al -> {
            IJobServer server = this.getCurrentJobServer(jv);
            if (server == null) {
                return;
            }
            IJob jobToSave = (IJob)job.getValue();
            if (jobToSave == null) {
                return;
            }
            ArrayList<IJob> jobargs = new ArrayList<IJob>();
            jobargs.add(jobToSave);
            new BackgroundRunner(() -> server.execute(StandardJobCommand.SAVE, jobargs, null), res -> {
                if (res.isOK()) {
                    jd.setVisible(false);
                }
            }).execute();
        });
        jv.closeButton.addActionListener(al -> jd.setVisible(false));
        jd.setVisible(true);
    }

    private IJobServer getCurrentJobServer(JobServerView view) {
        return (IJobServer)view.serverList.getSelectedItem();
    }

    private void enableButtons(JobServerView view) {
        Object item = view.jobListCombo.getSelectedItem();
        view.duplicateButton.setEnabled(item != null);
        view.removeButton.setEnabled(item != null);
        view.editButton.setEnabled(item != null);
    }
}

