/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.jobs;

import com.sigge.filerunner.sql.sqlserver.jobs.ICommandResult;
import com.sigge.filerunner.view.JMemoryFrame;
import com.sigge.filerunner.view.jobs.IJobObject;
import com.sigge.filerunner.view.jobs.IJobServer;
import com.sigge.filerunner.view.jobs.JobAction;
import com.sigge.filerunner.view.jobs.JobView;
import com.sigge.filerunner.view.jobs.JobViewModel;
import com.sigge.filerunner.view.jobs.StandardJobCommand;
import com.siggemannen.view.UIBackgroundRunner;
import com.siggemannen.view.UIOptionBuilderSupplier;
import com.siggemannen.view.UIOptionSupplier;
import com.siggemannen.view.multiple.MultipleUIBackgroundRunner;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.RootPaneContainer;

class EnableDisableJobAction
implements ActionListener {
    private final JMemoryFrame jd;
    private final JobView jv;
    private final JobViewModel jm;
    private final MultipleUIBackgroundRunner runner;

    EnableDisableJobAction(MultipleUIBackgroundRunner runner, JMemoryFrame jd, JobView jv, JobViewModel jm) {
        this.runner = runner;
        this.jd = jd;
        this.jv = jv;
        this.jm = jm;
    }

    @Override
    public void actionPerformed(ActionEvent al) {
        Map<IJobServer, List<IJobObject>> jobs = JobAction.getSelectedJobs((JTable)((Object)this.jv.jobTable), this.jm);
        AtomicInteger enabledCount = new AtomicInteger(0);
        AtomicInteger disabledCount = new AtomicInteger(0);
        AtomicInteger count = new AtomicInteger(0);
        jobs.values().stream().flatMap(Collection::stream).forEach(jo -> {
            count.incrementAndGet();
            if (jo.isEnabled()) {
                enabledCount.incrementAndGet();
            } else {
                disabledCount.incrementAndGet();
            }
        });
        if (count.get() == 0) {
            return;
        }
        StandardJobCommand command = null;
        if (enabledCount.get() == 0) {
            if (JOptionPane.showConfirmDialog(this.jd, "Do you want to enable " + count + " jobs?", "Confirm", 0) == 1) {
                return;
            }
            command = StandardJobCommand.ENABLE;
        } else if (disabledCount.get() == 0) {
            if (JOptionPane.showConfirmDialog(this.jd, "Do you want to disable " + count + " jobs?", "Confirm", 0) == 1) {
                return;
            }
            command = StandardJobCommand.DISABLE;
        } else {
            int result = JOptionPane.showOptionDialog(this.jd, "Do you want to enable or disable " + count + " jobs?", "Confirm", 1, 3, null, new Object[]{"Enable jobs", "Disable jobs", "Cancel"}, "Cancel");
            switch (result) {
                case 2: {
                    return;
                }
                case 0: {
                    command = StandardJobCommand.ENABLE;
                }
                case 1: {
                    command = StandardJobCommand.DISABLE;
                }
            }
        }
        StandardJobCommand finalCommand = command;
        boolean advancedCommand = false;
        for (IJobServer server : jobs.keySet()) {
            if (!server.needsParameters(finalCommand)) continue;
            advancedCommand = true;
            break;
        }
        if (advancedCommand) {
            ArrayList<ICommandResult<IJobObject>> results = new ArrayList<ICommandResult<IJobObject>>();
            for (IJobServer server : jobs.keySet()) {
                ICommandResult<IJobObject> result = server.execute(command, jobs.get(server), this.runner);
                results.add(result);
                if (result.isCancelled()) break;
                this.runner.setVisible(true);
            }
            return;
        }
        UIBackgroundRunner.execute((UIOptionSupplier)((UIOptionSupplier)((UIOptionBuilderSupplier)new UIOptionBuilderSupplier(() -> {
            ArrayList<ICommandResult<IJobObject>> results = new ArrayList<ICommandResult<IJobObject>>();
            for (IJobServer server : jobs.keySet()) {
                ICommandResult<IJobObject> result = server.execute(finalCommand, (List)jobs.get(server));
                results.add(result);
            }
            return results;
        }, cb -> System.out.println(cb)).mainPanel((RootPaneContainer)this.jd)).build()));
    }
}

