/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.google.inject.Singleton;
import com.sigge.filerunner.core.DocumentListenerAdapter;
import com.sigge.filerunner.core.FilterHelper;
import com.sigge.filerunner.view.core.JListUtils;
import com.sigge.filerunner.view.core.RowFilterExtension;
import com.sigge.filerunner.view.editors.SnippetView;
import com.sigge.filerunner.view.tools.SQLTool;
import com.siggemannen.binding.AModel;
import com.siggemannen.binding.APresenter;
import com.siggemannen.binding.APropertyListModel;
import com.siggemannen.binding.IProperty;
import com.siggemannen.binding.ListModelClass;
import java.awt.Component;
import java.util.List;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JList;
import javax.swing.ListCellRenderer;
import javax.swing.RowFilter;
import javax.swing.RowSorter;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jdesktop.swingx.sort.ListSortController;

@Singleton
public class SnippetInserter {
    public SQLTool present(List<SQLTool> actions, JFrame mainFrame) {
        SnippetView tv = new SnippetView();
        BindingHolder t = new BindingHolder();
        final BindingModel aModel = new BindingModel();
        t.setObjects(actions);
        APresenter<BindingHolder, BindingModel, SnippetView> presenter = new APresenter<BindingHolder, BindingModel, SnippetView>(aModel, tv){

            protected void initBindings() {
                this.bind((JList)((SnippetView)this.view).snippetList).to(aModel.objectsModel);
                this.bind((JTextComponent)((SnippetView)this.view).snippetText).to(aModel.command);
                RowFilterExtension re = new RowFilterExtension();
                ((SnippetView)this.view).snippetList.setSortable(true);
                ((SnippetView)this.view).snippetList.setRowFilter(re);
                ((SnippetView)this.view).searchField.setHint("Search for snippets");
                ((SnippetView)this.view).searchField.getDocument().addDocumentListener((DocumentListener)((Object)new DocumentListenerAdapter(() -> {
                    String filterText = ((SnippetView)this.view).searchField.getText();
                    re.filterOut(((BindingModel)this.model).objectsModel.getObject().stream().filter(v -> {
                        String regexFromString = FilterHelper.getRegexFromString2(filterText);
                        return v == null || filterText.length() == 0 || v.getCommand().matches(regexFromString) || v.getTitle().matches(regexFromString);
                    }), null);
                    ((SnippetView)this.view).snippetList.setRowFilter((RowFilter)re);
                })));
                JListUtils.bindArrowsToFilter(((SnippetView)this.view).searchField, (JComponent)((SnippetView)this.view).snippetList, ((SnippetView)this.view).openButton::doClick);
            }

            protected void afterObjectSet() {
                ListSortController sorter = new ListSortController(((BindingModel)this.model).objectsModel);
                ((SnippetView)this.view).snippetList.setCellRenderer((ListCellRenderer)new SQLToolCellRenderer());
                ((SnippetView)this.view).snippetList.setRowSorter((RowSorter)sorter);
                if (aModel.objectsModel.getSize() > 0) {
                    aModel.objectsModel.setSelectedItem(aModel.objectsModel.getElementAt(0));
                }
                ((SnippetView)this.view).snippetText.setCaretPosition(0);
            }
        };
        presenter.setObject((Object)t);
        boolean selected = tv.present(mainFrame);
        if (!selected) {
            return null;
        }
        return (SQLTool)((BindingModel)presenter.getModel()).objectsModel.getSelectedItem();
    }

    static class BindingHolder
    extends ListModelClass<SQLTool> {
        BindingHolder() {
        }
    }

    static class BindingModel
    extends AModel<BindingHolder> {
        final IProperty<String> title = this.getProperty("current.title");
        final IProperty<String> command = this.getProperty("current.command");
        final AModel.BoundedListProperty<SQLTool> objects = this.getBoundListProperty("objects", "current", new IProperty[]{this.command, this.title});
        final APropertyListModel<SQLTool> objectsModel = new APropertyListModel(this.objects);

        BindingModel() {
        }
    }

    class SQLToolCellRenderer
    extends DefaultListCellRenderer {
        SQLToolCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            SQLTool cb = (SQLTool)value;
            String val = cb.getTitle();
            return super.getListCellRendererComponent(list, val, index, isSelected, cellHasFocus);
        }
    }
}

