/*
 * Decompiled with CFR 0.152.
 */
package com.sigge.filerunner.view.editors;

import com.sigge.filerunner.completion.domain.SQLObject;
import com.sigge.filerunner.completion.domain.SQLObjectType;
import com.sigge.filerunner.sql.SQLManager;
import com.sigge.filerunner.sql.ServerDatabase;
import java.util.Comparator;
import java.util.List;

public class SQLObjectComparatorCreator {
    private final SQLManager manager;

    public SQLObjectComparatorCreator(SQLManager manager) {
        this.manager = manager;
    }

    public Comparator<SQLObject> createComparator() {
        Comparator cx = (o1, o2) -> {
            boolean c2;
            if (o1.getContext().getDatabase().equals(o2.getContext().getDatabase())) {
                return 0;
            }
            List<? extends ServerDatabase> sd = this.manager.getCurrents();
            boolean c = sd.contains(o1.getContext().getDatabase());
            return c == (c2 = sd.contains(o2.getContext().getDatabase())) ? 0 : (c ? -1 : 1);
        };
        return cx.thenComparing(SQLObject::getSQLType, (x, y) -> {
            if (x == y) {
                return 0;
            }
            return x == SQLObjectType.UNKNOWN ? 1 : (y == SQLObjectType.UNKNOWN ? -1 : 0);
        }).thenComparing(SQLObject::isSystemObject, Comparator.naturalOrder()).thenComparing(SQLObject::getSQLType, (o1, o2) -> Integer.compare(this.getObjectOrder((SQLObjectType)((Object)o1)), this.getObjectOrder((SQLObjectType)((Object)o2)))).thenComparing(SQLObject::getFullName, Comparator.nullsFirst(String.CASE_INSENSITIVE_ORDER));
    }

    private int getObjectOrder(SQLObjectType type) {
        switch (type) {
            case TABLE: 
            case INLINE_TABLE_FUNCTION: 
            case TABLE_FUNCTION: 
            case STORED_PROCEDURE: 
            case VIEW: {
                return 1;
            }
            case SCALAR_FUNCTION: {
                return 2;
            }
            case DATABASE: {
                return 3;
            }
        }
        return 4;
    }
}

